<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package lifescore
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>

    <!-- CSS -->
    <link href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo get_template_directory_uri(); ?>/css/style.css" rel="stylesheet">
    <link href="<?php echo get_template_directory_uri(); ?>/css/plugins.css" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/table.css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/demo.css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/swiper-bundle.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.3.0/css/bootstrap.min.css">
    <!-- Data Table CSS -->
    <link rel='stylesheet' href='https://cdn.datatables.net/1.13.5/css/dataTables.bootstrap5.min.css'>
    
    <!---------------- Font  ----------------->

    <link
        href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet">

    <!---------------- Font Awesome ----------------->

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css" />

    <title> MY Life Score </title>

</head>

<body  <?php body_class(); ?>>

    <header class="head_jam">
        <div class="container">
        <nav class="navbar_jam desktop-menubar">
      
                <a class="navbar-brand logo wow fadeInUp" href="<?php echo site_url() ?>"><img src="<?php echo get_template_directory_uri(); ?>/img/logo.png" alt="Logo"></a>
                <div class="collapse navbar-collapse" id="mynavbar">
<?php
			wp_nav_menu(
				array(
					'theme_location' => 'menu-1',
					'menu_id'        => 'primary-menu',
                    'container' => 'ul',
                    'menu_class'=> 'navbarnav_jam'
				)
			);
			?>
            </div>
    </nav>
        </div>

    </header>

<?php
$userid = get_current_user_id();
$result = $wpdb->get_results(sprintf('SELECT count(*) as total FROM wp_survey WHERE  user_id=' . $userid . ' and created_at>now() - interval 1 month'));
$total = $result[0]->total;
$orderArg = array(
    'customer_id' => $userid,
    'limit' => -1,
    "post_status" => array('processing', 'completed'),
    'orderby' => 'date',
    'order' => 'DESC',
);
$orders = wc_get_orders($orderArg);
if (!empty($orders)) {
?>
<style>
.disabled {
    pointer-events:none; //This makes it not clickable
    opacity:0.6;         //This grays it out to look disabled
}
</style>
<script>
document.getElementById("menu-item-601").style.display = "none";
/*document.getElementById("menu-item-601").childNodes[0].onclick = function() { return false;};*/
</script>
<?php
}
?>