<?php
/**
 * Template Name:Blogs Page
 *
 *
 */
get_header();

?>

<style>
    .blogs_section {
        padding-top: 120px;
        padding-bottom: 70px;
    }

    .blogs_heading h1 {
        text-align: center;
        color: #2E2B86;
        font-family: 'Montserrat';
        font-weight: bold;
        font-size: 30px;
        padding: 30px 0;
        margin-top: 30px;
    }

    .blog-thumbnail {
    width: 100%;
    height: 204px; /* Ensure this matches your desired height */
    object-fit: cover;
}

    /* SUb Media Start */




    @media (max-width: 300px) {


        #subNewsList .newsHeading-three {
            font-family: 'Slippy', sans-serif;
            font-weight: 400;
            font-size: 20px;
            line-height: 120%;
            color: #2E2B86;
            margin: 5px 0 3px 0;
            text-align: left;
        }

        #subNewsList .newsPara-one {
            font-family: 'Slippy', sans-serif;
            font-weight: 400;
            font-size: 12px;
            line-height: 140%;
            color: #6A6A6A;
            margin-bottom: 5px;
            text-align: left;
            opacity: 0.3;
        }

        #subNewsList .newsPara-two {
            font-family: 'Slippy', sans-serif;
            font-weight: 400;
            font-size: 20px;
            line-height: 140%;
            color: #6A6A6A;
            margin-bottom: 2px;
            padding-right: 0px;
            text-align: left;
        }


    }

    @media (min-width: 301px) and (max-width: 600px) {


        #subNewsList .newsHeading-three {
            font-family: 'Slippy', sans-serif;
            font-weight: 400;
            font-size: 20px;
            line-height: 120%;
            color: #2E2B86;
            margin: 5px 0 3px 0;
            text-align: left;
        }

        #subNewsList .newsPara-one {
            font-family: 'Slippy', sans-serif;
            font-weight: 400;
            font-size: 12px;
            line-height: 140%;
            color: #6A6A6A;
            margin-bottom: 5px;
            text-align: left;
            opacity: 0.3;
        }

        #subNewsList .newsPara-two {
            font-family: 'Slippy', sans-serif;
            font-weight: 400;
            font-size: 20px;
            line-height: 140%;
            color: #6A6A6A;
            margin-bottom: 2px;
            padding-right: 0px;
            text-align: left;
        }


    }

    @media (min-width: 601px) and (max-width: 900px) {


        #subNewsList .newsHeading-three {
            font-family: 'Slippy', sans-serif;
            font-weight: 400;
            font-size: 20px;
            line-height: 120%;
            color: #2E2B86;
            margin: 5px 0 3px 0;
            text-align: left;
        }

        #subNewsList .newsPara-one {
            font-family: 'Slippy', sans-serif;
            font-weight: 400;
            font-size: 12px;
            line-height: 140%;
            color: #6A6A6A;
            margin-bottom: 5px;
            text-align: left;
            opacity: 0.3;
        }

        #subNewsList .newsPara-two {
            font-family: 'Slippy', sans-serif;
            font-weight: 400;
            font-size: 20px;
            line-height: 140%;
            color: #6A6A6A;
            margin-bottom: 2px;
            padding-right: 20px;
            text-align: left;
        }


    }

    @media (min-width: 901px) and (max-width: 1028px) {



        #subNewsList .newsHeading-three {
            font-family: 'Slippy', sans-serif;
            font-weight: 400;
            font-size: 20px;
            line-height: 120%;
            color: #2E2B86;
            margin: 5px 0 3px 0;
            text-align: left;
        }

        #subNewsList .newsPara-one {
            font-family: 'Slippy', sans-serif;
            font-weight: 400;
            font-size: 12px;
            line-height: 140%;
            color: #6A6A6A;
            margin-bottom: 5px;
            text-align: left;
            opacity: 0.3;
        }

        #subNewsList .newsPara-two {
            font-family: 'Slippy', sans-serif;
            font-weight: 400;
            font-size: 19px;
            line-height: 140%;
            color: #6A6A6A;
            margin-bottom: 2px;
            padding-right: 3px;
            text-align: left;
        }


    }

    @media (min-width: 1029px) and (max-width: 1400px) {



        #subNewsList .newsHeading-three {
            font-family: 'Slippy', sans-serif;
            font-weight: 400;
            font-size: 20px;
            line-height: 120%;
            color: #2E2B86;
            margin: 5px 0 3px 0;
            text-align: left;
        }

        #subNewsList .newsPara-one {
            font-family: 'Slippy', sans-serif;
            font-weight: 400;
            font-size: 12px;
            line-height: 140%;
            color: #6A6A6A;
            margin-bottom: 5px;
            text-align: left;
            opacity: 0.3;
        }

        #subNewsList .newsPara-two {
            font-family: 'Slippy', sans-serif;
            font-weight: 400;
            font-size: 19px;
            line-height: 140%;
            color: #6A6A6A;
            margin-bottom: 2px;
            padding-right: 3px;
            text-align: left;
        }


    }

    @media (min-width: 1401px) and (max-width: 1440px) {


        #subNewsList .newsHeading-three {
            font-family: 'Slippy', sans-serif;
            font-weight: 400;
            font-size: 20px;
            line-height: 120%;
            color: #2E2B86;
            margin: 5px 0 3px 0;
            text-align: left;
        }

        #subNewsList .newsPara-one {
            font-family: 'Slippy', sans-serif;
            font-weight: 400;
            font-size: 12px;
            line-height: 140%;
            color: #6A6A6A;
            margin-bottom: 5px;
            text-align: left;
            opacity: 0.3;
        }

        #subNewsList .newsPara-two {
            font-family: 'Slippy', sans-serif;
            font-weight: 400;
            font-size: 20px;
            line-height: 140%;
            color: #6A6A6A;
            margin-bottom: 2px;
            padding-right: 20px;
            text-align: left;
        }


    }

    @media (min-width: 1441px) {

        #subNewsList .newsHeading-three {
            font-family: 'Slippy', sans-serif;
            font-weight: 400;
            font-size: 22px;
            line-height: 120%;
            color: #2E2B86;
            margin: 5px 0 3px 0;
            text-align: left;

        }

        #subNewsList .newsHeading-three {
            font-family: 'Slippy', sans-serif;
            font-weight: 400;
            font-size: 22px;
            line-height: 120%;
            color: #2E2B86;
            margin: 5px 0 3px 0;
            text-align: left;

        }


        #subNewsList .newsPara-one {
            font-family: 'Slippy', sans-serif;
            font-weight: 400;
            font-size: 14px;
            line-height: 140%;
            color: #6A6A6A;
            margin-bottom: 5px;
            text-align: left;
            opacity: 0.3;
        }

        #subNewsList .newsPara-two {
            font-family: 'Slippy', sans-serif;
            font-weight: 400;
            font-size: 22px;
            line-height: 140%;
            color: #6A6A6A;
            margin-bottom: 2px;
            padding-right: 0px;
            text-align: left;
        }


    }

    /* Sub Media End */
</style>

<div style="background: rgb(46 43 134 / 10%);">
    <section class="blogs_section">
        <div class="container-fluid">
            <div class="blogs_heading">
                <h1>
                    Articles
                </h1>
            </div>
        </div>
    </section>




    <section id="subNewsList" style="position: relative;z-index: 1; padding: 40px 0px">
        <div class="container-fluid">
            <div class="col-xl-11 col-md-10 col-12 mx-auto">
                <div class="row">
<?php

$current_user_id = get_current_user_id();

if ( $current_user_id ) {
    // User is logged in
    // echo "Current User ID: " . $current_user_id; 
}

$order_args = array(
    'customer_id' => $current_user_id,
    'limit' => -1,
    'post_status' => array('processing', 'completed'),
    'orderby' => 'date',
    'order' => 'DESC',
);
$orders = wc_get_orders($order_args);

if (empty($orders)) {
    // User has no orders, display free articles
    display_free_articles(); 
} else {
    $order = $orders[0]; 
    $order_date = $order->get_date_created();
    $has_subscription = $order->get_meta('wps_sfw_order_has_subscription');

    if ($has_subscription !== 'yes') {
        // User has an order but no subscription, display free articles
        display_free_articles(); 
    } else {
        // User has a subscription, determine if they have access

        $items = $order->get_items();
        $attributes = array();

        foreach ($items as $item) {
            $product_id = $item->get_product_id();
            $attributes = get_post_meta($product_id);
            break; // Assuming only the first product is relevant.
        }

        if (empty($attributes)) {
            return new WP_Error('no_product_data', 'No product data found.', array('status' => 404));
        }

        $number = isset($attributes['wps_sfw_subscription_number'][0]) ? (int)$attributes['wps_sfw_subscription_number'][0] : 0;
        $interval = isset($attributes['wps_sfw_subscription_interval'][0]) ? $attributes['wps_sfw_subscription_interval'][0] : '';

        $days_to_add = $number;
        $new_date = $order_date;

        if ($interval === 'year') {
            $new_date = $new_date->modify("+$days_to_add years");
        } elseif ($interval === 'days') {
            $new_date = $new_date->modify("+$days_to_add days");
        } elseif ($interval === 'weeks') {
            $new_date = $new_date->modify("+$days_to_add weeks");
        } elseif ($interval === 'months') {
            $new_date = $new_date->modify("+$days_to_add months");
        }

        $current_time = current_time('timestamp');
        $expiry_time = strtotime($new_date->format('Y-m-d H:i:s'));

        if ($current_time > $expiry_time) {
            // Subscription has expired, display free articles
            display_free_articles(); 
        } else {
            // Subscription is active, display all articles
            display_all_articles(); 
        }
    }
}

function display_free_articles() {
    $args = array(
        'post_type' => 'articles',
        'posts_per_page' => 4,
        'post_status' => 'publish', 
        'meta_query' => array(
            array(
                'key' => 'article_type',
                'value' => 'Free',
                'compare' => '=',
            ),
        ),
    );
    $blog_posts = new WP_Query($args);

    if ($blog_posts->have_posts()) :
        while ($blog_posts->have_posts()) : $blog_posts->the_post(); ?>
            <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-5"> 
<div class="card shadow border-0 px-2">
											<img src="<?php the_post_thumbnail_url('medium'); ?>" class="img-fluid card-img-top w-100 mt-2 rounded blog-thumbnail">
											<div class="card-body px-0 pt-1">
												<a href="<?php the_permalink(); ?>" style="text-decoration: none;">
                                   <h1 class="newsHeading-three"><?php echo wp_trim_words(get_the_title(), 15, '...'); ?></h1>
												</a>
												<p class="newsPara-one">Posted on: <?php echo get_the_date('d F, Y'); ?></p>
												<p class="newsPara-two"><?php echo wp_trim_words(get_the_excerpt(), 20); ?></p>
											</div>
										</div>
                </div>
        <?php endwhile;
        wp_reset_postdata();
    else : ?>
        <p><?php _e('Sorry, no free posts are available.'); ?></p>
    <?php endif;
}

function display_all_articles() {
    $args = array(
        'post_type' => 'articles',
        'posts_per_page' => 4,
        'post_status' => 'publish', 
    );
    $blog_posts = new WP_Query($args);

    if ($blog_posts->have_posts()) :
        while ($blog_posts->have_posts()) : $blog_posts->the_post(); ?>
            <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-5">
										<div class="card h-100 shadow border-0 px-2">
											<img src="<?php the_post_thumbnail_url('medium'); ?>" class="img-fluid card-img-top w-100 mt-2 rounded blog-thumbnail">
											<div class="card-body d-flex flex-column px-0 pt-1">
												<a href="<?php the_permalink(); ?>" style="text-decoration: none;">
										<h1 class="newsHeading-three"><?php echo wp_trim_words(get_the_title(), 4, '...'); ?></h1>
												</a>
												<p class="newsPara-one">Posted on: <?php echo get_the_date('d F, Y'); ?></p>
												<p class="newsPara-two flex-grow-1"><?php echo wp_trim_words(get_the_excerpt(), 25); ?></p>
											</div>
										</div>
                </div>
        <?php endwhile;
        wp_reset_postdata();
    else : ?>
        <p><?php _e('Sorry, no posts are available.'); ?></p>
    <?php endif;
}

?>					
                    <!-- <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-5">
                     <div class="card shadow  border-0 px-2">
                         <img src="img/slide1.jpg" class="img-fluid card-img-top mt-2 rounded"
                             style="height: 204px; object-fit: cover;">
                         <div class="card-body px-0 pt-1">
                             <a href="" style="text-decoration: none;">
                                 <h1 class="newsHeading-three">1st cyclotron build</h1>
                             </a>
                             <p class="newsPara-one">Posted on: 24 June, 23</p>
                             <p class="newsPara-two">Quisque suscipit fermentum netus nulla cras porttitor euismod nulla.
                             </p>
                         </div>
                     </div>
                 </div>
                 <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-5">
                     <div class="card shadow  border-0 px-2">
                         <img src="assets/images/card-image-1.png" class="img-fluid card-img-top mt-2 rounded"
                             style="height: 204px; object-fit: cover;">
                         <div class="card-body px-0 pt-1">
                             <a href="" style="text-decoration: none;">
                                 <h1 class="newsHeading-three">1st cyclotron build</h1>
                             </a>
                             <p class="newsPara-one">Posted on: 24 June, 23</p>
                             <p class="newsPara-two">Quisque suscipit fermentum netus nulla cras porttitor euismod nulla.
                             </p>
                         </div>
                     </div>
                 </div>
                 <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-5">
                     <div class="card shadow  border-0 px-2">
                         <img src="assets/images/card-image-1.png" class="img-fluid card-img-top mt-2 rounded"
                             style="height: 204px; object-fit: cover;">
                         <div class="card-body px-0 pt-1">
                             <a href="" style="text-decoration: none;">
                                 <h1 class="newsHeading-three">1st cyclotron build</h1>
                             </a>
                             <p class="newsPara-one">Posted on: 24 June, 23</p>
                             <p class="newsPara-two">Quisque suscipit fermentum netus nulla cras porttitor euismod nulla.
                             </p>
                         </div>
                     </div>
                 </div> -->
                </div>
            </div>
        </div>
    </section>
</div>
<?php
get_footer();
