/*!
 * Chart.js v2.9.4
 * https://www.chartjs.org
 * (c) 2020 Chart.js Contributors
 * Released under the MIT License
 */
(function(global,factory){typeof exports==='object'&&typeof module!=='undefined'?module.exports=factory(function(){try{return require('moment')}catch(e){}}()):typeof define==='function'&&define.amd?define(['require'],function(require){return factory(function(){try{return require('moment')}catch(e){}}())}):(global=global||self,global.Chart=factory(global.moment))}(this,(function(moment){'use strict';moment=moment&&moment.hasOwnProperty('default')?moment['default']:moment;function createCommonjsModule(fn,module){return module={exports:{}},fn(module,module.exports),module.exports}
function getCjsExportFromNamespace(n){return n&&n['default']||n}
var colorName={"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aqua":[0,255,255],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"black":[0,0,0],"blanchedalmond":[255,235,205],"blue":[0,0,255],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"fuchsia":[255,0,255],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"gray":[128,128,128],"green":[0,128,0],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"lime":[0,255,0],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"maroon":[128,0,0],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"navy":[0,0,128],"oldlace":[253,245,230],"olive":[128,128,0],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"purple":[128,0,128],"rebeccapurple":[102,51,153],"red":[255,0,0],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"silver":[192,192,192],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"teal":[0,128,128],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"white":[255,255,255],"whitesmoke":[245,245,245],"yellow":[255,255,0],"yellowgreen":[154,205,50]};var conversions=createCommonjsModule(function(module){var reverseKeywords={};for(var key in colorName){if(colorName.hasOwnProperty(key)){reverseKeywords[colorName[key]]=key}}
var convert=module.exports={rgb:{channels:3,labels:'rgb'},hsl:{channels:3,labels:'hsl'},hsv:{channels:3,labels:'hsv'},hwb:{channels:3,labels:'hwb'},cmyk:{channels:4,labels:'cmyk'},xyz:{channels:3,labels:'xyz'},lab:{channels:3,labels:'lab'},lch:{channels:3,labels:'lch'},hex:{channels:1,labels:['hex']},keyword:{channels:1,labels:['keyword']},ansi16:{channels:1,labels:['ansi16']},ansi256:{channels:1,labels:['ansi256']},hcg:{channels:3,labels:['h','c','g']},apple:{channels:3,labels:['r16','g16','b16']},gray:{channels:1,labels:['gray']}};for(var model in convert){if(convert.hasOwnProperty(model)){if(!('channels' in convert[model])){throw new Error('missing channels property: '+model)}
if(!('labels' in convert[model])){throw new Error('missing channel labels property: '+model)}
if(convert[model].labels.length!==convert[model].channels){throw new Error('channel and label counts mismatch: '+model)}
var channels=convert[model].channels;var labels=convert[model].labels;delete convert[model].channels;delete convert[model].labels;Object.defineProperty(convert[model],'channels',{value:channels});Object.defineProperty(convert[model],'labels',{value:labels})}}
convert.rgb.hsl=function(rgb){var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;var min=Math.min(r,g,b);var max=Math.max(r,g,b);var delta=max-min;var h;var s;var l;if(max===min){h=0}else if(r===max){h=(g-b)/delta}else if(g===max){h=2+(b-r)/delta}else if(b===max){h=4+(r-g)/delta}
h=Math.min(h*60,360);if(h<0){h+=360}
l=(min+max)/2;if(max===min){s=0}else if(l<=0.5){s=delta/(max+min)}else{s=delta/(2-max-min)}
return[h,s*100,l*100]};convert.rgb.hsv=function(rgb){var rdif;var gdif;var bdif;var h;var s;var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;var v=Math.max(r,g,b);var diff=v-Math.min(r,g,b);var diffc=function(c){return(v-c)/6/diff+1/2};if(diff===0){h=s=0}else{s=diff/v;rdif=diffc(r);gdif=diffc(g);bdif=diffc(b);if(r===v){h=bdif-gdif}else if(g===v){h=(1/3)+rdif-bdif}else if(b===v){h=(2/3)+gdif-rdif}
if(h<0){h+=1}else if(h>1){h-=1}}
return[h*360,s*100,v*100]};convert.rgb.hwb=function(rgb){var r=rgb[0];var g=rgb[1];var b=rgb[2];var h=convert.rgb.hsl(rgb)[0];var w=1/255*Math.min(r,Math.min(g,b));b=1-1/255*Math.max(r,Math.max(g,b));return[h,w*100,b*100]};convert.rgb.cmyk=function(rgb){var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;var c;var m;var y;var k;k=Math.min(1-r,1-g,1-b);c=(1-r-k)/(1-k)||0;m=(1-g-k)/(1-k)||0;y=(1-b-k)/(1-k)||0;return[c*100,m*100,y*100,k*100]};function comparativeDistance(x,y){return(Math.pow(x[0]-y[0],2)+Math.pow(x[1]-y[1],2)+Math.pow(x[2]-y[2],2))}
convert.rgb.keyword=function(rgb){var reversed=reverseKeywords[rgb];if(reversed){return reversed}
var currentClosestDistance=Infinity;var currentClosestKeyword;for(var keyword in colorName){if(colorName.hasOwnProperty(keyword)){var value=colorName[keyword];var distance=comparativeDistance(rgb,value);if(distance<currentClosestDistance){currentClosestDistance=distance;currentClosestKeyword=keyword}}}
return currentClosestKeyword};convert.keyword.rgb=function(keyword){return colorName[keyword]};convert.rgb.xyz=function(rgb){var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;r=r>0.04045?Math.pow(((r+0.055)/1.055),2.4):(r/12.92);g=g>0.04045?Math.pow(((g+0.055)/1.055),2.4):(g/12.92);b=b>0.04045?Math.pow(((b+0.055)/1.055),2.4):(b/12.92);var x=(r*0.4124)+(g*0.3576)+(b*0.1805);var y=(r*0.2126)+(g*0.7152)+(b*0.0722);var z=(r*0.0193)+(g*0.1192)+(b*0.9505);return[x*100,y*100,z*100]};convert.rgb.lab=function(rgb){var xyz=convert.rgb.xyz(rgb);var x=xyz[0];var y=xyz[1];var z=xyz[2];var l;var a;var b;x/=95.047;y/=100;z/=108.883;x=x>0.008856?Math.pow(x,1/3):(7.787*x)+(16/116);y=y>0.008856?Math.pow(y,1/3):(7.787*y)+(16/116);z=z>0.008856?Math.pow(z,1/3):(7.787*z)+(16/116);l=(116*y)-16;a=500*(x-y);b=200*(y-z);return[l,a,b]};convert.hsl.rgb=function(hsl){var h=hsl[0]/360;var s=hsl[1]/100;var l=hsl[2]/100;var t1;var t2;var t3;var rgb;var val;if(s===0){val=l*255;return[val,val,val]}
if(l<0.5){t2=l*(1+s)}else{t2=l+s-l*s}
t1=2*l-t2;rgb=[0,0,0];for(var i=0;i<3;i++){t3=h+1/3*-(i-1);if(t3<0){t3++}
if(t3>1){t3--}
if(6*t3<1){val=t1+(t2-t1)*6*t3}else if(2*t3<1){val=t2}else if(3*t3<2){val=t1+(t2-t1)*(2/3-t3)*6}else{val=t1}
rgb[i]=val*255}
return rgb};convert.hsl.hsv=function(hsl){var h=hsl[0];var s=hsl[1]/100;var l=hsl[2]/100;var smin=s;var lmin=Math.max(l,0.01);var sv;var v;l*=2;s*=(l<=1)?l:2-l;smin*=lmin<=1?lmin:2-lmin;v=(l+s)/2;sv=l===0?(2*smin)/(lmin+smin):(2*s)/(l+s);return[h,sv*100,v*100]};convert.hsv.rgb=function(hsv){var h=hsv[0]/60;var s=hsv[1]/100;var v=hsv[2]/100;var hi=Math.floor(h)%6;var f=h-Math.floor(h);var p=255*v*(1-s);var q=255*v*(1-(s*f));var t=255*v*(1-(s*(1-f)));v*=255;switch(hi){case 0:return[v,t,p];case 1:return[q,v,p];case 2:return[p,v,t];case 3:return[p,q,v];case 4:return[t,p,v];case 5:return[v,p,q]}};convert.hsv.hsl=function(hsv){var h=hsv[0];var s=hsv[1]/100;var v=hsv[2]/100;var vmin=Math.max(v,0.01);var lmin;var sl;var l;l=(2-s)*v;lmin=(2-s)*vmin;sl=s*vmin;sl/=(lmin<=1)?lmin:2-lmin;sl=sl||0;l/=2;return[h,sl*100,l*100]};convert.hwb.rgb=function(hwb){var h=hwb[0]/360;var wh=hwb[1]/100;var bl=hwb[2]/100;var ratio=wh+bl;var i;var v;var f;var n;if(ratio>1){wh/=ratio;bl/=ratio}
i=Math.floor(6*h);v=1-bl;f=6*h-i;if((i&0x01)!==0){f=1-f}
n=wh+f*(v-wh);var r;var g;var b;switch(i){default:case 6:case 0:r=v;g=n;b=wh;break;case 1:r=n;g=v;b=wh;break;case 2:r=wh;g=v;b=n;break;case 3:r=wh;g=n;b=v;break;case 4:r=n;g=wh;b=v;break;case 5:r=v;g=wh;b=n;break}
return[r*255,g*255,b*255]};convert.cmyk.rgb=function(cmyk){var c=cmyk[0]/100;var m=cmyk[1]/100;var y=cmyk[2]/100;var k=cmyk[3]/100;var r;var g;var b;r=1-Math.min(1,c*(1-k)+k);g=1-Math.min(1,m*(1-k)+k);b=1-Math.min(1,y*(1-k)+k);return[r*255,g*255,b*255]};convert.xyz.rgb=function(xyz){var x=xyz[0]/100;var y=xyz[1]/100;var z=xyz[2]/100;var r;var g;var b;r=(x*3.2406)+(y*-1.5372)+(z*-0.4986);g=(x*-0.9689)+(y*1.8758)+(z*0.0415);b=(x*0.0557)+(y*-0.2040)+(z*1.0570);r=r>0.0031308?((1.055*Math.pow(r,1.0/2.4))-0.055):r*12.92;g=g>0.0031308?((1.055*Math.pow(g,1.0/2.4))-0.055):g*12.92;b=b>0.0031308?((1.055*Math.pow(b,1.0/2.4))-0.055):b*12.92;r=Math.min(Math.max(0,r),1);g=Math.min(Math.max(0,g),1);b=Math.min(Math.max(0,b),1);return[r*255,g*255,b*255]};convert.xyz.lab=function(xyz){var x=xyz[0];var y=xyz[1];var z=xyz[2];var l;var a;var b;x/=95.047;y/=100;z/=108.883;x=x>0.008856?Math.pow(x,1/3):(7.787*x)+(16/116);y=y>0.008856?Math.pow(y,1/3):(7.787*y)+(16/116);z=z>0.008856?Math.pow(z,1/3):(7.787*z)+(16/116);l=(116*y)-16;a=500*(x-y);b=200*(y-z);return[l,a,b]};convert.lab.xyz=function(lab){var l=lab[0];var a=lab[1];var b=lab[2];var x;var y;var z;y=(l+16)/116;x=a/500+y;z=y-b/200;var y2=Math.pow(y,3);var x2=Math.pow(x,3);var z2=Math.pow(z,3);y=y2>0.008856?y2:(y-16/116)/7.787;x=x2>0.008856?x2:(x-16/116)/7.787;z=z2>0.008856?z2:(z-16/116)/7.787;x*=95.047;y*=100;z*=108.883;return[x,y,z]};convert.lab.lch=function(lab){var l=lab[0];var a=lab[1];var b=lab[2];var hr;var h;var c;hr=Math.atan2(b,a);h=hr*360/2/Math.PI;if(h<0){h+=360}
c=Math.sqrt(a*a+b*b);return[l,c,h]};convert.lch.lab=function(lch){var l=lch[0];var c=lch[1];var h=lch[2];var a;var b;var hr;hr=h/360*2*Math.PI;a=c*Math.cos(hr);b=c*Math.sin(hr);return[l,a,b]};convert.rgb.ansi16=function(args){var r=args[0];var g=args[1];var b=args[2];var value=1 in arguments?arguments[1]:convert.rgb.hsv(args)[2];value=Math.round(value/50);if(value===0){return 30}
var ansi=30+((Math.round(b/255)<<2)|(Math.round(g/255)<<1)|Math.round(r/255));if(value===2){ansi+=60}
return ansi};convert.hsv.ansi16=function(args){return convert.rgb.ansi16(convert.hsv.rgb(args),args[2])};convert.rgb.ansi256=function(args){var r=args[0];var g=args[1];var b=args[2];if(r===g&&g===b){if(r<8){return 16}
if(r>248){return 231}
return Math.round(((r-8)/247)*24)+232}
var ansi=16+(36*Math.round(r/255*5))+(6*Math.round(g/255*5))+Math.round(b/255*5);return ansi};convert.ansi16.rgb=function(args){var color=args%10;if(color===0||color===7){if(args>50){color+=3.5}
color=color/10.5*255;return[color,color,color]}
var mult=(~~(args>50)+1)*0.5;var r=((color&1)*mult)*255;var g=(((color>>1)&1)*mult)*255;var b=(((color>>2)&1)*mult)*255;return[r,g,b]};convert.ansi256.rgb=function(args){if(args>=232){var c=(args-232)*10+8;return[c,c,c]}
args-=16;var rem;var r=Math.floor(args/36)/5*255;var g=Math.floor((rem=args%36)/6)/5*255;var b=(rem%6)/5*255;return[r,g,b]};convert.rgb.hex=function(args){var integer=((Math.round(args[0])&0xFF)<<16)+((Math.round(args[1])&0xFF)<<8)+(Math.round(args[2])&0xFF);var string=integer.toString(16).toUpperCase();return'000000'.substring(string.length)+string};convert.hex.rgb=function(args){var match=args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);if(!match){return[0,0,0]}
var colorString=match[0];if(match[0].length===3){colorString=colorString.split('').map(function(char){return char+char}).join('')}
var integer=parseInt(colorString,16);var r=(integer>>16)&0xFF;var g=(integer>>8)&0xFF;var b=integer&0xFF;return[r,g,b]};convert.rgb.hcg=function(rgb){var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;var max=Math.max(Math.max(r,g),b);var min=Math.min(Math.min(r,g),b);var chroma=(max-min);var grayscale;var hue;if(chroma<1){grayscale=min/(1-chroma)}else{grayscale=0}
if(chroma<=0){hue=0}else if(max===r){hue=((g-b)/chroma)%6}else if(max===g){hue=2+(b-r)/chroma}else{hue=4+(r-g)/chroma+4}
hue/=6;hue%=1;return[hue*360,chroma*100,grayscale*100]};convert.hsl.hcg=function(hsl){var s=hsl[1]/100;var l=hsl[2]/100;var c=1;var f=0;if(l<0.5){c=2.0*s*l}else{c=2.0*s*(1.0-l)}
if(c<1.0){f=(l-0.5*c)/(1.0-c)}
return[hsl[0],c*100,f*100]};convert.hsv.hcg=function(hsv){var s=hsv[1]/100;var v=hsv[2]/100;var c=s*v;var f=0;if(c<1.0){f=(v-c)/(1-c)}
return[hsv[0],c*100,f*100]};convert.hcg.rgb=function(hcg){var h=hcg[0]/360;var c=hcg[1]/100;var g=hcg[2]/100;if(c===0.0){return[g*255,g*255,g*255]}
var pure=[0,0,0];var hi=(h%1)*6;var v=hi%1;var w=1-v;var mg=0;switch(Math.floor(hi)){case 0:pure[0]=1;pure[1]=v;pure[2]=0;break;case 1:pure[0]=w;pure[1]=1;pure[2]=0;break;case 2:pure[0]=0;pure[1]=1;pure[2]=v;break;case 3:pure[0]=0;pure[1]=w;pure[2]=1;break;case 4:pure[0]=v;pure[1]=0;pure[2]=1;break;default:pure[0]=1;pure[1]=0;pure[2]=w}
mg=(1.0-c)*g;return[(c*pure[0]+mg)*255,(c*pure[1]+mg)*255,(c*pure[2]+mg)*255]};convert.hcg.hsv=function(hcg){var c=hcg[1]/100;var g=hcg[2]/100;var v=c+g*(1.0-c);var f=0;if(v>0.0){f=c/v}
return[hcg[0],f*100,v*100]};convert.hcg.hsl=function(hcg){var c=hcg[1]/100;var g=hcg[2]/100;var l=g*(1.0-c)+0.5*c;var s=0;if(l>0.0&&l<0.5){s=c/(2*l)}else if(l>=0.5&&l<1.0){s=c/(2*(1-l))}
return[hcg[0],s*100,l*100]};convert.hcg.hwb=function(hcg){var c=hcg[1]/100;var g=hcg[2]/100;var v=c+g*(1.0-c);return[hcg[0],(v-c)*100,(1-v)*100]};convert.hwb.hcg=function(hwb){var w=hwb[1]/100;var b=hwb[2]/100;var v=1-b;var c=v-w;var g=0;if(c<1){g=(v-c)/(1-c)}
return[hwb[0],c*100,g*100]};convert.apple.rgb=function(apple){return[(apple[0]/65535)*255,(apple[1]/65535)*255,(apple[2]/65535)*255]};convert.rgb.apple=function(rgb){return[(rgb[0]/255)*65535,(rgb[1]/255)*65535,(rgb[2]/255)*65535]};convert.gray.rgb=function(args){return[args[0]/100*255,args[0]/100*255,args[0]/100*255]};convert.gray.hsl=convert.gray.hsv=function(args){return[0,0,args[0]]};convert.gray.hwb=function(gray){return[0,100,gray[0]]};convert.gray.cmyk=function(gray){return[0,0,0,gray[0]]};convert.gray.lab=function(gray){return[gray[0],0,0]};convert.gray.hex=function(gray){var val=Math.round(gray[0]/100*255)&0xFF;var integer=(val<<16)+(val<<8)+val;var string=integer.toString(16).toUpperCase();return'000000'.substring(string.length)+string};convert.rgb.gray=function(rgb){var val=(rgb[0]+rgb[1]+rgb[2])/3;return[val/255*100]}});var conversions_1=conversions.rgb;var conversions_2=conversions.hsl;var conversions_3=conversions.hsv;var conversions_4=conversions.hwb;var conversions_5=conversions.cmyk;var conversions_6=conversions.xyz;var conversions_7=conversions.lab;var conversions_8=conversions.lch;var conversions_9=conversions.hex;var conversions_10=conversions.keyword;var conversions_11=conversions.ansi16;var conversions_12=conversions.ansi256;var conversions_13=conversions.hcg;var conversions_14=conversions.apple;var conversions_15=conversions.gray;function buildGraph(){var graph={};var models=Object.keys(conversions);for(var len=models.length,i=0;i<len;i++){graph[models[i]]={distance:-1,parent:null}}
return graph}
function deriveBFS(fromModel){var graph=buildGraph();var queue=[fromModel];graph[fromModel].distance=0;while(queue.length){var current=queue.pop();var adjacents=Object.keys(conversions[current]);for(var len=adjacents.length,i=0;i<len;i++){var adjacent=adjacents[i];var node=graph[adjacent];if(node.distance===-1){node.distance=graph[current].distance+1;node.parent=current;queue.unshift(adjacent)}}}
return graph}
function link(from,to){return function(args){return to(from(args))}}
function wrapConversion(toModel,graph){var path=[graph[toModel].parent,toModel];var fn=conversions[graph[toModel].parent][toModel];var cur=graph[toModel].parent;while(graph[cur].parent){path.unshift(graph[cur].parent);fn=link(conversions[graph[cur].parent][cur],fn);cur=graph[cur].parent}
fn.conversion=path;return fn}
var route=function(fromModel){var graph=deriveBFS(fromModel);var conversion={};var models=Object.keys(graph);for(var len=models.length,i=0;i<len;i++){var toModel=models[i];var node=graph[toModel];if(node.parent===null){continue}
conversion[toModel]=wrapConversion(toModel,graph)}
return conversion};var convert={};var models=Object.keys(conversions);function wrapRaw(fn){var wrappedFn=function(args){if(args===undefined||args===null){return args}
if(arguments.length>1){args=Array.prototype.slice.call(arguments)}
return fn(args)};if('conversion' in fn){wrappedFn.conversion=fn.conversion}
return wrappedFn}
function wrapRounded(fn){var wrappedFn=function(args){if(args===undefined||args===null){return args}
if(arguments.length>1){args=Array.prototype.slice.call(arguments)}
var result=fn(args);if(typeof result==='object'){for(var len=result.length,i=0;i<len;i++){result[i]=Math.round(result[i])}}
return result};if('conversion' in fn){wrappedFn.conversion=fn.conversion}
return wrappedFn}
models.forEach(function(fromModel){convert[fromModel]={};Object.defineProperty(convert[fromModel],'channels',{value:conversions[fromModel].channels});Object.defineProperty(convert[fromModel],'labels',{value:conversions[fromModel].labels});var routes=route(fromModel);var routeModels=Object.keys(routes);routeModels.forEach(function(toModel){var fn=routes[toModel];convert[fromModel][toModel]=wrapRounded(fn);convert[fromModel][toModel].raw=wrapRaw(fn)})});var colorConvert=convert;var colorName$1={"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aqua":[0,255,255],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"black":[0,0,0],"blanchedalmond":[255,235,205],"blue":[0,0,255],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"fuchsia":[255,0,255],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"gray":[128,128,128],"green":[0,128,0],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"lime":[0,255,0],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"maroon":[128,0,0],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"navy":[0,0,128],"oldlace":[253,245,230],"olive":[128,128,0],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"purple":[128,0,128],"rebeccapurple":[102,51,153],"red":[255,0,0],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"silver":[192,192,192],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"teal":[0,128,128],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"white":[255,255,255],"whitesmoke":[245,245,245],"yellow":[255,255,0],"yellowgreen":[154,205,50]};var colorString={getRgba:getRgba,getHsla:getHsla,getRgb:getRgb,getHsl:getHsl,getHwb:getHwb,getAlpha:getAlpha,hexString:hexString,rgbString:rgbString,rgbaString:rgbaString,percentString:percentString,percentaString:percentaString,hslString:hslString,hslaString:hslaString,hwbString:hwbString,keyword:keyword};function getRgba(string){if(!string){return}
var abbr=/^#([a-fA-F0-9]{3,4})$/i,hex=/^#([a-fA-F0-9]{6}([a-fA-F0-9]{2})?)$/i,rgba=/^rgba?\(\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/i,per=/^rgba?\(\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/i,keyword=/(\w+)/;var rgb=[0,0,0],a=1,match=string.match(abbr),hexAlpha="";if(match){match=match[1];hexAlpha=match[3];for(var i=0;i<rgb.length;i++){rgb[i]=parseInt(match[i]+match[i],16)}
if(hexAlpha){a=Math.round((parseInt(hexAlpha+hexAlpha,16)/255)*100)/100}}else if(match=string.match(hex)){hexAlpha=match[2];match=match[1];for(var i=0;i<rgb.length;i++){rgb[i]=parseInt(match.slice(i*2,i*2+2),16)}
if(hexAlpha){a=Math.round((parseInt(hexAlpha,16)/255)*100)/100}}else if(match=string.match(rgba)){for(var i=0;i<rgb.length;i++){rgb[i]=parseInt(match[i+1])}
a=parseFloat(match[4])}else if(match=string.match(per)){for(var i=0;i<rgb.length;i++){rgb[i]=Math.round(parseFloat(match[i+1])*2.55)}
a=parseFloat(match[4])}else if(match=string.match(keyword)){if(match[1]=="transparent"){return[0,0,0,0]}
rgb=colorName$1[match[1]];if(!rgb){return}}
for(var i=0;i<rgb.length;i++){rgb[i]=scale(rgb[i],0,255)}
if(!a&&a!=0){a=1}else{a=scale(a,0,1)}
rgb[3]=a;return rgb}
function getHsla(string){if(!string){return}
var hsl=/^hsla?\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/;var match=string.match(hsl);if(match){var alpha=parseFloat(match[4]);var h=scale(parseInt(match[1]),0,360),s=scale(parseFloat(match[2]),0,100),l=scale(parseFloat(match[3]),0,100),a=scale(isNaN(alpha)?1:alpha,0,1);return[h,s,l,a]}}
function getHwb(string){if(!string){return}
var hwb=/^hwb\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/;var match=string.match(hwb);if(match){var alpha=parseFloat(match[4]);var h=scale(parseInt(match[1]),0,360),w=scale(parseFloat(match[2]),0,100),b=scale(parseFloat(match[3]),0,100),a=scale(isNaN(alpha)?1:alpha,0,1);return[h,w,b,a]}}
function getRgb(string){var rgba=getRgba(string);return rgba&&rgba.slice(0,3)}
function getHsl(string){var hsla=getHsla(string);return hsla&&hsla.slice(0,3)}
function getAlpha(string){var vals=getRgba(string);if(vals){return vals[3]}else if(vals=getHsla(string)){return vals[3]}else if(vals=getHwb(string)){return vals[3]}}
function hexString(rgba,a){var a=(a!==undefined&&rgba.length===3)?a:rgba[3];return"#"+hexDouble(rgba[0])+hexDouble(rgba[1])+hexDouble(rgba[2])+((a>=0&&a<1)?hexDouble(Math.round(a*255)):"")}
function rgbString(rgba,alpha){if(alpha<1||(rgba[3]&&rgba[3]<1)){return rgbaString(rgba,alpha)}
return"rgb("+rgba[0]+", "+rgba[1]+", "+rgba[2]+")"}
function rgbaString(rgba,alpha){if(alpha===undefined){alpha=(rgba[3]!==undefined?rgba[3]:1)}
return"rgba("+rgba[0]+", "+rgba[1]+", "+rgba[2]+", "+alpha+")"}
function percentString(rgba,alpha){if(alpha<1||(rgba[3]&&rgba[3]<1)){return percentaString(rgba,alpha)}
var r=Math.round(rgba[0]/255*100),g=Math.round(rgba[1]/255*100),b=Math.round(rgba[2]/255*100);return"rgb("+r+"%, "+g+"%, "+b+"%)"}
function percentaString(rgba,alpha){var r=Math.round(rgba[0]/255*100),g=Math.round(rgba[1]/255*100),b=Math.round(rgba[2]/255*100);return"rgba("+r+"%, "+g+"%, "+b+"%, "+(alpha||rgba[3]||1)+")"}
function hslString(hsla,alpha){if(alpha<1||(hsla[3]&&hsla[3]<1)){return hslaString(hsla,alpha)}
return"hsl("+hsla[0]+", "+hsla[1]+"%, "+hsla[2]+"%)"}
function hslaString(hsla,alpha){if(alpha===undefined){alpha=(hsla[3]!==undefined?hsla[3]:1)}
return"hsla("+hsla[0]+", "+hsla[1]+"%, "+hsla[2]+"%, "+alpha+")"}
function hwbString(hwb,alpha){if(alpha===undefined){alpha=(hwb[3]!==undefined?hwb[3]:1)}
return"hwb("+hwb[0]+", "+hwb[1]+"%, "+hwb[2]+"%"+(alpha!==undefined&&alpha!==1?", "+alpha:"")+")"}
function keyword(rgb){return reverseNames[rgb.slice(0,3)]}
function scale(num,min,max){return Math.min(Math.max(min,num),max)}
function hexDouble(num){var str=num.toString(16).toUpperCase();return(str.length<2)?"0"+str:str}
var reverseNames={};for(var name in colorName$1){reverseNames[colorName$1[name]]=name}
var Color=function(obj){if(obj instanceof Color){return obj}
if(!(this instanceof Color)){return new Color(obj)}
this.valid=!1;this.values={rgb:[0,0,0],hsl:[0,0,0],hsv:[0,0,0],hwb:[0,0,0],cmyk:[0,0,0,0],alpha:1};var vals;if(typeof obj==='string'){vals=colorString.getRgba(obj);if(vals){this.setValues('rgb',vals)}else if(vals=colorString.getHsla(obj)){this.setValues('hsl',vals)}else if(vals=colorString.getHwb(obj)){this.setValues('hwb',vals)}}else if(typeof obj==='object'){vals=obj;if(vals.r!==undefined||vals.red!==undefined){this.setValues('rgb',vals)}else if(vals.l!==undefined||vals.lightness!==undefined){this.setValues('hsl',vals)}else if(vals.v!==undefined||vals.value!==undefined){this.setValues('hsv',vals)}else if(vals.w!==undefined||vals.whiteness!==undefined){this.setValues('hwb',vals)}else if(vals.c!==undefined||vals.cyan!==undefined){this.setValues('cmyk',vals)}}};Color.prototype={isValid:function(){return this.valid},rgb:function(){return this.setSpace('rgb',arguments)},hsl:function(){return this.setSpace('hsl',arguments)},hsv:function(){return this.setSpace('hsv',arguments)},hwb:function(){return this.setSpace('hwb',arguments)},cmyk:function(){return this.setSpace('cmyk',arguments)},rgbArray:function(){return this.values.rgb},hslArray:function(){return this.values.hsl},hsvArray:function(){return this.values.hsv},hwbArray:function(){var values=this.values;if(values.alpha!==1){return values.hwb.concat([values.alpha])}
return values.hwb},cmykArray:function(){return this.values.cmyk},rgbaArray:function(){var values=this.values;return values.rgb.concat([values.alpha])},hslaArray:function(){var values=this.values;return values.hsl.concat([values.alpha])},alpha:function(val){if(val===undefined){return this.values.alpha}
this.setValues('alpha',val);return this},red:function(val){return this.setChannel('rgb',0,val)},green:function(val){return this.setChannel('rgb',1,val)},blue:function(val){return this.setChannel('rgb',2,val)},hue:function(val){if(val){val%=360;val=val<0?360+val:val}
return this.setChannel('hsl',0,val)},saturation:function(val){return this.setChannel('hsl',1,val)},lightness:function(val){return this.setChannel('hsl',2,val)},saturationv:function(val){return this.setChannel('hsv',1,val)},whiteness:function(val){return this.setChannel('hwb',1,val)},blackness:function(val){return this.setChannel('hwb',2,val)},value:function(val){return this.setChannel('hsv',2,val)},cyan:function(val){return this.setChannel('cmyk',0,val)},magenta:function(val){return this.setChannel('cmyk',1,val)},yellow:function(val){return this.setChannel('cmyk',2,val)},black:function(val){return this.setChannel('cmyk',3,val)},hexString:function(){return colorString.hexString(this.values.rgb)},rgbString:function(){return colorString.rgbString(this.values.rgb,this.values.alpha)},rgbaString:function(){return colorString.rgbaString(this.values.rgb,this.values.alpha)},percentString:function(){return colorString.percentString(this.values.rgb,this.values.alpha)},hslString:function(){return colorString.hslString(this.values.hsl,this.values.alpha)},hslaString:function(){return colorString.hslaString(this.values.hsl,this.values.alpha)},hwbString:function(){return colorString.hwbString(this.values.hwb,this.values.alpha)},keyword:function(){return colorString.keyword(this.values.rgb,this.values.alpha)},rgbNumber:function(){var rgb=this.values.rgb;return(rgb[0]<<16)|(rgb[1]<<8)|rgb[2]},luminosity:function(){var rgb=this.values.rgb;var lum=[];for(var i=0;i<rgb.length;i++){var chan=rgb[i]/255;lum[i]=(chan<=0.03928)?chan/12.92:Math.pow(((chan+0.055)/1.055),2.4)}
return 0.2126*lum[0]+0.7152*lum[1]+0.0722*lum[2]},contrast:function(color2){var lum1=this.luminosity();var lum2=color2.luminosity();if(lum1>lum2){return(lum1+0.05)/(lum2+0.05)}
return(lum2+0.05)/(lum1+0.05)},level:function(color2){var contrastRatio=this.contrast(color2);if(contrastRatio>=7.1){return'AAA'}
return(contrastRatio>=4.5)?'AA':''},dark:function(){var rgb=this.values.rgb;var yiq=(rgb[0]*299+rgb[1]*587+rgb[2]*114)/1000;return yiq<128},light:function(){return!this.dark()},negate:function(){var rgb=[];for(var i=0;i<3;i++){rgb[i]=255-this.values.rgb[i]}
this.setValues('rgb',rgb);return this},lighten:function(ratio){var hsl=this.values.hsl;hsl[2]+=hsl[2]*ratio;this.setValues('hsl',hsl);return this},darken:function(ratio){var hsl=this.values.hsl;hsl[2]-=hsl[2]*ratio;this.setValues('hsl',hsl);return this},saturate:function(ratio){var hsl=this.values.hsl;hsl[1]+=hsl[1]*ratio;this.setValues('hsl',hsl);return this},desaturate:function(ratio){var hsl=this.values.hsl;hsl[1]-=hsl[1]*ratio;this.setValues('hsl',hsl);return this},whiten:function(ratio){var hwb=this.values.hwb;hwb[1]+=hwb[1]*ratio;this.setValues('hwb',hwb);return this},blacken:function(ratio){var hwb=this.values.hwb;hwb[2]+=hwb[2]*ratio;this.setValues('hwb',hwb);return this},greyscale:function(){var rgb=this.values.rgb;var val=rgb[0]*0.3+rgb[1]*0.59+rgb[2]*0.11;this.setValues('rgb',[val,val,val]);return this},clearer:function(ratio){var alpha=this.values.alpha;this.setValues('alpha',alpha-(alpha*ratio));return this},opaquer:function(ratio){var alpha=this.values.alpha;this.setValues('alpha',alpha+(alpha*ratio));return this},rotate:function(degrees){var hsl=this.values.hsl;var hue=(hsl[0]+degrees)%360;hsl[0]=hue<0?360+hue:hue;this.setValues('hsl',hsl);return this},mix:function(mixinColor,weight){var color1=this;var color2=mixinColor;var p=weight===undefined?0.5:weight;var w=2*p-1;var a=color1.alpha()-color2.alpha();var w1=(((w*a===-1)?w:(w+a)/(1+w*a))+1)/2.0;var w2=1-w1;return this.rgb(w1*color1.red()+w2*color2.red(),w1*color1.green()+w2*color2.green(),w1*color1.blue()+w2*color2.blue()).alpha(color1.alpha()*p+color2.alpha()*(1-p))},toJSON:function(){return this.rgb()},clone:function(){var result=new Color();var source=this.values;var target=result.values;var value,type;for(var prop in source){if(source.hasOwnProperty(prop)){value=source[prop];type=({}).toString.call(value);if(type==='[object Array]'){target[prop]=value.slice(0)}else if(type==='[object Number]'){target[prop]=value}else{console.error('unexpected color value:',value)}}}
return result}};Color.prototype.spaces={rgb:['red','green','blue'],hsl:['hue','saturation','lightness'],hsv:['hue','saturation','value'],hwb:['hue','whiteness','blackness'],cmyk:['cyan','magenta','yellow','black']};Color.prototype.maxes={rgb:[255,255,255],hsl:[360,100,100],hsv:[360,100,100],hwb:[360,100,100],cmyk:[100,100,100,100]};Color.prototype.getValues=function(space){var values=this.values;var vals={};for(var i=0;i<space.length;i++){vals[space.charAt(i)]=values[space][i]}
if(values.alpha!==1){vals.a=values.alpha}
return vals};Color.prototype.setValues=function(space,vals){var values=this.values;var spaces=this.spaces;var maxes=this.maxes;var alpha=1;var i;this.valid=!0;if(space==='alpha'){alpha=vals}else if(vals.length){values[space]=vals.slice(0,space.length);alpha=vals[space.length]}else if(vals[space.charAt(0)]!==undefined){for(i=0;i<space.length;i++){values[space][i]=vals[space.charAt(i)]}
alpha=vals.a}else if(vals[spaces[space][0]]!==undefined){var chans=spaces[space];for(i=0;i<space.length;i++){values[space][i]=vals[chans[i]]}
alpha=vals.alpha}
values.alpha=Math.max(0,Math.min(1,(alpha===undefined?values.alpha:alpha)));if(space==='alpha'){return!1}
var capped;for(i=0;i<space.length;i++){capped=Math.max(0,Math.min(maxes[space][i],values[space][i]));values[space][i]=Math.round(capped)}
for(var sname in spaces){if(sname!==space){values[sname]=colorConvert[space][sname](values[space])}}
return!0};Color.prototype.setSpace=function(space,args){var vals=args[0];if(vals===undefined){return this.getValues(space)}
if(typeof vals==='number'){vals=Array.prototype.slice.call(args)}
this.setValues(space,vals);return this};Color.prototype.setChannel=function(space,index,val){var svalues=this.values[space];if(val===undefined){return svalues[index]}else if(val===svalues[index]){return this}
svalues[index]=val;this.setValues(space,svalues);return this};if(typeof window!=='undefined'){window.Color=Color}
var chartjsColor=Color;function isValidKey(key){return['__proto__','prototype','constructor'].indexOf(key)===-1}
var helpers={noop:function(){},uid:(function(){var id=0;return function(){return id++}}()),isNullOrUndef:function(value){return value===null||typeof value==='undefined'},isArray:function(value){if(Array.isArray&&Array.isArray(value)){return!0}
var type=Object.prototype.toString.call(value);if(type.substr(0,7)==='[object'&&type.substr(-6)==='Array]'){return!0}
return!1},isObject:function(value){return value!==null&&Object.prototype.toString.call(value)==='[object Object]'},isFinite:function(value){return(typeof value==='number'||value instanceof Number)&&isFinite(value)},valueOrDefault:function(value,defaultValue){return typeof value==='undefined'?defaultValue:value},valueAtIndexOrDefault:function(value,index,defaultValue){return helpers.valueOrDefault(helpers.isArray(value)?value[index]:value,defaultValue)},callback:function(fn,args,thisArg){if(fn&&typeof fn.call==='function'){return fn.apply(thisArg,args)}},each:function(loopable,fn,thisArg,reverse){var i,len,keys;if(helpers.isArray(loopable)){len=loopable.length;if(reverse){for(i=len-1;i>=0;i--){fn.call(thisArg,loopable[i],i)}}else{for(i=0;i<len;i++){fn.call(thisArg,loopable[i],i)}}}else if(helpers.isObject(loopable)){keys=Object.keys(loopable);len=keys.length;for(i=0;i<len;i++){fn.call(thisArg,loopable[keys[i]],keys[i])}}},arrayEquals:function(a0,a1){var i,ilen,v0,v1;if(!a0||!a1||a0.length!==a1.length){return!1}
for(i=0,ilen=a0.length;i<ilen;++i){v0=a0[i];v1=a1[i];if(v0 instanceof Array&&v1 instanceof Array){if(!helpers.arrayEquals(v0,v1)){return!1}}else if(v0!==v1){return!1}}
return!0},clone:function(source){if(helpers.isArray(source)){return source.map(helpers.clone)}
if(helpers.isObject(source)){var target=Object.create(source);var keys=Object.keys(source);var klen=keys.length;var k=0;for(;k<klen;++k){target[keys[k]]=helpers.clone(source[keys[k]])}
return target}
return source},_merger:function(key,target,source,options){if(!isValidKey(key)){return}
var tval=target[key];var sval=source[key];if(helpers.isObject(tval)&&helpers.isObject(sval)){helpers.merge(tval,sval,options)}else{target[key]=helpers.clone(sval)}},_mergerIf:function(key,target,source){if(!isValidKey(key)){return}
var tval=target[key];var sval=source[key];if(helpers.isObject(tval)&&helpers.isObject(sval)){helpers.mergeIf(tval,sval)}else if(!target.hasOwnProperty(key)){target[key]=helpers.clone(sval)}},merge:function(target,source,options){var sources=helpers.isArray(source)?source:[source];var ilen=sources.length;var merge,i,keys,klen,k;if(!helpers.isObject(target)){return target}
options=options||{};merge=options.merger||helpers._merger;for(i=0;i<ilen;++i){source=sources[i];if(!helpers.isObject(source)){continue}
keys=Object.keys(source);for(k=0,klen=keys.length;k<klen;++k){merge(keys[k],target,source,options)}}
return target},mergeIf:function(target,source){return helpers.merge(target,source,{merger:helpers._mergerIf})},extend:Object.assign||function(target){return helpers.merge(target,[].slice.call(arguments,1),{merger:function(key,dst,src){dst[key]=src[key]}})},inherits:function(extensions){var me=this;var ChartElement=(extensions&&extensions.hasOwnProperty('constructor'))?extensions.constructor:function(){return me.apply(this,arguments)};var Surrogate=function(){this.constructor=ChartElement};Surrogate.prototype=me.prototype;ChartElement.prototype=new Surrogate();ChartElement.extend=helpers.inherits;if(extensions){helpers.extend(ChartElement.prototype,extensions)}
ChartElement.__super__=me.prototype;return ChartElement},_deprecated:function(scope,value,previous,current){if(value!==undefined){console.warn(scope+': "'+previous+'" is deprecated. Please use "'+current+'" instead')}}};var helpers_core=helpers;helpers.callCallback=helpers.callback;helpers.indexOf=function(array,item,fromIndex){return Array.prototype.indexOf.call(array,item,fromIndex)};helpers.getValueOrDefault=helpers.valueOrDefault;helpers.getValueAtIndexOrDefault=helpers.valueAtIndexOrDefault;var effects={linear:function(t){return t},easeInQuad:function(t){return t*t},easeOutQuad:function(t){return-t*(t-2)},easeInOutQuad:function(t){if((t/=0.5)<1){return 0.5*t*t}
return-0.5*((--t)*(t-2)-1)},easeInCubic:function(t){return t*t*t},easeOutCubic:function(t){return(t=t-1)*t*t+1},easeInOutCubic:function(t){if((t/=0.5)<1){return 0.5*t*t*t}
return 0.5*((t-=2)*t*t+2)},easeInQuart:function(t){return t*t*t*t},easeOutQuart:function(t){return-((t=t-1)*t*t*t-1)},easeInOutQuart:function(t){if((t/=0.5)<1){return 0.5*t*t*t*t}
return-0.5*((t-=2)*t*t*t-2)},easeInQuint:function(t){return t*t*t*t*t},easeOutQuint:function(t){return(t=t-1)*t*t*t*t+1},easeInOutQuint:function(t){if((t/=0.5)<1){return 0.5*t*t*t*t*t}
return 0.5*((t-=2)*t*t*t*t+2)},easeInSine:function(t){return-Math.cos(t*(Math.PI/2))+1},easeOutSine:function(t){return Math.sin(t*(Math.PI/2))},easeInOutSine:function(t){return-0.5*(Math.cos(Math.PI*t)-1)},easeInExpo:function(t){return(t===0)?0:Math.pow(2,10*(t-1))},easeOutExpo:function(t){return(t===1)?1:-Math.pow(2,-10*t)+1},easeInOutExpo:function(t){if(t===0){return 0}
if(t===1){return 1}
if((t/=0.5)<1){return 0.5*Math.pow(2,10*(t-1))}
return 0.5*(-Math.pow(2,-10*--t)+2)},easeInCirc:function(t){if(t>=1){return t}
return-(Math.sqrt(1-t*t)-1)},easeOutCirc:function(t){return Math.sqrt(1-(t=t-1)*t)},easeInOutCirc:function(t){if((t/=0.5)<1){return-0.5*(Math.sqrt(1-t*t)-1)}
return 0.5*(Math.sqrt(1-(t-=2)*t)+1)},easeInElastic:function(t){var s=1.70158;var p=0;var a=1;if(t===0){return 0}
if(t===1){return 1}
if(!p){p=0.3}
if(a<1){a=1;s=p/4}else{s=p/(2*Math.PI)*Math.asin(1/a)}
return-(a*Math.pow(2,10*(t-=1))*Math.sin((t-s)*(2*Math.PI)/p))},easeOutElastic:function(t){var s=1.70158;var p=0;var a=1;if(t===0){return 0}
if(t===1){return 1}
if(!p){p=0.3}
if(a<1){a=1;s=p/4}else{s=p/(2*Math.PI)*Math.asin(1/a)}
return a*Math.pow(2,-10*t)*Math.sin((t-s)*(2*Math.PI)/p)+1},easeInOutElastic:function(t){var s=1.70158;var p=0;var a=1;if(t===0){return 0}
if((t/=0.5)===2){return 1}
if(!p){p=0.45}
if(a<1){a=1;s=p/4}else{s=p/(2*Math.PI)*Math.asin(1/a)}
if(t<1){return-0.5*(a*Math.pow(2,10*(t-=1))*Math.sin((t-s)*(2*Math.PI)/p))}
return a*Math.pow(2,-10*(t-=1))*Math.sin((t-s)*(2*Math.PI)/p)*0.5+1},easeInBack:function(t){var s=1.70158;return t*t*((s+1)*t-s)},easeOutBack:function(t){var s=1.70158;return(t=t-1)*t*((s+1)*t+s)+1},easeInOutBack:function(t){var s=1.70158;if((t/=0.5)<1){return 0.5*(t*t*(((s*=(1.525))+1)*t-s))}
return 0.5*((t-=2)*t*(((s*=(1.525))+1)*t+s)+2)},easeInBounce:function(t){return 1-effects.easeOutBounce(1-t)},easeOutBounce:function(t){if(t<(1/2.75)){return 7.5625*t*t}
if(t<(2/2.75)){return 7.5625*(t-=(1.5/2.75))*t+0.75}
if(t<(2.5/2.75)){return 7.5625*(t-=(2.25/2.75))*t+0.9375}
return 7.5625*(t-=(2.625/2.75))*t+0.984375},easeInOutBounce:function(t){if(t<0.5){return effects.easeInBounce(t*2)*0.5}
return effects.easeOutBounce(t*2-1)*0.5+0.5}};var helpers_easing={effects:effects};helpers_core.easingEffects=effects;var PI=Math.PI;var RAD_PER_DEG=PI/180;var DOUBLE_PI=PI*2;var HALF_PI=PI/2;var QUARTER_PI=PI/4;var TWO_THIRDS_PI=PI*2/3;var exports$1={clear:function(chart){chart.ctx.clearRect(0,0,chart.width,chart.height)},roundedRect:function(ctx,x,y,width,height,radius){if(radius){var r=Math.min(radius,height/2,width/2);var left=x+r;var top=y+r;var right=x+width-r;var bottom=y+height-r;ctx.moveTo(x,top);if(left<right&&top<bottom){ctx.arc(left,top,r,-PI,-HALF_PI);ctx.arc(right,top,r,-HALF_PI,0);ctx.arc(right,bottom,r,0,HALF_PI);ctx.arc(left,bottom,r,HALF_PI,PI)}else if(left<right){ctx.moveTo(left,y);ctx.arc(right,top,r,-HALF_PI,HALF_PI);ctx.arc(left,top,r,HALF_PI,PI+HALF_PI)}else if(top<bottom){ctx.arc(left,top,r,-PI,0);ctx.arc(left,bottom,r,0,PI)}else{ctx.arc(left,top,r,-PI,PI)}
ctx.closePath();ctx.moveTo(x,y)}else{ctx.rect(x,y,width,height)}},drawPoint:function(ctx,style,radius,x,y,rotation){var type,xOffset,yOffset,size,cornerRadius;var rad=(rotation||0)*RAD_PER_DEG;if(style&&typeof style==='object'){type=style.toString();if(type==='[object HTMLImageElement]'||type==='[object HTMLCanvasElement]'){ctx.save();ctx.translate(x,y);ctx.rotate(rad);ctx.drawImage(style,-style.width/2,-style.height/2,style.width,style.height);ctx.restore();return}}
if(isNaN(radius)||radius<=0){return}
ctx.beginPath();switch(style){default:ctx.arc(x,y,radius,0,DOUBLE_PI);ctx.closePath();break;case 'triangle':ctx.moveTo(x+Math.sin(rad)*radius,y-Math.cos(rad)*radius);rad+=TWO_THIRDS_PI;ctx.lineTo(x+Math.sin(rad)*radius,y-Math.cos(rad)*radius);rad+=TWO_THIRDS_PI;ctx.lineTo(x+Math.sin(rad)*radius,y-Math.cos(rad)*radius);ctx.closePath();break;case 'rectRounded':cornerRadius=radius*0.516;size=radius-cornerRadius;xOffset=Math.cos(rad+QUARTER_PI)*size;yOffset=Math.sin(rad+QUARTER_PI)*size;ctx.arc(x-xOffset,y-yOffset,cornerRadius,rad-PI,rad-HALF_PI);ctx.arc(x+yOffset,y-xOffset,cornerRadius,rad-HALF_PI,rad);ctx.arc(x+xOffset,y+yOffset,cornerRadius,rad,rad+HALF_PI);ctx.arc(x-yOffset,y+xOffset,cornerRadius,rad+HALF_PI,rad+PI);ctx.closePath();break;case 'rect':if(!rotation){size=Math.SQRT1_2*radius;ctx.rect(x-size,y-size,2*size,2*size);break}
rad+=QUARTER_PI;case 'rectRot':xOffset=Math.cos(rad)*radius;yOffset=Math.sin(rad)*radius;ctx.moveTo(x-xOffset,y-yOffset);ctx.lineTo(x+yOffset,y-xOffset);ctx.lineTo(x+xOffset,y+yOffset);ctx.lineTo(x-yOffset,y+xOffset);ctx.closePath();break;case 'crossRot':rad+=QUARTER_PI;case 'cross':xOffset=Math.cos(rad)*radius;yOffset=Math.sin(rad)*radius;ctx.moveTo(x-xOffset,y-yOffset);ctx.lineTo(x+xOffset,y+yOffset);ctx.moveTo(x+yOffset,y-xOffset);ctx.lineTo(x-yOffset,y+xOffset);break;case 'star':xOffset=Math.cos(rad)*radius;yOffset=Math.sin(rad)*radius;ctx.moveTo(x-xOffset,y-yOffset);ctx.lineTo(x+xOffset,y+yOffset);ctx.moveTo(x+yOffset,y-xOffset);ctx.lineTo(x-yOffset,y+xOffset);rad+=QUARTER_PI;xOffset=Math.cos(rad)*radius;yOffset=Math.sin(rad)*radius;ctx.moveTo(x-xOffset,y-yOffset);ctx.lineTo(x+xOffset,y+yOffset);ctx.moveTo(x+yOffset,y-xOffset);ctx.lineTo(x-yOffset,y+xOffset);break;case 'line':xOffset=Math.cos(rad)*radius;yOffset=Math.sin(rad)*radius;ctx.moveTo(x-xOffset,y-yOffset);ctx.lineTo(x+xOffset,y+yOffset);break;case 'dash':ctx.moveTo(x,y);ctx.lineTo(x+Math.cos(rad)*radius,y+Math.sin(rad)*radius);break}
ctx.fill();ctx.stroke()},_isPointInArea:function(point,area){var epsilon=1e-6;return point.x>area.left-epsilon&&point.x<area.right+epsilon&&point.y>area.top-epsilon&&point.y<area.bottom+epsilon},clipArea:function(ctx,area){ctx.save();ctx.beginPath();ctx.rect(area.left,area.top,area.right-area.left,area.bottom-area.top);ctx.clip()},unclipArea:function(ctx){ctx.restore()},lineTo:function(ctx,previous,target,flip){var stepped=target.steppedLine;if(stepped){if(stepped==='middle'){var midpoint=(previous.x+target.x)/2.0;ctx.lineTo(midpoint,flip?target.y:previous.y);ctx.lineTo(midpoint,flip?previous.y:target.y)}else if((stepped==='after'&&!flip)||(stepped!=='after'&&flip)){ctx.lineTo(previous.x,target.y)}else{ctx.lineTo(target.x,previous.y)}
ctx.lineTo(target.x,target.y);return}
if(!target.tension){ctx.lineTo(target.x,target.y);return}
ctx.bezierCurveTo(flip?previous.controlPointPreviousX:previous.controlPointNextX,flip?previous.controlPointPreviousY:previous.controlPointNextY,flip?target.controlPointNextX:target.controlPointPreviousX,flip?target.controlPointNextY:target.controlPointPreviousY,target.x,target.y)}};var helpers_canvas=exports$1;helpers_core.clear=exports$1.clear;helpers_core.drawRoundedRectangle=function(ctx){ctx.beginPath();exports$1.roundedRect.apply(exports$1,arguments)};var defaults={_set:function(scope,values){return helpers_core.merge(this[scope]||(this[scope]={}),values)}};defaults._set('global',{defaultColor:'rgba(0,0,0,0.1)',defaultFontColor:'#666',defaultFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",defaultFontSize:12,defaultFontStyle:'normal',defaultLineHeight:1.2,showLines:!0});var core_defaults=defaults;var valueOrDefault=helpers_core.valueOrDefault;function toFontString(font){if(!font||helpers_core.isNullOrUndef(font.size)||helpers_core.isNullOrUndef(font.family)){return null}
return(font.style?font.style+' ':'')+(font.weight?font.weight+' ':'')+font.size+'px '+font.family}
var helpers_options={toLineHeight:function(value,size){var matches=(''+value).match(/^(normal|(\d+(?:\.\d+)?)(px|em|%)?)$/);if(!matches||matches[1]==='normal'){return size*1.2}
value=+matches[2];switch(matches[3]){case 'px':return value;case '%':value/=100;break}
return size*value},toPadding:function(value){var t,r,b,l;if(helpers_core.isObject(value)){t=+value.top||0;r=+value.right||0;b=+value.bottom||0;l=+value.left||0}else{t=r=b=l=+value||0}
return{top:t,right:r,bottom:b,left:l,height:t+b,width:l+r}},_parseFont:function(options){var globalDefaults=core_defaults.global;var size=valueOrDefault(options.fontSize,globalDefaults.defaultFontSize);var font={family:valueOrDefault(options.fontFamily,globalDefaults.defaultFontFamily),lineHeight:helpers_core.options.toLineHeight(valueOrDefault(options.lineHeight,globalDefaults.defaultLineHeight),size),size:size,style:valueOrDefault(options.fontStyle,globalDefaults.defaultFontStyle),weight:null,string:''};font.string=toFontString(font);return font},resolve:function(inputs,context,index,info){var cacheable=!0;var i,ilen,value;for(i=0,ilen=inputs.length;i<ilen;++i){value=inputs[i];if(value===undefined){continue}
if(context!==undefined&&typeof value==='function'){value=value(context);cacheable=!1}
if(index!==undefined&&helpers_core.isArray(value)){value=value[index];cacheable=!1}
if(value!==undefined){if(info&&!cacheable){info.cacheable=!1}
return value}}}};var exports$2={_factorize:function(value){var result=[];var sqrt=Math.sqrt(value);var i;for(i=1;i<sqrt;i++){if(value%i===0){result.push(i);result.push(value/i)}}
if(sqrt===(sqrt|0)){result.push(sqrt)}
result.sort(function(a,b){return a-b}).pop();return result},log10:Math.log10||function(x){var exponent=Math.log(x)*Math.LOG10E;var powerOf10=Math.round(exponent);var isPowerOf10=x===Math.pow(10,powerOf10);return isPowerOf10?powerOf10:exponent}};var helpers_math=exports$2;helpers_core.log10=exports$2.log10;var getRtlAdapter=function(rectX,width){return{x:function(x){return rectX+rectX+width-x},setWidth:function(w){width=w},textAlign:function(align){if(align==='center'){return align}
return align==='right'?'left':'right'},xPlus:function(x,value){return x-value},leftForLtr:function(x,itemWidth){return x-itemWidth},}};var getLtrAdapter=function(){return{x:function(x){return x},setWidth:function(w){},textAlign:function(align){return align},xPlus:function(x,value){return x+value},leftForLtr:function(x,_itemWidth){return x},}};var getAdapter=function(rtl,rectX,width){return rtl?getRtlAdapter(rectX,width):getLtrAdapter()};var overrideTextDirection=function(ctx,direction){var style,original;if(direction==='ltr'||direction==='rtl'){style=ctx.canvas.style;original=[style.getPropertyValue('direction'),style.getPropertyPriority('direction'),];style.setProperty('direction',direction,'important');ctx.prevTextDirection=original}};var restoreTextDirection=function(ctx){var original=ctx.prevTextDirection;if(original!==undefined){delete ctx.prevTextDirection;ctx.canvas.style.setProperty('direction',original[0],original[1])}};var helpers_rtl={getRtlAdapter:getAdapter,overrideTextDirection:overrideTextDirection,restoreTextDirection:restoreTextDirection,};var helpers$1=helpers_core;var easing=helpers_easing;var canvas=helpers_canvas;var options=helpers_options;var math=helpers_math;var rtl=helpers_rtl;helpers$1.easing=easing;helpers$1.canvas=canvas;helpers$1.options=options;helpers$1.math=math;helpers$1.rtl=rtl;function interpolate(start,view,model,ease){var keys=Object.keys(model);var i,ilen,key,actual,origin,target,type,c0,c1;for(i=0,ilen=keys.length;i<ilen;++i){key=keys[i];target=model[key];if(!view.hasOwnProperty(key)){view[key]=target}
actual=view[key];if(actual===target||key[0]==='_'){continue}
if(!start.hasOwnProperty(key)){start[key]=actual}
origin=start[key];type=typeof target;if(type===typeof origin){if(type==='string'){c0=chartjsColor(origin);if(c0.valid){c1=chartjsColor(target);if(c1.valid){view[key]=c1.mix(c0,ease).rgbString();continue}}}else if(helpers$1.isFinite(origin)&&helpers$1.isFinite(target)){view[key]=origin+(target-origin)*ease;continue}}
view[key]=target}}
var Element=function(configuration){helpers$1.extend(this,configuration);this.initialize.apply(this,arguments)};helpers$1.extend(Element.prototype,{_type:undefined,initialize:function(){this.hidden=!1},pivot:function(){var me=this;if(!me._view){me._view=helpers$1.extend({},me._model)}
me._start={};return me},transition:function(ease){var me=this;var model=me._model;var start=me._start;var view=me._view;if(!model||ease===1){me._view=helpers$1.extend({},model);me._start=null;return me}
if(!view){view=me._view={}}
if(!start){start=me._start={}}
interpolate(start,view,model,ease);return me},tooltipPosition:function(){return{x:this._model.x,y:this._model.y}},hasValue:function(){return helpers$1.isNumber(this._model.x)&&helpers$1.isNumber(this._model.y)}});Element.extend=helpers$1.inherits;var core_element=Element;var exports$3=core_element.extend({chart:null,currentStep:0,numSteps:60,easing:'',render:null,onAnimationProgress:null,onAnimationComplete:null,});var core_animation=exports$3;Object.defineProperty(exports$3.prototype,'animationObject',{get:function(){return this}});Object.defineProperty(exports$3.prototype,'chartInstance',{get:function(){return this.chart},set:function(value){this.chart=value}});core_defaults._set('global',{animation:{duration:1000,easing:'easeOutQuart',onProgress:helpers$1.noop,onComplete:helpers$1.noop}});var core_animations={animations:[],request:null,addAnimation:function(chart,animation,duration,lazy){var animations=this.animations;var i,ilen;animation.chart=chart;animation.startTime=Date.now();animation.duration=duration;if(!lazy){chart.animating=!0}
for(i=0,ilen=animations.length;i<ilen;++i){if(animations[i].chart===chart){animations[i]=animation;return}}
animations.push(animation);if(animations.length===1){this.requestAnimationFrame()}},cancelAnimation:function(chart){var index=helpers$1.findIndex(this.animations,function(animation){return animation.chart===chart});if(index!==-1){this.animations.splice(index,1);chart.animating=!1}},requestAnimationFrame:function(){var me=this;if(me.request===null){me.request=helpers$1.requestAnimFrame.call(window,function(){me.request=null;me.startDigest()})}},startDigest:function(){var me=this;me.advance();if(me.animations.length>0){me.requestAnimationFrame()}},advance:function(){var animations=this.animations;var animation,chart,numSteps,nextStep;var i=0;while(i<animations.length){animation=animations[i];chart=animation.chart;numSteps=animation.numSteps;nextStep=Math.floor((Date.now()-animation.startTime)/animation.duration*numSteps)+1;animation.currentStep=Math.min(nextStep,numSteps);helpers$1.callback(animation.render,[chart,animation],chart);helpers$1.callback(animation.onAnimationProgress,[animation],chart);if(animation.currentStep>=numSteps){helpers$1.callback(animation.onAnimationComplete,[animation],chart);chart.animating=!1;animations.splice(i,1)}else{++i}}}};var resolve=helpers$1.options.resolve;var arrayEvents=['push','pop','shift','splice','unshift'];function listenArrayEvents(array,listener){if(array._chartjs){array._chartjs.listeners.push(listener);return}
Object.defineProperty(array,'_chartjs',{configurable:!0,enumerable:!1,value:{listeners:[listener]}});arrayEvents.forEach(function(key){var method='onData'+key.charAt(0).toUpperCase()+key.slice(1);var base=array[key];Object.defineProperty(array,key,{configurable:!0,enumerable:!1,value:function(){var args=Array.prototype.slice.call(arguments);var res=base.apply(this,args);helpers$1.each(array._chartjs.listeners,function(object){if(typeof object[method]==='function'){object[method].apply(object,args)}});return res}})})}
function unlistenArrayEvents(array,listener){var stub=array._chartjs;if(!stub){return}
var listeners=stub.listeners;var index=listeners.indexOf(listener);if(index!==-1){listeners.splice(index,1)}
if(listeners.length>0){return}
arrayEvents.forEach(function(key){delete array[key]});delete array._chartjs}
var DatasetController=function(chart,datasetIndex){this.initialize(chart,datasetIndex)};helpers$1.extend(DatasetController.prototype,{datasetElementType:null,dataElementType:null,_datasetElementOptions:['backgroundColor','borderCapStyle','borderColor','borderDash','borderDashOffset','borderJoinStyle','borderWidth'],_dataElementOptions:['backgroundColor','borderColor','borderWidth','pointStyle'],initialize:function(chart,datasetIndex){var me=this;me.chart=chart;me.index=datasetIndex;me.linkScales();me.addElements();me._type=me.getMeta().type},updateIndex:function(datasetIndex){this.index=datasetIndex},linkScales:function(){var me=this;var meta=me.getMeta();var chart=me.chart;var scales=chart.scales;var dataset=me.getDataset();var scalesOpts=chart.options.scales;if(meta.xAxisID===null||!(meta.xAxisID in scales)||dataset.xAxisID){meta.xAxisID=dataset.xAxisID||scalesOpts.xAxes[0].id}
if(meta.yAxisID===null||!(meta.yAxisID in scales)||dataset.yAxisID){meta.yAxisID=dataset.yAxisID||scalesOpts.yAxes[0].id}},getDataset:function(){return this.chart.data.datasets[this.index]},getMeta:function(){return this.chart.getDatasetMeta(this.index)},getScaleForId:function(scaleID){return this.chart.scales[scaleID]},_getValueScaleId:function(){return this.getMeta().yAxisID},_getIndexScaleId:function(){return this.getMeta().xAxisID},_getValueScale:function(){return this.getScaleForId(this._getValueScaleId())},_getIndexScale:function(){return this.getScaleForId(this._getIndexScaleId())},reset:function(){this._update(!0)},destroy:function(){if(this._data){unlistenArrayEvents(this._data,this)}},createMetaDataset:function(){var me=this;var type=me.datasetElementType;return type&&new type({_chart:me.chart,_datasetIndex:me.index})},createMetaData:function(index){var me=this;var type=me.dataElementType;return type&&new type({_chart:me.chart,_datasetIndex:me.index,_index:index})},addElements:function(){var me=this;var meta=me.getMeta();var data=me.getDataset().data||[];var metaData=meta.data;var i,ilen;for(i=0,ilen=data.length;i<ilen;++i){metaData[i]=metaData[i]||me.createMetaData(i)}
meta.dataset=meta.dataset||me.createMetaDataset()},addElementAndReset:function(index){var element=this.createMetaData(index);this.getMeta().data.splice(index,0,element);this.updateElement(element,index,!0)},buildOrUpdateElements:function(){var me=this;var dataset=me.getDataset();var data=dataset.data||(dataset.data=[]);if(me._data!==data){if(me._data){unlistenArrayEvents(me._data,me)}
if(data&&Object.isExtensible(data)){listenArrayEvents(data,me)}
me._data=data}
me.resyncElements()},_configure:function(){var me=this;me._config=helpers$1.merge(Object.create(null),[me.chart.options.datasets[me._type],me.getDataset(),],{merger:function(key,target,source){if(key!=='_meta'&&key!=='data'){helpers$1._merger(key,target,source)}}})},_update:function(reset){var me=this;me._configure();me._cachedDataOpts=null;me.update(reset)},update:helpers$1.noop,transition:function(easingValue){var meta=this.getMeta();var elements=meta.data||[];var ilen=elements.length;var i=0;for(;i<ilen;++i){elements[i].transition(easingValue)}
if(meta.dataset){meta.dataset.transition(easingValue)}},draw:function(){var meta=this.getMeta();var elements=meta.data||[];var ilen=elements.length;var i=0;if(meta.dataset){meta.dataset.draw()}
for(;i<ilen;++i){elements[i].draw()}},getStyle:function(index){var me=this;var meta=me.getMeta();var dataset=meta.dataset;var style;me._configure();if(dataset&&index===undefined){style=me._resolveDatasetElementOptions(dataset||{})}else{index=index||0;style=me._resolveDataElementOptions(meta.data[index]||{},index)}
if(style.fill===!1||style.fill===null){style.backgroundColor=style.borderColor}
return style},_resolveDatasetElementOptions:function(element,hover){var me=this;var chart=me.chart;var datasetOpts=me._config;var custom=element.custom||{};var options=chart.options.elements[me.datasetElementType.prototype._type]||{};var elementOptions=me._datasetElementOptions;var values={};var i,ilen,key,readKey;var context={chart:chart,dataset:me.getDataset(),datasetIndex:me.index,hover:hover};for(i=0,ilen=elementOptions.length;i<ilen;++i){key=elementOptions[i];readKey=hover?'hover'+key.charAt(0).toUpperCase()+key.slice(1):key;values[key]=resolve([custom[readKey],datasetOpts[readKey],options[readKey]],context)}
return values},_resolveDataElementOptions:function(element,index){var me=this;var custom=element&&element.custom;var cached=me._cachedDataOpts;if(cached&&!custom){return cached}
var chart=me.chart;var datasetOpts=me._config;var options=chart.options.elements[me.dataElementType.prototype._type]||{};var elementOptions=me._dataElementOptions;var values={};var context={chart:chart,dataIndex:index,dataset:me.getDataset(),datasetIndex:me.index};var info={cacheable:!custom};var keys,i,ilen,key;custom=custom||{};if(helpers$1.isArray(elementOptions)){for(i=0,ilen=elementOptions.length;i<ilen;++i){key=elementOptions[i];values[key]=resolve([custom[key],datasetOpts[key],options[key]],context,index,info)}}else{keys=Object.keys(elementOptions);for(i=0,ilen=keys.length;i<ilen;++i){key=keys[i];values[key]=resolve([custom[key],datasetOpts[elementOptions[key]],datasetOpts[key],options[key]],context,index,info)}}
if(info.cacheable){me._cachedDataOpts=Object.freeze(values)}
return values},removeHoverStyle:function(element){helpers$1.merge(element._model,element.$previousStyle||{});delete element.$previousStyle},setHoverStyle:function(element){var dataset=this.chart.data.datasets[element._datasetIndex];var index=element._index;var custom=element.custom||{};var model=element._model;var getHoverColor=helpers$1.getHoverColor;element.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth};model.backgroundColor=resolve([custom.hoverBackgroundColor,dataset.hoverBackgroundColor,getHoverColor(model.backgroundColor)],undefined,index);model.borderColor=resolve([custom.hoverBorderColor,dataset.hoverBorderColor,getHoverColor(model.borderColor)],undefined,index);model.borderWidth=resolve([custom.hoverBorderWidth,dataset.hoverBorderWidth,model.borderWidth],undefined,index)},_removeDatasetHoverStyle:function(){var element=this.getMeta().dataset;if(element){this.removeHoverStyle(element)}},_setDatasetHoverStyle:function(){var element=this.getMeta().dataset;var prev={};var i,ilen,key,keys,hoverOptions,model;if(!element){return}
model=element._model;hoverOptions=this._resolveDatasetElementOptions(element,!0);keys=Object.keys(hoverOptions);for(i=0,ilen=keys.length;i<ilen;++i){key=keys[i];prev[key]=model[key];model[key]=hoverOptions[key]}
element.$previousStyle=prev},resyncElements:function(){var me=this;var meta=me.getMeta();var data=me.getDataset().data;var numMeta=meta.data.length;var numData=data.length;if(numData<numMeta){meta.data.splice(numData,numMeta-numData)}else if(numData>numMeta){me.insertElements(numMeta,numData-numMeta)}},insertElements:function(start,count){for(var i=0;i<count;++i){this.addElementAndReset(start+i)}},onDataPush:function(){var count=arguments.length;this.insertElements(this.getDataset().data.length-count,count)},onDataPop:function(){this.getMeta().data.pop()},onDataShift:function(){this.getMeta().data.shift()},onDataSplice:function(start,count){this.getMeta().data.splice(start,count);this.insertElements(start,arguments.length-2)},onDataUnshift:function(){this.insertElements(0,arguments.length)}});DatasetController.extend=helpers$1.inherits;var core_datasetController=DatasetController;var TAU=Math.PI*2;core_defaults._set('global',{elements:{arc:{backgroundColor:core_defaults.global.defaultColor,borderColor:'#fff',borderWidth:2,borderAlign:'center'}}});function clipArc(ctx,arc){var startAngle=arc.startAngle;var endAngle=arc.endAngle;var pixelMargin=arc.pixelMargin;var angleMargin=pixelMargin/arc.outerRadius;var x=arc.x;var y=arc.y;ctx.beginPath();ctx.arc(x,y,arc.outerRadius,startAngle-angleMargin,endAngle+angleMargin);if(arc.innerRadius>pixelMargin){angleMargin=pixelMargin/arc.innerRadius;ctx.arc(x,y,arc.innerRadius-pixelMargin,endAngle+angleMargin,startAngle-angleMargin,!0)}else{ctx.arc(x,y,pixelMargin,endAngle+Math.PI/2,startAngle-Math.PI/2)}
ctx.closePath();ctx.clip()}
function drawFullCircleBorders(ctx,vm,arc,inner){var endAngle=arc.endAngle;var i;if(inner){arc.endAngle=arc.startAngle+TAU;clipArc(ctx,arc);arc.endAngle=endAngle;if(arc.endAngle===arc.startAngle&&arc.fullCircles){arc.endAngle+=TAU;arc.fullCircles--}}
ctx.beginPath();ctx.arc(arc.x,arc.y,arc.innerRadius,arc.startAngle+TAU,arc.startAngle,!0);for(i=0;i<arc.fullCircles;++i){ctx.stroke()}
ctx.beginPath();ctx.arc(arc.x,arc.y,vm.outerRadius,arc.startAngle,arc.startAngle+TAU);for(i=0;i<arc.fullCircles;++i){ctx.stroke()}}
function drawBorder(ctx,vm,arc){var inner=vm.borderAlign==='inner';if(inner){ctx.lineWidth=vm.borderWidth*2;ctx.lineJoin='round'}else{ctx.lineWidth=vm.borderWidth;ctx.lineJoin='bevel'}
if(arc.fullCircles){drawFullCircleBorders(ctx,vm,arc,inner)}
if(inner){clipArc(ctx,arc)}
ctx.beginPath();ctx.arc(arc.x,arc.y,vm.outerRadius,arc.startAngle,arc.endAngle);ctx.arc(arc.x,arc.y,arc.innerRadius,arc.endAngle,arc.startAngle,!0);ctx.closePath();ctx.stroke()}
var element_arc=core_element.extend({_type:'arc',inLabelRange:function(mouseX){var vm=this._view;if(vm){return(Math.pow(mouseX-vm.x,2)<Math.pow(vm.radius+vm.hoverRadius,2))}
return!1},inRange:function(chartX,chartY){var vm=this._view;if(vm){var pointRelativePosition=helpers$1.getAngleFromPoint(vm,{x:chartX,y:chartY});var angle=pointRelativePosition.angle;var distance=pointRelativePosition.distance;var startAngle=vm.startAngle;var endAngle=vm.endAngle;while(endAngle<startAngle){endAngle+=TAU}
while(angle>endAngle){angle-=TAU}
while(angle<startAngle){angle+=TAU}
var betweenAngles=(angle>=startAngle&&angle<=endAngle);var withinRadius=(distance>=vm.innerRadius&&distance<=vm.outerRadius);return(betweenAngles&&withinRadius)}
return!1},getCenterPoint:function(){var vm=this._view;var halfAngle=(vm.startAngle+vm.endAngle)/2;var halfRadius=(vm.innerRadius+vm.outerRadius)/2;return{x:vm.x+Math.cos(halfAngle)*halfRadius,y:vm.y+Math.sin(halfAngle)*halfRadius}},getArea:function(){var vm=this._view;return Math.PI*((vm.endAngle-vm.startAngle)/(2*Math.PI))*(Math.pow(vm.outerRadius,2)-Math.pow(vm.innerRadius,2))},tooltipPosition:function(){var vm=this._view;var centreAngle=vm.startAngle+((vm.endAngle-vm.startAngle)/2);var rangeFromCentre=(vm.outerRadius-vm.innerRadius)/2+vm.innerRadius;return{x:vm.x+(Math.cos(centreAngle)*rangeFromCentre),y:vm.y+(Math.sin(centreAngle)*rangeFromCentre)}},draw:function(){var ctx=this._chart.ctx;var vm=this._view;var pixelMargin=(vm.borderAlign==='inner')?0.33:0;var arc={x:vm.x,y:vm.y,innerRadius:vm.innerRadius,outerRadius:Math.max(vm.outerRadius-pixelMargin,0),pixelMargin:pixelMargin,startAngle:vm.startAngle,endAngle:vm.endAngle,fullCircles:Math.floor(vm.circumference/TAU)};var i;ctx.save();ctx.fillStyle=vm.backgroundColor;ctx.strokeStyle=vm.borderColor;if(arc.fullCircles){arc.endAngle=arc.startAngle+TAU;ctx.beginPath();ctx.arc(arc.x,arc.y,arc.outerRadius,arc.startAngle,arc.endAngle);ctx.arc(arc.x,arc.y,arc.innerRadius,arc.endAngle,arc.startAngle,!0);ctx.closePath();for(i=0;i<arc.fullCircles;++i){ctx.fill()}
arc.endAngle=arc.startAngle+vm.circumference%TAU}
ctx.beginPath();ctx.arc(arc.x,arc.y,arc.outerRadius,arc.startAngle,arc.endAngle);ctx.arc(arc.x,arc.y,arc.innerRadius,arc.endAngle,arc.startAngle,!0);ctx.closePath();ctx.fill();if(vm.borderWidth){drawBorder(ctx,vm,arc)}
ctx.restore()}});var valueOrDefault$1=helpers$1.valueOrDefault;var defaultColor=core_defaults.global.defaultColor;core_defaults._set('global',{elements:{line:{tension:0.4,backgroundColor:defaultColor,borderWidth:3,borderColor:defaultColor,borderCapStyle:'butt',borderDash:[],borderDashOffset:0.0,borderJoinStyle:'miter',capBezierPoints:!0,fill:!0,}}});var element_line=core_element.extend({_type:'line',draw:function(){var me=this;var vm=me._view;var ctx=me._chart.ctx;var spanGaps=vm.spanGaps;var points=me._children.slice();var globalDefaults=core_defaults.global;var globalOptionLineElements=globalDefaults.elements.line;var lastDrawnIndex=-1;var closePath=me._loop;var index,previous,currentVM;if(!points.length){return}
if(me._loop){for(index=0;index<points.length;++index){previous=helpers$1.previousItem(points,index);if(!points[index]._view.skip&&previous._view.skip){points=points.slice(index).concat(points.slice(0,index));closePath=spanGaps;break}}
if(closePath){points.push(points[0])}}
ctx.save();ctx.lineCap=vm.borderCapStyle||globalOptionLineElements.borderCapStyle;if(ctx.setLineDash){ctx.setLineDash(vm.borderDash||globalOptionLineElements.borderDash)}
ctx.lineDashOffset=valueOrDefault$1(vm.borderDashOffset,globalOptionLineElements.borderDashOffset);ctx.lineJoin=vm.borderJoinStyle||globalOptionLineElements.borderJoinStyle;ctx.lineWidth=valueOrDefault$1(vm.borderWidth,globalOptionLineElements.borderWidth);ctx.strokeStyle=vm.borderColor||globalDefaults.defaultColor;ctx.beginPath();currentVM=points[0]._view;if(!currentVM.skip){ctx.moveTo(currentVM.x,currentVM.y);lastDrawnIndex=0}
for(index=1;index<points.length;++index){currentVM=points[index]._view;previous=lastDrawnIndex===-1?helpers$1.previousItem(points,index):points[lastDrawnIndex];if(!currentVM.skip){if((lastDrawnIndex!==(index-1)&&!spanGaps)||lastDrawnIndex===-1){ctx.moveTo(currentVM.x,currentVM.y)}else{helpers$1.canvas.lineTo(ctx,previous._view,currentVM)}
lastDrawnIndex=index}}
if(closePath){ctx.closePath()}
ctx.stroke();ctx.restore()}});var valueOrDefault$2=helpers$1.valueOrDefault;var defaultColor$1=core_defaults.global.defaultColor;core_defaults._set('global',{elements:{point:{radius:3,pointStyle:'circle',backgroundColor:defaultColor$1,borderColor:defaultColor$1,borderWidth:1,hitRadius:1,hoverRadius:4,hoverBorderWidth:1}}});function xRange(mouseX){var vm=this._view;return vm?(Math.abs(mouseX-vm.x)<vm.radius+vm.hitRadius):!1}
function yRange(mouseY){var vm=this._view;return vm?(Math.abs(mouseY-vm.y)<vm.radius+vm.hitRadius):!1}
var element_point=core_element.extend({_type:'point',inRange:function(mouseX,mouseY){var vm=this._view;return vm?((Math.pow(mouseX-vm.x,2)+Math.pow(mouseY-vm.y,2))<Math.pow(vm.hitRadius+vm.radius,2)):!1},inLabelRange:xRange,inXRange:xRange,inYRange:yRange,getCenterPoint:function(){var vm=this._view;return{x:vm.x,y:vm.y}},getArea:function(){return Math.PI*Math.pow(this._view.radius,2)},tooltipPosition:function(){var vm=this._view;return{x:vm.x,y:vm.y,padding:vm.radius+vm.borderWidth}},draw:function(chartArea){var vm=this._view;var ctx=this._chart.ctx;var pointStyle=vm.pointStyle;var rotation=vm.rotation;var radius=vm.radius;var x=vm.x;var y=vm.y;var globalDefaults=core_defaults.global;var defaultColor=globalDefaults.defaultColor;if(vm.skip){return}
if(chartArea===undefined||helpers$1.canvas._isPointInArea(vm,chartArea)){ctx.strokeStyle=vm.borderColor||defaultColor;ctx.lineWidth=valueOrDefault$2(vm.borderWidth,globalDefaults.elements.point.borderWidth);ctx.fillStyle=vm.backgroundColor||defaultColor;helpers$1.canvas.drawPoint(ctx,pointStyle,radius,x,y,rotation)}}});var defaultColor$2=core_defaults.global.defaultColor;core_defaults._set('global',{elements:{rectangle:{backgroundColor:defaultColor$2,borderColor:defaultColor$2,borderSkipped:'bottom',borderWidth:0}}});function isVertical(vm){return vm&&vm.width!==undefined}
function getBarBounds(vm){var x1,x2,y1,y2,half;if(isVertical(vm)){half=vm.width/2;x1=vm.x-half;x2=vm.x+half;y1=Math.min(vm.y,vm.base);y2=Math.max(vm.y,vm.base)}else{half=vm.height/2;x1=Math.min(vm.x,vm.base);x2=Math.max(vm.x,vm.base);y1=vm.y-half;y2=vm.y+half}
return{left:x1,top:y1,right:x2,bottom:y2}}
function swap(orig,v1,v2){return orig===v1?v2:orig===v2?v1:orig}
function parseBorderSkipped(vm){var edge=vm.borderSkipped;var res={};if(!edge){return res}
if(vm.horizontal){if(vm.base>vm.x){edge=swap(edge,'left','right')}}else if(vm.base<vm.y){edge=swap(edge,'bottom','top')}
res[edge]=!0;return res}
function parseBorderWidth(vm,maxW,maxH){var value=vm.borderWidth;var skip=parseBorderSkipped(vm);var t,r,b,l;if(helpers$1.isObject(value)){t=+value.top||0;r=+value.right||0;b=+value.bottom||0;l=+value.left||0}else{t=r=b=l=+value||0}
return{t:skip.top||(t<0)?0:t>maxH?maxH:t,r:skip.right||(r<0)?0:r>maxW?maxW:r,b:skip.bottom||(b<0)?0:b>maxH?maxH:b,l:skip.left||(l<0)?0:l>maxW?maxW:l}}
function boundingRects(vm){var bounds=getBarBounds(vm);var width=bounds.right-bounds.left;var height=bounds.bottom-bounds.top;var border=parseBorderWidth(vm,width/2,height/2);return{outer:{x:bounds.left,y:bounds.top,w:width,h:height},inner:{x:bounds.left+border.l,y:bounds.top+border.t,w:width-border.l-border.r,h:height-border.t-border.b}}}
function inRange(vm,x,y){var skipX=x===null;var skipY=y===null;var bounds=!vm||(skipX&&skipY)?!1:getBarBounds(vm);return bounds&&(skipX||x>=bounds.left&&x<=bounds.right)&&(skipY||y>=bounds.top&&y<=bounds.bottom)}
var element_rectangle=core_element.extend({_type:'rectangle',draw:function(){var ctx=this._chart.ctx;var vm=this._view;var rects=boundingRects(vm);var outer=rects.outer;var inner=rects.inner;ctx.fillStyle=vm.backgroundColor;ctx.fillRect(outer.x,outer.y,outer.w,outer.h);if(outer.w===inner.w&&outer.h===inner.h){return}
ctx.save();ctx.beginPath();ctx.rect(outer.x,outer.y,outer.w,outer.h);ctx.clip();ctx.fillStyle=vm.borderColor;ctx.rect(inner.x,inner.y,inner.w,inner.h);ctx.fill('evenodd');ctx.restore()},height:function(){var vm=this._view;return vm.base-vm.y},inRange:function(mouseX,mouseY){return inRange(this._view,mouseX,mouseY)},inLabelRange:function(mouseX,mouseY){var vm=this._view;return isVertical(vm)?inRange(vm,mouseX,null):inRange(vm,null,mouseY)},inXRange:function(mouseX){return inRange(this._view,mouseX,null)},inYRange:function(mouseY){return inRange(this._view,null,mouseY)},getCenterPoint:function(){var vm=this._view;var x,y;if(isVertical(vm)){x=vm.x;y=(vm.y+vm.base)/2}else{x=(vm.x+vm.base)/2;y=vm.y}
return{x:x,y:y}},getArea:function(){var vm=this._view;return isVertical(vm)?vm.width*Math.abs(vm.y-vm.base):vm.height*Math.abs(vm.x-vm.base)},tooltipPosition:function(){var vm=this._view;return{x:vm.x,y:vm.y}}});var elements={};var Arc=element_arc;var Line=element_line;var Point=element_point;var Rectangle=element_rectangle;elements.Arc=Arc;elements.Line=Line;elements.Point=Point;elements.Rectangle=Rectangle;var deprecated=helpers$1._deprecated;var valueOrDefault$3=helpers$1.valueOrDefault;core_defaults._set('bar',{hover:{mode:'label'},scales:{xAxes:[{type:'category',offset:!0,gridLines:{offsetGridLines:!0}}],yAxes:[{type:'linear'}]}});core_defaults._set('global',{datasets:{bar:{categoryPercentage:0.8,barPercentage:0.9}}});function computeMinSampleSize(scale,pixels){var min=scale._length;var prev,curr,i,ilen;for(i=1,ilen=pixels.length;i<ilen;++i){min=Math.min(min,Math.abs(pixels[i]-pixels[i-1]))}
for(i=0,ilen=scale.getTicks().length;i<ilen;++i){curr=scale.getPixelForTick(i);min=i>0?Math.min(min,Math.abs(curr-prev)):min;prev=curr}
return min}
function computeFitCategoryTraits(index,ruler,options){var thickness=options.barThickness;var count=ruler.stackCount;var curr=ruler.pixels[index];var min=helpers$1.isNullOrUndef(thickness)?computeMinSampleSize(ruler.scale,ruler.pixels):-1;var size,ratio;if(helpers$1.isNullOrUndef(thickness)){size=min*options.categoryPercentage;ratio=options.barPercentage}else{size=thickness*count;ratio=1}
return{chunk:size/count,ratio:ratio,start:curr-(size/2)}}
function computeFlexCategoryTraits(index,ruler,options){var pixels=ruler.pixels;var curr=pixels[index];var prev=index>0?pixels[index-1]:null;var next=index<pixels.length-1?pixels[index+1]:null;var percent=options.categoryPercentage;var start,size;if(prev===null){prev=curr-(next===null?ruler.end-ruler.start:next-curr)}
if(next===null){next=curr+curr-prev}
start=curr-(curr-Math.min(prev,next))/2*percent;size=Math.abs(next-prev)/2*percent;return{chunk:size/ruler.stackCount,ratio:options.barPercentage,start:start}}
var controller_bar=core_datasetController.extend({dataElementType:elements.Rectangle,_dataElementOptions:['backgroundColor','borderColor','borderSkipped','borderWidth','barPercentage','barThickness','categoryPercentage','maxBarThickness','minBarLength'],initialize:function(){var me=this;var meta,scaleOpts;core_datasetController.prototype.initialize.apply(me,arguments);meta=me.getMeta();meta.stack=me.getDataset().stack;meta.bar=!0;scaleOpts=me._getIndexScale().options;deprecated('bar chart',scaleOpts.barPercentage,'scales.[x/y]Axes.barPercentage','dataset.barPercentage');deprecated('bar chart',scaleOpts.barThickness,'scales.[x/y]Axes.barThickness','dataset.barThickness');deprecated('bar chart',scaleOpts.categoryPercentage,'scales.[x/y]Axes.categoryPercentage','dataset.categoryPercentage');deprecated('bar chart',me._getValueScale().options.minBarLength,'scales.[x/y]Axes.minBarLength','dataset.minBarLength');deprecated('bar chart',scaleOpts.maxBarThickness,'scales.[x/y]Axes.maxBarThickness','dataset.maxBarThickness')},update:function(reset){var me=this;var rects=me.getMeta().data;var i,ilen;me._ruler=me.getRuler();for(i=0,ilen=rects.length;i<ilen;++i){me.updateElement(rects[i],i,reset)}},updateElement:function(rectangle,index,reset){var me=this;var meta=me.getMeta();var dataset=me.getDataset();var options=me._resolveDataElementOptions(rectangle,index);rectangle._xScale=me.getScaleForId(meta.xAxisID);rectangle._yScale=me.getScaleForId(meta.yAxisID);rectangle._datasetIndex=me.index;rectangle._index=index;rectangle._model={backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderSkipped:options.borderSkipped,borderWidth:options.borderWidth,datasetLabel:dataset.label,label:me.chart.data.labels[index]};if(helpers$1.isArray(dataset.data[index])){rectangle._model.borderSkipped=null}
me._updateElementGeometry(rectangle,index,reset,options);rectangle.pivot()},_updateElementGeometry:function(rectangle,index,reset,options){var me=this;var model=rectangle._model;var vscale=me._getValueScale();var base=vscale.getBasePixel();var horizontal=vscale.isHorizontal();var ruler=me._ruler||me.getRuler();var vpixels=me.calculateBarValuePixels(me.index,index,options);var ipixels=me.calculateBarIndexPixels(me.index,index,ruler,options);model.horizontal=horizontal;model.base=reset?base:vpixels.base;model.x=horizontal?reset?base:vpixels.head:ipixels.center;model.y=horizontal?ipixels.center:reset?base:vpixels.head;model.height=horizontal?ipixels.size:undefined;model.width=horizontal?undefined:ipixels.size},_getStacks:function(last){var me=this;var scale=me._getIndexScale();var metasets=scale._getMatchingVisibleMetas(me._type);var stacked=scale.options.stacked;var ilen=metasets.length;var stacks=[];var i,meta;for(i=0;i<ilen;++i){meta=metasets[i];if(stacked===!1||stacks.indexOf(meta.stack)===-1||(stacked===undefined&&meta.stack===undefined)){stacks.push(meta.stack)}
if(meta.index===last){break}}
return stacks},getStackCount:function(){return this._getStacks().length},getStackIndex:function(datasetIndex,name){var stacks=this._getStacks(datasetIndex);var index=(name!==undefined)?stacks.indexOf(name):-1;return(index===-1)?stacks.length-1:index},getRuler:function(){var me=this;var scale=me._getIndexScale();var pixels=[];var i,ilen;for(i=0,ilen=me.getMeta().data.length;i<ilen;++i){pixels.push(scale.getPixelForValue(null,i,me.index))}
return{pixels:pixels,start:scale._startPixel,end:scale._endPixel,stackCount:me.getStackCount(),scale:scale}},calculateBarValuePixels:function(datasetIndex,index,options){var me=this;var chart=me.chart;var scale=me._getValueScale();var isHorizontal=scale.isHorizontal();var datasets=chart.data.datasets;var metasets=scale._getMatchingVisibleMetas(me._type);var value=scale._parseValue(datasets[datasetIndex].data[index]);var minBarLength=options.minBarLength;var stacked=scale.options.stacked;var stack=me.getMeta().stack;var start=value.start===undefined?0:value.max>=0&&value.min>=0?value.min:value.max;var length=value.start===undefined?value.end:value.max>=0&&value.min>=0?value.max-value.min:value.min-value.max;var ilen=metasets.length;var i,imeta,ivalue,base,head,size,stackLength;if(stacked||(stacked===undefined&&stack!==undefined)){for(i=0;i<ilen;++i){imeta=metasets[i];if(imeta.index===datasetIndex){break}
if(imeta.stack===stack){stackLength=scale._parseValue(datasets[imeta.index].data[index]);ivalue=stackLength.start===undefined?stackLength.end:stackLength.min>=0&&stackLength.max>=0?stackLength.max:stackLength.min;if((value.min<0&&ivalue<0)||(value.max>=0&&ivalue>0)){start+=ivalue}}}}
base=scale.getPixelForValue(start);head=scale.getPixelForValue(start+length);size=head-base;if(minBarLength!==undefined&&Math.abs(size)<minBarLength){size=minBarLength;if(length>=0&&!isHorizontal||length<0&&isHorizontal){head=base-minBarLength}else{head=base+minBarLength}}
return{size:size,base:base,head:head,center:head+size/2}},calculateBarIndexPixels:function(datasetIndex,index,ruler,options){var me=this;var range=options.barThickness==='flex'?computeFlexCategoryTraits(index,ruler,options):computeFitCategoryTraits(index,ruler,options);var stackIndex=me.getStackIndex(datasetIndex,me.getMeta().stack);var center=range.start+(range.chunk*stackIndex)+(range.chunk/2);var size=Math.min(valueOrDefault$3(options.maxBarThickness,Infinity),range.chunk*range.ratio);return{base:center-size/2,head:center+size/2,center:center,size:size}},draw:function(){var me=this;var chart=me.chart;var scale=me._getValueScale();var rects=me.getMeta().data;var dataset=me.getDataset();var ilen=rects.length;var i=0;helpers$1.canvas.clipArea(chart.ctx,chart.chartArea);for(;i<ilen;++i){var val=scale._parseValue(dataset.data[i]);if(!isNaN(val.min)&&!isNaN(val.max)){rects[i].draw()}}
helpers$1.canvas.unclipArea(chart.ctx)},_resolveDataElementOptions:function(){var me=this;var values=helpers$1.extend({},core_datasetController.prototype._resolveDataElementOptions.apply(me,arguments));var indexOpts=me._getIndexScale().options;var valueOpts=me._getValueScale().options;values.barPercentage=valueOrDefault$3(indexOpts.barPercentage,values.barPercentage);values.barThickness=valueOrDefault$3(indexOpts.barThickness,values.barThickness);values.categoryPercentage=valueOrDefault$3(indexOpts.categoryPercentage,values.categoryPercentage);values.maxBarThickness=valueOrDefault$3(indexOpts.maxBarThickness,values.maxBarThickness);values.minBarLength=valueOrDefault$3(valueOpts.minBarLength,values.minBarLength);return values}});var valueOrDefault$4=helpers$1.valueOrDefault;var resolve$1=helpers$1.options.resolve;core_defaults._set('bubble',{hover:{mode:'single'},scales:{xAxes:[{type:'linear',position:'bottom',id:'x-axis-0'}],yAxes:[{type:'linear',position:'left',id:'y-axis-0'}]},tooltips:{callbacks:{title:function(){return''},label:function(item,data){var datasetLabel=data.datasets[item.datasetIndex].label||'';var dataPoint=data.datasets[item.datasetIndex].data[item.index];return datasetLabel+': ('+item.xLabel+', '+item.yLabel+', '+dataPoint.r+')'}}}});var controller_bubble=core_datasetController.extend({dataElementType:elements.Point,_dataElementOptions:['backgroundColor','borderColor','borderWidth','hoverBackgroundColor','hoverBorderColor','hoverBorderWidth','hoverRadius','hitRadius','pointStyle','rotation'],update:function(reset){var me=this;var meta=me.getMeta();var points=meta.data;helpers$1.each(points,function(point,index){me.updateElement(point,index,reset)})},updateElement:function(point,index,reset){var me=this;var meta=me.getMeta();var custom=point.custom||{};var xScale=me.getScaleForId(meta.xAxisID);var yScale=me.getScaleForId(meta.yAxisID);var options=me._resolveDataElementOptions(point,index);var data=me.getDataset().data[index];var dsIndex=me.index;var x=reset?xScale.getPixelForDecimal(0.5):xScale.getPixelForValue(typeof data==='object'?data:NaN,index,dsIndex);var y=reset?yScale.getBasePixel():yScale.getPixelForValue(data,index,dsIndex);point._xScale=xScale;point._yScale=yScale;point._options=options;point._datasetIndex=dsIndex;point._index=index;point._model={backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderWidth:options.borderWidth,hitRadius:options.hitRadius,pointStyle:options.pointStyle,rotation:options.rotation,radius:reset?0:options.radius,skip:custom.skip||isNaN(x)||isNaN(y),x:x,y:y,};point.pivot()},setHoverStyle:function(point){var model=point._model;var options=point._options;var getHoverColor=helpers$1.getHoverColor;point.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth,radius:model.radius};model.backgroundColor=valueOrDefault$4(options.hoverBackgroundColor,getHoverColor(options.backgroundColor));model.borderColor=valueOrDefault$4(options.hoverBorderColor,getHoverColor(options.borderColor));model.borderWidth=valueOrDefault$4(options.hoverBorderWidth,options.borderWidth);model.radius=options.radius+options.hoverRadius},_resolveDataElementOptions:function(point,index){var me=this;var chart=me.chart;var dataset=me.getDataset();var custom=point.custom||{};var data=dataset.data[index]||{};var values=core_datasetController.prototype._resolveDataElementOptions.apply(me,arguments);var context={chart:chart,dataIndex:index,dataset:dataset,datasetIndex:me.index};if(me._cachedDataOpts===values){values=helpers$1.extend({},values)}
values.radius=resolve$1([custom.radius,data.r,me._config.radius,chart.options.elements.point.radius],context,index);return values}});var valueOrDefault$5=helpers$1.valueOrDefault;var PI$1=Math.PI;var DOUBLE_PI$1=PI$1*2;var HALF_PI$1=PI$1/2;core_defaults._set('doughnut',{animation:{animateRotate:!0,animateScale:!1},hover:{mode:'single'},legendCallback:function(chart){var list=document.createElement('ul');var data=chart.data;var datasets=data.datasets;var labels=data.labels;var i,ilen,listItem,listItemSpan;list.setAttribute('class',chart.id+'-legend');if(datasets.length){for(i=0,ilen=datasets[0].data.length;i<ilen;++i){listItem=list.appendChild(document.createElement('li'));listItemSpan=listItem.appendChild(document.createElement('span'));listItemSpan.style.backgroundColor=datasets[0].backgroundColor[i];if(labels[i]){listItem.appendChild(document.createTextNode(labels[i]))}}}
return list.outerHTML},legend:{labels:{generateLabels:function(chart){var data=chart.data;if(data.labels.length&&data.datasets.length){return data.labels.map(function(label,i){var meta=chart.getDatasetMeta(0);var style=meta.controller.getStyle(i);return{text:label,fillStyle:style.backgroundColor,strokeStyle:style.borderColor,lineWidth:style.borderWidth,hidden:isNaN(data.datasets[0].data[i])||meta.data[i].hidden,index:i}})}
return[]}},onClick:function(e,legendItem){var index=legendItem.index;var chart=this.chart;var i,ilen,meta;for(i=0,ilen=(chart.data.datasets||[]).length;i<ilen;++i){meta=chart.getDatasetMeta(i);if(meta.data[index]){meta.data[index].hidden=!meta.data[index].hidden}}
chart.update()}},cutoutPercentage:50,rotation:-HALF_PI$1,circumference:DOUBLE_PI$1,tooltips:{callbacks:{title:function(){return''},label:function(tooltipItem,data){var dataLabel=data.labels[tooltipItem.index];var value=': '+data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index];if(helpers$1.isArray(dataLabel)){dataLabel=dataLabel.slice();dataLabel[0]+=value}else{dataLabel+=value}
return dataLabel}}}});var controller_doughnut=core_datasetController.extend({dataElementType:elements.Arc,linkScales:helpers$1.noop,_dataElementOptions:['backgroundColor','borderColor','borderWidth','borderAlign','hoverBackgroundColor','hoverBorderColor','hoverBorderWidth',],getRingIndex:function(datasetIndex){var ringIndex=0;for(var j=0;j<datasetIndex;++j){if(this.chart.isDatasetVisible(j)){++ringIndex}}
return ringIndex},update:function(reset){var me=this;var chart=me.chart;var chartArea=chart.chartArea;var opts=chart.options;var ratioX=1;var ratioY=1;var offsetX=0;var offsetY=0;var meta=me.getMeta();var arcs=meta.data;var cutout=opts.cutoutPercentage/100||0;var circumference=opts.circumference;var chartWeight=me._getRingWeight(me.index);var maxWidth,maxHeight,i,ilen;if(circumference<DOUBLE_PI$1){var startAngle=opts.rotation%DOUBLE_PI$1;startAngle+=startAngle>=PI$1?-DOUBLE_PI$1:startAngle<-PI$1?DOUBLE_PI$1:0;var endAngle=startAngle+circumference;var startX=Math.cos(startAngle);var startY=Math.sin(startAngle);var endX=Math.cos(endAngle);var endY=Math.sin(endAngle);var contains0=(startAngle<=0&&endAngle>=0)||endAngle>=DOUBLE_PI$1;var contains90=(startAngle<=HALF_PI$1&&endAngle>=HALF_PI$1)||endAngle>=DOUBLE_PI$1+HALF_PI$1;var contains180=startAngle===-PI$1||endAngle>=PI$1;var contains270=(startAngle<=-HALF_PI$1&&endAngle>=-HALF_PI$1)||endAngle>=PI$1+HALF_PI$1;var minX=contains180?-1:Math.min(startX,startX*cutout,endX,endX*cutout);var minY=contains270?-1:Math.min(startY,startY*cutout,endY,endY*cutout);var maxX=contains0?1:Math.max(startX,startX*cutout,endX,endX*cutout);var maxY=contains90?1:Math.max(startY,startY*cutout,endY,endY*cutout);ratioX=(maxX-minX)/2;ratioY=(maxY-minY)/2;offsetX=-(maxX+minX)/2;offsetY=-(maxY+minY)/2}
for(i=0,ilen=arcs.length;i<ilen;++i){arcs[i]._options=me._resolveDataElementOptions(arcs[i],i)}
chart.borderWidth=me.getMaxBorderWidth();maxWidth=(chartArea.right-chartArea.left-chart.borderWidth)/ratioX;maxHeight=(chartArea.bottom-chartArea.top-chart.borderWidth)/ratioY;chart.outerRadius=Math.max(Math.min(maxWidth,maxHeight)/2,0);chart.innerRadius=Math.max(chart.outerRadius*cutout,0);chart.radiusLength=(chart.outerRadius-chart.innerRadius)/(me._getVisibleDatasetWeightTotal()||1);chart.offsetX=offsetX*chart.outerRadius;chart.offsetY=offsetY*chart.outerRadius;meta.total=me.calculateTotal();me.outerRadius=chart.outerRadius-chart.radiusLength*me._getRingWeightOffset(me.index);me.innerRadius=Math.max(me.outerRadius-chart.radiusLength*chartWeight,0);for(i=0,ilen=arcs.length;i<ilen;++i){me.updateElement(arcs[i],i,reset)}},updateElement:function(arc,index,reset){var me=this;var chart=me.chart;var chartArea=chart.chartArea;var opts=chart.options;var animationOpts=opts.animation;var centerX=(chartArea.left+chartArea.right)/2;var centerY=(chartArea.top+chartArea.bottom)/2;var startAngle=opts.rotation;var endAngle=opts.rotation;var dataset=me.getDataset();var circumference=reset&&animationOpts.animateRotate?0:arc.hidden?0:me.calculateCircumference(dataset.data[index])*(opts.circumference/DOUBLE_PI$1);var innerRadius=reset&&animationOpts.animateScale?0:me.innerRadius;var outerRadius=reset&&animationOpts.animateScale?0:me.outerRadius;var options=arc._options||{};helpers$1.extend(arc,{_datasetIndex:me.index,_index:index,_model:{backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderWidth:options.borderWidth,borderAlign:options.borderAlign,x:centerX+chart.offsetX,y:centerY+chart.offsetY,startAngle:startAngle,endAngle:endAngle,circumference:circumference,outerRadius:outerRadius,innerRadius:innerRadius,label:helpers$1.valueAtIndexOrDefault(dataset.label,index,chart.data.labels[index])}});var model=arc._model;if(!reset||!animationOpts.animateRotate){if(index===0){model.startAngle=opts.rotation}else{model.startAngle=me.getMeta().data[index-1]._model.endAngle}
model.endAngle=model.startAngle+model.circumference}
arc.pivot()},calculateTotal:function(){var dataset=this.getDataset();var meta=this.getMeta();var total=0;var value;helpers$1.each(meta.data,function(element,index){value=dataset.data[index];if(!isNaN(value)&&!element.hidden){total+=Math.abs(value)}});return total},calculateCircumference:function(value){var total=this.getMeta().total;if(total>0&&!isNaN(value)){return DOUBLE_PI$1*(Math.abs(value)/total)}
return 0},getMaxBorderWidth:function(arcs){var me=this;var max=0;var chart=me.chart;var i,ilen,meta,arc,controller,options,borderWidth,hoverWidth;if(!arcs){for(i=0,ilen=chart.data.datasets.length;i<ilen;++i){if(chart.isDatasetVisible(i)){meta=chart.getDatasetMeta(i);arcs=meta.data;if(i!==me.index){controller=meta.controller}
break}}}
if(!arcs){return 0}
for(i=0,ilen=arcs.length;i<ilen;++i){arc=arcs[i];if(controller){controller._configure();options=controller._resolveDataElementOptions(arc,i)}else{options=arc._options}
if(options.borderAlign!=='inner'){borderWidth=options.borderWidth;hoverWidth=options.hoverBorderWidth;max=borderWidth>max?borderWidth:max;max=hoverWidth>max?hoverWidth:max}}
return max},setHoverStyle:function(arc){var model=arc._model;var options=arc._options;var getHoverColor=helpers$1.getHoverColor;arc.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth,};model.backgroundColor=valueOrDefault$5(options.hoverBackgroundColor,getHoverColor(options.backgroundColor));model.borderColor=valueOrDefault$5(options.hoverBorderColor,getHoverColor(options.borderColor));model.borderWidth=valueOrDefault$5(options.hoverBorderWidth,options.borderWidth)},_getRingWeightOffset:function(datasetIndex){var ringWeightOffset=0;for(var i=0;i<datasetIndex;++i){if(this.chart.isDatasetVisible(i)){ringWeightOffset+=this._getRingWeight(i)}}
return ringWeightOffset},_getRingWeight:function(dataSetIndex){return Math.max(valueOrDefault$5(this.chart.data.datasets[dataSetIndex].weight,1),0)},_getVisibleDatasetWeightTotal:function(){return this._getRingWeightOffset(this.chart.data.datasets.length)}});core_defaults._set('horizontalBar',{hover:{mode:'index',axis:'y'},scales:{xAxes:[{type:'linear',position:'bottom'}],yAxes:[{type:'category',position:'left',offset:!0,gridLines:{offsetGridLines:!0}}]},elements:{rectangle:{borderSkipped:'left'}},tooltips:{mode:'index',axis:'y'}});core_defaults._set('global',{datasets:{horizontalBar:{categoryPercentage:0.8,barPercentage:0.9}}});var controller_horizontalBar=controller_bar.extend({_getValueScaleId:function(){return this.getMeta().xAxisID},_getIndexScaleId:function(){return this.getMeta().yAxisID}});var valueOrDefault$6=helpers$1.valueOrDefault;var resolve$2=helpers$1.options.resolve;var isPointInArea=helpers$1.canvas._isPointInArea;core_defaults._set('line',{showLines:!0,spanGaps:!1,hover:{mode:'label'},scales:{xAxes:[{type:'category',id:'x-axis-0'}],yAxes:[{type:'linear',id:'y-axis-0'}]}});function scaleClip(scale,halfBorderWidth){var tickOpts=scale&&scale.options.ticks||{};var reverse=tickOpts.reverse;var min=tickOpts.min===undefined?halfBorderWidth:0;var max=tickOpts.max===undefined?halfBorderWidth:0;return{start:reverse?max:min,end:reverse?min:max}}
function defaultClip(xScale,yScale,borderWidth){var halfBorderWidth=borderWidth/2;var x=scaleClip(xScale,halfBorderWidth);var y=scaleClip(yScale,halfBorderWidth);return{top:y.end,right:x.end,bottom:y.start,left:x.start}}
function toClip(value){var t,r,b,l;if(helpers$1.isObject(value)){t=value.top;r=value.right;b=value.bottom;l=value.left}else{t=r=b=l=value}
return{top:t,right:r,bottom:b,left:l}}
var controller_line=core_datasetController.extend({datasetElementType:elements.Line,dataElementType:elements.Point,_datasetElementOptions:['backgroundColor','borderCapStyle','borderColor','borderDash','borderDashOffset','borderJoinStyle','borderWidth','cubicInterpolationMode','fill'],_dataElementOptions:{backgroundColor:'pointBackgroundColor',borderColor:'pointBorderColor',borderWidth:'pointBorderWidth',hitRadius:'pointHitRadius',hoverBackgroundColor:'pointHoverBackgroundColor',hoverBorderColor:'pointHoverBorderColor',hoverBorderWidth:'pointHoverBorderWidth',hoverRadius:'pointHoverRadius',pointStyle:'pointStyle',radius:'pointRadius',rotation:'pointRotation'},update:function(reset){var me=this;var meta=me.getMeta();var line=meta.dataset;var points=meta.data||[];var options=me.chart.options;var config=me._config;var showLine=me._showLine=valueOrDefault$6(config.showLine,options.showLines);var i,ilen;me._xScale=me.getScaleForId(meta.xAxisID);me._yScale=me.getScaleForId(meta.yAxisID);if(showLine){if(config.tension!==undefined&&config.lineTension===undefined){config.lineTension=config.tension}
line._scale=me._yScale;line._datasetIndex=me.index;line._children=points;line._model=me._resolveDatasetElementOptions(line);line.pivot()}
for(i=0,ilen=points.length;i<ilen;++i){me.updateElement(points[i],i,reset)}
if(showLine&&line._model.tension!==0){me.updateBezierControlPoints()}
for(i=0,ilen=points.length;i<ilen;++i){points[i].pivot()}},updateElement:function(point,index,reset){var me=this;var meta=me.getMeta();var custom=point.custom||{};var dataset=me.getDataset();var datasetIndex=me.index;var value=dataset.data[index];var xScale=me._xScale;var yScale=me._yScale;var lineModel=meta.dataset._model;var x,y;var options=me._resolveDataElementOptions(point,index);x=xScale.getPixelForValue(typeof value==='object'?value:NaN,index,datasetIndex);y=reset?yScale.getBasePixel():me.calculatePointY(value,index,datasetIndex);point._xScale=xScale;point._yScale=yScale;point._options=options;point._datasetIndex=datasetIndex;point._index=index;point._model={x:x,y:y,skip:custom.skip||isNaN(x)||isNaN(y),radius:options.radius,pointStyle:options.pointStyle,rotation:options.rotation,backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderWidth:options.borderWidth,tension:valueOrDefault$6(custom.tension,lineModel?lineModel.tension:0),steppedLine:lineModel?lineModel.steppedLine:!1,hitRadius:options.hitRadius}},_resolveDatasetElementOptions:function(element){var me=this;var config=me._config;var custom=element.custom||{};var options=me.chart.options;var lineOptions=options.elements.line;var values=core_datasetController.prototype._resolveDatasetElementOptions.apply(me,arguments);values.spanGaps=valueOrDefault$6(config.spanGaps,options.spanGaps);values.tension=valueOrDefault$6(config.lineTension,lineOptions.tension);values.steppedLine=resolve$2([custom.steppedLine,config.steppedLine,lineOptions.stepped]);values.clip=toClip(valueOrDefault$6(config.clip,defaultClip(me._xScale,me._yScale,values.borderWidth)));return values},calculatePointY:function(value,index,datasetIndex){var me=this;var chart=me.chart;var yScale=me._yScale;var sumPos=0;var sumNeg=0;var i,ds,dsMeta,stackedRightValue,rightValue,metasets,ilen;if(yScale.options.stacked){rightValue=+yScale.getRightValue(value);metasets=chart._getSortedVisibleDatasetMetas();ilen=metasets.length;for(i=0;i<ilen;++i){dsMeta=metasets[i];if(dsMeta.index===datasetIndex){break}
ds=chart.data.datasets[dsMeta.index];if(dsMeta.type==='line'&&dsMeta.yAxisID===yScale.id){stackedRightValue=+yScale.getRightValue(ds.data[index]);if(stackedRightValue<0){sumNeg+=stackedRightValue||0}else{sumPos+=stackedRightValue||0}}}
if(rightValue<0){return yScale.getPixelForValue(sumNeg+rightValue)}
return yScale.getPixelForValue(sumPos+rightValue)}
return yScale.getPixelForValue(value)},updateBezierControlPoints:function(){var me=this;var chart=me.chart;var meta=me.getMeta();var lineModel=meta.dataset._model;var area=chart.chartArea;var points=meta.data||[];var i,ilen,model,controlPoints;if(lineModel.spanGaps){points=points.filter(function(pt){return!pt._model.skip})}
function capControlPoint(pt,min,max){return Math.max(Math.min(pt,max),min)}
if(lineModel.cubicInterpolationMode==='monotone'){helpers$1.splineCurveMonotone(points)}else{for(i=0,ilen=points.length;i<ilen;++i){model=points[i]._model;controlPoints=helpers$1.splineCurve(helpers$1.previousItem(points,i)._model,model,helpers$1.nextItem(points,i)._model,lineModel.tension);model.controlPointPreviousX=controlPoints.previous.x;model.controlPointPreviousY=controlPoints.previous.y;model.controlPointNextX=controlPoints.next.x;model.controlPointNextY=controlPoints.next.y}}
if(chart.options.elements.line.capBezierPoints){for(i=0,ilen=points.length;i<ilen;++i){model=points[i]._model;if(isPointInArea(model,area)){if(i>0&&isPointInArea(points[i-1]._model,area)){model.controlPointPreviousX=capControlPoint(model.controlPointPreviousX,area.left,area.right);model.controlPointPreviousY=capControlPoint(model.controlPointPreviousY,area.top,area.bottom)}
if(i<points.length-1&&isPointInArea(points[i+1]._model,area)){model.controlPointNextX=capControlPoint(model.controlPointNextX,area.left,area.right);model.controlPointNextY=capControlPoint(model.controlPointNextY,area.top,area.bottom)}}}}},draw:function(){var me=this;var chart=me.chart;var meta=me.getMeta();var points=meta.data||[];var area=chart.chartArea;var canvas=chart.canvas;var i=0;var ilen=points.length;var clip;if(me._showLine){clip=meta.dataset._model.clip;helpers$1.canvas.clipArea(chart.ctx,{left:clip.left===!1?0:area.left-clip.left,right:clip.right===!1?canvas.width:area.right+clip.right,top:clip.top===!1?0:area.top-clip.top,bottom:clip.bottom===!1?canvas.height:area.bottom+clip.bottom});meta.dataset.draw();helpers$1.canvas.unclipArea(chart.ctx)}
for(;i<ilen;++i){points[i].draw(area)}},setHoverStyle:function(point){var model=point._model;var options=point._options;var getHoverColor=helpers$1.getHoverColor;point.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth,radius:model.radius};model.backgroundColor=valueOrDefault$6(options.hoverBackgroundColor,getHoverColor(options.backgroundColor));model.borderColor=valueOrDefault$6(options.hoverBorderColor,getHoverColor(options.borderColor));model.borderWidth=valueOrDefault$6(options.hoverBorderWidth,options.borderWidth);model.radius=valueOrDefault$6(options.hoverRadius,options.radius)},});var resolve$3=helpers$1.options.resolve;core_defaults._set('polarArea',{scale:{type:'radialLinear',angleLines:{display:!1},gridLines:{circular:!0},pointLabels:{display:!1},ticks:{beginAtZero:!0}},animation:{animateRotate:!0,animateScale:!0},startAngle:-0.5*Math.PI,legendCallback:function(chart){var list=document.createElement('ul');var data=chart.data;var datasets=data.datasets;var labels=data.labels;var i,ilen,listItem,listItemSpan;list.setAttribute('class',chart.id+'-legend');if(datasets.length){for(i=0,ilen=datasets[0].data.length;i<ilen;++i){listItem=list.appendChild(document.createElement('li'));listItemSpan=listItem.appendChild(document.createElement('span'));listItemSpan.style.backgroundColor=datasets[0].backgroundColor[i];if(labels[i]){listItem.appendChild(document.createTextNode(labels[i]))}}}
return list.outerHTML},legend:{labels:{generateLabels:function(chart){var data=chart.data;if(data.labels.length&&data.datasets.length){return data.labels.map(function(label,i){var meta=chart.getDatasetMeta(0);var style=meta.controller.getStyle(i);return{text:label,fillStyle:style.backgroundColor,strokeStyle:style.borderColor,lineWidth:style.borderWidth,hidden:isNaN(data.datasets[0].data[i])||meta.data[i].hidden,index:i}})}
return[]}},onClick:function(e,legendItem){var index=legendItem.index;var chart=this.chart;var i,ilen,meta;for(i=0,ilen=(chart.data.datasets||[]).length;i<ilen;++i){meta=chart.getDatasetMeta(i);meta.data[index].hidden=!meta.data[index].hidden}
chart.update()}},tooltips:{callbacks:{title:function(){return''},label:function(item,data){return data.labels[item.index]+': '+item.yLabel}}}});var controller_polarArea=core_datasetController.extend({dataElementType:elements.Arc,linkScales:helpers$1.noop,_dataElementOptions:['backgroundColor','borderColor','borderWidth','borderAlign','hoverBackgroundColor','hoverBorderColor','hoverBorderWidth',],_getIndexScaleId:function(){return this.chart.scale.id},_getValueScaleId:function(){return this.chart.scale.id},update:function(reset){var me=this;var dataset=me.getDataset();var meta=me.getMeta();var start=me.chart.options.startAngle||0;var starts=me._starts=[];var angles=me._angles=[];var arcs=meta.data;var i,ilen,angle;me._updateRadius();meta.count=me.countVisibleElements();for(i=0,ilen=dataset.data.length;i<ilen;i++){starts[i]=start;angle=me._computeAngle(i);angles[i]=angle;start+=angle}
for(i=0,ilen=arcs.length;i<ilen;++i){arcs[i]._options=me._resolveDataElementOptions(arcs[i],i);me.updateElement(arcs[i],i,reset)}},_updateRadius:function(){var me=this;var chart=me.chart;var chartArea=chart.chartArea;var opts=chart.options;var minSize=Math.min(chartArea.right-chartArea.left,chartArea.bottom-chartArea.top);chart.outerRadius=Math.max(minSize/2,0);chart.innerRadius=Math.max(opts.cutoutPercentage?(chart.outerRadius/100)*(opts.cutoutPercentage):1,0);chart.radiusLength=(chart.outerRadius-chart.innerRadius)/chart.getVisibleDatasetCount();me.outerRadius=chart.outerRadius-(chart.radiusLength*me.index);me.innerRadius=me.outerRadius-chart.radiusLength},updateElement:function(arc,index,reset){var me=this;var chart=me.chart;var dataset=me.getDataset();var opts=chart.options;var animationOpts=opts.animation;var scale=chart.scale;var labels=chart.data.labels;var centerX=scale.xCenter;var centerY=scale.yCenter;var datasetStartAngle=opts.startAngle;var distance=arc.hidden?0:scale.getDistanceFromCenterForValue(dataset.data[index]);var startAngle=me._starts[index];var endAngle=startAngle+(arc.hidden?0:me._angles[index]);var resetRadius=animationOpts.animateScale?0:scale.getDistanceFromCenterForValue(dataset.data[index]);var options=arc._options||{};helpers$1.extend(arc,{_datasetIndex:me.index,_index:index,_scale:scale,_model:{backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderWidth:options.borderWidth,borderAlign:options.borderAlign,x:centerX,y:centerY,innerRadius:0,outerRadius:reset?resetRadius:distance,startAngle:reset&&animationOpts.animateRotate?datasetStartAngle:startAngle,endAngle:reset&&animationOpts.animateRotate?datasetStartAngle:endAngle,label:helpers$1.valueAtIndexOrDefault(labels,index,labels[index])}});arc.pivot()},countVisibleElements:function(){var dataset=this.getDataset();var meta=this.getMeta();var count=0;helpers$1.each(meta.data,function(element,index){if(!isNaN(dataset.data[index])&&!element.hidden){count++}});return count},setHoverStyle:function(arc){var model=arc._model;var options=arc._options;var getHoverColor=helpers$1.getHoverColor;var valueOrDefault=helpers$1.valueOrDefault;arc.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth,};model.backgroundColor=valueOrDefault(options.hoverBackgroundColor,getHoverColor(options.backgroundColor));model.borderColor=valueOrDefault(options.hoverBorderColor,getHoverColor(options.borderColor));model.borderWidth=valueOrDefault(options.hoverBorderWidth,options.borderWidth)},_computeAngle:function(index){var me=this;var count=this.getMeta().count;var dataset=me.getDataset();var meta=me.getMeta();if(isNaN(dataset.data[index])||meta.data[index].hidden){return 0}
var context={chart:me.chart,dataIndex:index,dataset:dataset,datasetIndex:me.index};return resolve$3([me.chart.options.elements.arc.angle,(2*Math.PI)/count],context,index)}});core_defaults._set('pie',helpers$1.clone(core_defaults.doughnut));core_defaults._set('pie',{cutoutPercentage:0});var controller_pie=controller_doughnut;var valueOrDefault$7=helpers$1.valueOrDefault;core_defaults._set('radar',{spanGaps:!1,scale:{type:'radialLinear'},elements:{line:{fill:'start',tension:0}}});var controller_radar=core_datasetController.extend({datasetElementType:elements.Line,dataElementType:elements.Point,linkScales:helpers$1.noop,_datasetElementOptions:['backgroundColor','borderWidth','borderColor','borderCapStyle','borderDash','borderDashOffset','borderJoinStyle','fill'],_dataElementOptions:{backgroundColor:'pointBackgroundColor',borderColor:'pointBorderColor',borderWidth:'pointBorderWidth',hitRadius:'pointHitRadius',hoverBackgroundColor:'pointHoverBackgroundColor',hoverBorderColor:'pointHoverBorderColor',hoverBorderWidth:'pointHoverBorderWidth',hoverRadius:'pointHoverRadius',pointStyle:'pointStyle',radius:'pointRadius',rotation:'pointRotation'},_getIndexScaleId:function(){return this.chart.scale.id},_getValueScaleId:function(){return this.chart.scale.id},update:function(reset){var me=this;var meta=me.getMeta();var line=meta.dataset;var points=meta.data||[];var scale=me.chart.scale;var config=me._config;var i,ilen;if(config.tension!==undefined&&config.lineTension===undefined){config.lineTension=config.tension}
line._scale=scale;line._datasetIndex=me.index;line._children=points;line._loop=!0;line._model=me._resolveDatasetElementOptions(line);line.pivot();for(i=0,ilen=points.length;i<ilen;++i){me.updateElement(points[i],i,reset)}
me.updateBezierControlPoints();for(i=0,ilen=points.length;i<ilen;++i){points[i].pivot()}},updateElement:function(point,index,reset){var me=this;var custom=point.custom||{};var dataset=me.getDataset();var scale=me.chart.scale;var pointPosition=scale.getPointPositionForValue(index,dataset.data[index]);var options=me._resolveDataElementOptions(point,index);var lineModel=me.getMeta().dataset._model;var x=reset?scale.xCenter:pointPosition.x;var y=reset?scale.yCenter:pointPosition.y;point._scale=scale;point._options=options;point._datasetIndex=me.index;point._index=index;point._model={x:x,y:y,skip:custom.skip||isNaN(x)||isNaN(y),radius:options.radius,pointStyle:options.pointStyle,rotation:options.rotation,backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderWidth:options.borderWidth,tension:valueOrDefault$7(custom.tension,lineModel?lineModel.tension:0),hitRadius:options.hitRadius}},_resolveDatasetElementOptions:function(){var me=this;var config=me._config;var options=me.chart.options;var values=core_datasetController.prototype._resolveDatasetElementOptions.apply(me,arguments);values.spanGaps=valueOrDefault$7(config.spanGaps,options.spanGaps);values.tension=valueOrDefault$7(config.lineTension,options.elements.line.tension);return values},updateBezierControlPoints:function(){var me=this;var meta=me.getMeta();var area=me.chart.chartArea;var points=meta.data||[];var i,ilen,model,controlPoints;if(meta.dataset._model.spanGaps){points=points.filter(function(pt){return!pt._model.skip})}
function capControlPoint(pt,min,max){return Math.max(Math.min(pt,max),min)}
for(i=0,ilen=points.length;i<ilen;++i){model=points[i]._model;controlPoints=helpers$1.splineCurve(helpers$1.previousItem(points,i,!0)._model,model,helpers$1.nextItem(points,i,!0)._model,model.tension);model.controlPointPreviousX=capControlPoint(controlPoints.previous.x,area.left,area.right);model.controlPointPreviousY=capControlPoint(controlPoints.previous.y,area.top,area.bottom);model.controlPointNextX=capControlPoint(controlPoints.next.x,area.left,area.right);model.controlPointNextY=capControlPoint(controlPoints.next.y,area.top,area.bottom)}},setHoverStyle:function(point){var model=point._model;var options=point._options;var getHoverColor=helpers$1.getHoverColor;point.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth,radius:model.radius};model.backgroundColor=valueOrDefault$7(options.hoverBackgroundColor,getHoverColor(options.backgroundColor));model.borderColor=valueOrDefault$7(options.hoverBorderColor,getHoverColor(options.borderColor));model.borderWidth=valueOrDefault$7(options.hoverBorderWidth,options.borderWidth);model.radius=valueOrDefault$7(options.hoverRadius,options.radius)}});core_defaults._set('scatter',{hover:{mode:'single'},scales:{xAxes:[{id:'x-axis-1',type:'linear',position:'bottom'}],yAxes:[{id:'y-axis-1',type:'linear',position:'left'}]},tooltips:{callbacks:{title:function(){return''},label:function(item){return'('+item.xLabel+', '+item.yLabel+')'}}}});core_defaults._set('global',{datasets:{scatter:{showLine:!1}}});var controller_scatter=controller_line;var controllers={bar:controller_bar,bubble:controller_bubble,doughnut:controller_doughnut,horizontalBar:controller_horizontalBar,line:controller_line,polarArea:controller_polarArea,pie:controller_pie,radar:controller_radar,scatter:controller_scatter};function getRelativePosition(e,chart){if(e.native){return{x:e.x,y:e.y}}
return helpers$1.getRelativePosition(e,chart)}
function parseVisibleItems(chart,handler){var metasets=chart._getSortedVisibleDatasetMetas();var metadata,i,j,ilen,jlen,element;for(i=0,ilen=metasets.length;i<ilen;++i){metadata=metasets[i].data;for(j=0,jlen=metadata.length;j<jlen;++j){element=metadata[j];if(!element._view.skip){handler(element)}}}}
function getIntersectItems(chart,position){var elements=[];parseVisibleItems(chart,function(element){if(element.inRange(position.x,position.y)){elements.push(element)}});return elements}
function getNearestItems(chart,position,intersect,distanceMetric){var minDistance=Number.POSITIVE_INFINITY;var nearestItems=[];parseVisibleItems(chart,function(element){if(intersect&&!element.inRange(position.x,position.y)){return}
var center=element.getCenterPoint();var distance=distanceMetric(position,center);if(distance<minDistance){nearestItems=[element];minDistance=distance}else if(distance===minDistance){nearestItems.push(element)}});return nearestItems}
function getDistanceMetricForAxis(axis){var useX=axis.indexOf('x')!==-1;var useY=axis.indexOf('y')!==-1;return function(pt1,pt2){var deltaX=useX?Math.abs(pt1.x-pt2.x):0;var deltaY=useY?Math.abs(pt1.y-pt2.y):0;return Math.sqrt(Math.pow(deltaX,2)+Math.pow(deltaY,2))}}
function indexMode(chart,e,options){var position=getRelativePosition(e,chart);options.axis=options.axis||'x';var distanceMetric=getDistanceMetricForAxis(options.axis);var items=options.intersect?getIntersectItems(chart,position):getNearestItems(chart,position,!1,distanceMetric);var elements=[];if(!items.length){return[]}
chart._getSortedVisibleDatasetMetas().forEach(function(meta){var element=meta.data[items[0]._index];if(element&&!element._view.skip){elements.push(element)}});return elements}
var core_interaction={modes:{single:function(chart,e){var position=getRelativePosition(e,chart);var elements=[];parseVisibleItems(chart,function(element){if(element.inRange(position.x,position.y)){elements.push(element);return elements}});return elements.slice(0,1)},label:indexMode,index:indexMode,dataset:function(chart,e,options){var position=getRelativePosition(e,chart);options.axis=options.axis||'xy';var distanceMetric=getDistanceMetricForAxis(options.axis);var items=options.intersect?getIntersectItems(chart,position):getNearestItems(chart,position,!1,distanceMetric);if(items.length>0){items=chart.getDatasetMeta(items[0]._datasetIndex).data}
return items},'x-axis':function(chart,e){return indexMode(chart,e,{intersect:!1})},point:function(chart,e){var position=getRelativePosition(e,chart);return getIntersectItems(chart,position)},nearest:function(chart,e,options){var position=getRelativePosition(e,chart);options.axis=options.axis||'xy';var distanceMetric=getDistanceMetricForAxis(options.axis);return getNearestItems(chart,position,options.intersect,distanceMetric)},x:function(chart,e,options){var position=getRelativePosition(e,chart);var items=[];var intersectsItem=!1;parseVisibleItems(chart,function(element){if(element.inXRange(position.x)){items.push(element)}
if(element.inRange(position.x,position.y)){intersectsItem=!0}});if(options.intersect&&!intersectsItem){items=[]}
return items},y:function(chart,e,options){var position=getRelativePosition(e,chart);var items=[];var intersectsItem=!1;parseVisibleItems(chart,function(element){if(element.inYRange(position.y)){items.push(element)}
if(element.inRange(position.x,position.y)){intersectsItem=!0}});if(options.intersect&&!intersectsItem){items=[]}
return items}}};var extend=helpers$1.extend;function filterByPosition(array,position){return helpers$1.where(array,function(v){return v.pos===position})}
function sortByWeight(array,reverse){return array.sort(function(a,b){var v0=reverse?b:a;var v1=reverse?a:b;return v0.weight===v1.weight?v0.index-v1.index:v0.weight-v1.weight})}
function wrapBoxes(boxes){var layoutBoxes=[];var i,ilen,box;for(i=0,ilen=(boxes||[]).length;i<ilen;++i){box=boxes[i];layoutBoxes.push({index:i,box:box,pos:box.position,horizontal:box.isHorizontal(),weight:box.weight})}
return layoutBoxes}
function setLayoutDims(layouts,params){var i,ilen,layout;for(i=0,ilen=layouts.length;i<ilen;++i){layout=layouts[i];layout.width=layout.horizontal?layout.box.fullWidth&&params.availableWidth:params.vBoxMaxWidth;layout.height=layout.horizontal&&params.hBoxMaxHeight}}
function buildLayoutBoxes(boxes){var layoutBoxes=wrapBoxes(boxes);var left=sortByWeight(filterByPosition(layoutBoxes,'left'),!0);var right=sortByWeight(filterByPosition(layoutBoxes,'right'));var top=sortByWeight(filterByPosition(layoutBoxes,'top'),!0);var bottom=sortByWeight(filterByPosition(layoutBoxes,'bottom'));return{leftAndTop:left.concat(top),rightAndBottom:right.concat(bottom),chartArea:filterByPosition(layoutBoxes,'chartArea'),vertical:left.concat(right),horizontal:top.concat(bottom)}}
function getCombinedMax(maxPadding,chartArea,a,b){return Math.max(maxPadding[a],chartArea[a])+Math.max(maxPadding[b],chartArea[b])}
function updateDims(chartArea,params,layout){var box=layout.box;var maxPadding=chartArea.maxPadding;var newWidth,newHeight;if(layout.size){chartArea[layout.pos]-=layout.size}
layout.size=layout.horizontal?box.height:box.width;chartArea[layout.pos]+=layout.size;if(box.getPadding){var boxPadding=box.getPadding();maxPadding.top=Math.max(maxPadding.top,boxPadding.top);maxPadding.left=Math.max(maxPadding.left,boxPadding.left);maxPadding.bottom=Math.max(maxPadding.bottom,boxPadding.bottom);maxPadding.right=Math.max(maxPadding.right,boxPadding.right)}
newWidth=params.outerWidth-getCombinedMax(maxPadding,chartArea,'left','right');newHeight=params.outerHeight-getCombinedMax(maxPadding,chartArea,'top','bottom');if(newWidth!==chartArea.w||newHeight!==chartArea.h){chartArea.w=newWidth;chartArea.h=newHeight;var sizes=layout.horizontal?[newWidth,chartArea.w]:[newHeight,chartArea.h];return sizes[0]!==sizes[1]&&(!isNaN(sizes[0])||!isNaN(sizes[1]))}}
function handleMaxPadding(chartArea){var maxPadding=chartArea.maxPadding;function updatePos(pos){var change=Math.max(maxPadding[pos]-chartArea[pos],0);chartArea[pos]+=change;return change}
chartArea.y+=updatePos('top');chartArea.x+=updatePos('left');updatePos('right');updatePos('bottom')}
function getMargins(horizontal,chartArea){var maxPadding=chartArea.maxPadding;function marginForPositions(positions){var margin={left:0,top:0,right:0,bottom:0};positions.forEach(function(pos){margin[pos]=Math.max(chartArea[pos],maxPadding[pos])});return margin}
return horizontal?marginForPositions(['left','right']):marginForPositions(['top','bottom'])}
function fitBoxes(boxes,chartArea,params){var refitBoxes=[];var i,ilen,layout,box,refit,changed;for(i=0,ilen=boxes.length;i<ilen;++i){layout=boxes[i];box=layout.box;box.update(layout.width||chartArea.w,layout.height||chartArea.h,getMargins(layout.horizontal,chartArea));if(updateDims(chartArea,params,layout)){changed=!0;if(refitBoxes.length){refit=!0}}
if(!box.fullWidth){refitBoxes.push(layout)}}
return refit?fitBoxes(refitBoxes,chartArea,params)||changed:changed}
function placeBoxes(boxes,chartArea,params){var userPadding=params.padding;var x=chartArea.x;var y=chartArea.y;var i,ilen,layout,box;for(i=0,ilen=boxes.length;i<ilen;++i){layout=boxes[i];box=layout.box;if(layout.horizontal){box.left=box.fullWidth?userPadding.left:chartArea.left;box.right=box.fullWidth?params.outerWidth-userPadding.right:chartArea.left+chartArea.w;box.top=y;box.bottom=y+box.height;box.width=box.right-box.left;y=box.bottom}else{box.left=x;box.right=x+box.width;box.top=chartArea.top;box.bottom=chartArea.top+chartArea.h;box.height=box.bottom-box.top;x=box.right}}
chartArea.x=x;chartArea.y=y}
core_defaults._set('global',{layout:{padding:{top:0,right:0,bottom:0,left:0}}});var core_layouts={defaults:{},addBox:function(chart,item){if(!chart.boxes){chart.boxes=[]}
item.fullWidth=item.fullWidth||!1;item.position=item.position||'top';item.weight=item.weight||0;item._layers=item._layers||function(){return[{z:0,draw:function(){item.draw.apply(item,arguments)}}]};chart.boxes.push(item)},removeBox:function(chart,layoutItem){var index=chart.boxes?chart.boxes.indexOf(layoutItem):-1;if(index!==-1){chart.boxes.splice(index,1)}},configure:function(chart,item,options){var props=['fullWidth','position','weight'];var ilen=props.length;var i=0;var prop;for(;i<ilen;++i){prop=props[i];if(options.hasOwnProperty(prop)){item[prop]=options[prop]}}},update:function(chart,width,height){if(!chart){return}
var layoutOptions=chart.options.layout||{};var padding=helpers$1.options.toPadding(layoutOptions.padding);var availableWidth=width-padding.width;var availableHeight=height-padding.height;var boxes=buildLayoutBoxes(chart.boxes);var verticalBoxes=boxes.vertical;var horizontalBoxes=boxes.horizontal;var params=Object.freeze({outerWidth:width,outerHeight:height,padding:padding,availableWidth:availableWidth,vBoxMaxWidth:availableWidth/2/verticalBoxes.length,hBoxMaxHeight:availableHeight/2});var chartArea=extend({maxPadding:extend({},padding),w:availableWidth,h:availableHeight,x:padding.left,y:padding.top},padding);setLayoutDims(verticalBoxes.concat(horizontalBoxes),params);fitBoxes(verticalBoxes,chartArea,params);if(fitBoxes(horizontalBoxes,chartArea,params)){fitBoxes(verticalBoxes,chartArea,params)}
handleMaxPadding(chartArea);placeBoxes(boxes.leftAndTop,chartArea,params);chartArea.x+=chartArea.w;chartArea.y+=chartArea.h;placeBoxes(boxes.rightAndBottom,chartArea,params);chart.chartArea={left:chartArea.left,top:chartArea.top,right:chartArea.left+chartArea.w,bottom:chartArea.top+chartArea.h};helpers$1.each(boxes.chartArea,function(layout){var box=layout.box;extend(box,chart.chartArea);box.update(chartArea.w,chartArea.h)})}};var platform_basic={acquireContext:function(item){if(item&&item.canvas){item=item.canvas}
return item&&item.getContext('2d')||null}};var platform_dom="/*\r\n * DOM element rendering detection\r\n * https://davidwalsh.name/detect-node-insertion\r\n */\r\n@keyframes chartjs-render-animation {\r\n\tfrom { opacity: 0.99; }\r\n\tto { opacity: 1; }\r\n}\r\n\r\n.chartjs-render-monitor {\r\n\tanimation: chartjs-render-animation 0.001s;\r\n}\r\n\r\n/*\r\n * DOM element resizing detection\r\n * https://github.com/marcj/css-element-queries\r\n */\r\n.chartjs-size-monitor,\r\n.chartjs-size-monitor-expand,\r\n.chartjs-size-monitor-shrink {\r\n\tposition: absolute;\r\n\tdirection: ltr;\r\n\tleft: 0;\r\n\ttop: 0;\r\n\tright: 0;\r\n\tbottom: 0;\r\n\toverflow: hidden;\r\n\tpointer-events: none;\r\n\tvisibility: hidden;\r\n\tz-index: -1;\r\n}\r\n\r\n.chartjs-size-monitor-expand > div {\r\n\tposition: absolute;\r\n\twidth: 1000000px;\r\n\theight: 1000000px;\r\n\tleft: 0;\r\n\ttop: 0;\r\n}\r\n\r\n.chartjs-size-monitor-shrink > div {\r\n\tposition: absolute;\r\n\twidth: 200%;\r\n\theight: 200%;\r\n\tleft: 0;\r\n\ttop: 0;\r\n}\r\n";var platform_dom$1=Object.freeze({__proto__:null,'default':platform_dom});var stylesheet=getCjsExportFromNamespace(platform_dom$1);var EXPANDO_KEY='$chartjs';var CSS_PREFIX='chartjs-';var CSS_SIZE_MONITOR=CSS_PREFIX+'size-monitor';var CSS_RENDER_MONITOR=CSS_PREFIX+'render-monitor';var CSS_RENDER_ANIMATION=CSS_PREFIX+'render-animation';var ANIMATION_START_EVENTS=['animationstart','webkitAnimationStart'];var EVENT_TYPES={touchstart:'mousedown',touchmove:'mousemove',touchend:'mouseup',pointerenter:'mouseenter',pointerdown:'mousedown',pointermove:'mousemove',pointerup:'mouseup',pointerleave:'mouseout',pointerout:'mouseout'};function readUsedSize(element,property){var value=helpers$1.getStyle(element,property);var matches=value&&value.match(/^(\d+)(\.\d+)?px$/);return matches?Number(matches[1]):undefined}
function initCanvas(canvas,config){var style=canvas.style;var renderHeight=canvas.getAttribute('height');var renderWidth=canvas.getAttribute('width');canvas[EXPANDO_KEY]={initial:{height:renderHeight,width:renderWidth,style:{display:style.display,height:style.height,width:style.width}}};style.display=style.display||'block';if(renderWidth===null||renderWidth===''){var displayWidth=readUsedSize(canvas,'width');if(displayWidth!==undefined){canvas.width=displayWidth}}
if(renderHeight===null||renderHeight===''){if(canvas.style.height===''){canvas.height=canvas.width/(config.options.aspectRatio||2)}else{var displayHeight=readUsedSize(canvas,'height');if(displayWidth!==undefined){canvas.height=displayHeight}}}
return canvas}
var supportsEventListenerOptions=(function(){var supports=!1;try{var options=Object.defineProperty({},'passive',{get:function(){supports=!0}});window.addEventListener('e',null,options)}catch(e){}
return supports}());var eventListenerOptions=supportsEventListenerOptions?{passive:!0}:!1;function addListener(node,type,listener){node.addEventListener(type,listener,eventListenerOptions)}
function removeListener(node,type,listener){node.removeEventListener(type,listener,eventListenerOptions)}
function createEvent(type,chart,x,y,nativeEvent){return{type:type,chart:chart,native:nativeEvent||null,x:x!==undefined?x:null,y:y!==undefined?y:null,}}
function fromNativeEvent(event,chart){var type=EVENT_TYPES[event.type]||event.type;var pos=helpers$1.getRelativePosition(event,chart);return createEvent(type,chart,pos.x,pos.y,event)}
function throttled(fn,thisArg){var ticking=!1;var args=[];return function(){args=Array.prototype.slice.call(arguments);thisArg=thisArg||this;if(!ticking){ticking=!0;helpers$1.requestAnimFrame.call(window,function(){ticking=!1;fn.apply(thisArg,args)})}}}
function createDiv(cls){var el=document.createElement('div');el.className=cls||'';return el}
function createResizer(handler){var maxSize=1000000;var resizer=createDiv(CSS_SIZE_MONITOR);var expand=createDiv(CSS_SIZE_MONITOR+'-expand');var shrink=createDiv(CSS_SIZE_MONITOR+'-shrink');expand.appendChild(createDiv());shrink.appendChild(createDiv());resizer.appendChild(expand);resizer.appendChild(shrink);resizer._reset=function(){expand.scrollLeft=maxSize;expand.scrollTop=maxSize;shrink.scrollLeft=maxSize;shrink.scrollTop=maxSize};var onScroll=function(){resizer._reset();handler()};addListener(expand,'scroll',onScroll.bind(expand,'expand'));addListener(shrink,'scroll',onScroll.bind(shrink,'shrink'));return resizer}
function watchForRender(node,handler){var expando=node[EXPANDO_KEY]||(node[EXPANDO_KEY]={});var proxy=expando.renderProxy=function(e){if(e.animationName===CSS_RENDER_ANIMATION){handler()}};helpers$1.each(ANIMATION_START_EVENTS,function(type){addListener(node,type,proxy)});expando.reflow=!!node.offsetParent;node.classList.add(CSS_RENDER_MONITOR)}
function unwatchForRender(node){var expando=node[EXPANDO_KEY]||{};var proxy=expando.renderProxy;if(proxy){helpers$1.each(ANIMATION_START_EVENTS,function(type){removeListener(node,type,proxy)});delete expando.renderProxy}
node.classList.remove(CSS_RENDER_MONITOR)}
function addResizeListener(node,listener,chart){var expando=node[EXPANDO_KEY]||(node[EXPANDO_KEY]={});var resizer=expando.resizer=createResizer(throttled(function(){if(expando.resizer){var container=chart.options.maintainAspectRatio&&node.parentNode;var w=container?container.clientWidth:0;listener(createEvent('resize',chart));if(container&&container.clientWidth<w&&chart.canvas){listener(createEvent('resize',chart))}}}));watchForRender(node,function(){if(expando.resizer){var container=node.parentNode;if(container&&container!==resizer.parentNode){container.insertBefore(resizer,container.firstChild)}
resizer._reset()}})}
function removeResizeListener(node){var expando=node[EXPANDO_KEY]||{};var resizer=expando.resizer;delete expando.resizer;unwatchForRender(node);if(resizer&&resizer.parentNode){resizer.parentNode.removeChild(resizer)}}
function injectCSS(rootNode,css){var expando=rootNode[EXPANDO_KEY]||(rootNode[EXPANDO_KEY]={});if(!expando.containsStyles){expando.containsStyles=!0;css='/* Chart.js */\n'+css;var style=document.createElement('style');style.setAttribute('type','text/css');style.appendChild(document.createTextNode(css));rootNode.appendChild(style)}}
var platform_dom$2={disableCSSInjection:!1,_enabled:typeof window!=='undefined'&&typeof document!=='undefined',_ensureLoaded:function(canvas){if(!this.disableCSSInjection){var root=canvas.getRootNode?canvas.getRootNode():document;var targetNode=root.host?root:document.head;injectCSS(targetNode,stylesheet)}},acquireContext:function(item,config){if(typeof item==='string'){item=document.getElementById(item)}else if(item.length){item=item[0]}
if(item&&item.canvas){item=item.canvas}
var context=item&&item.getContext&&item.getContext('2d');if(context&&context.canvas===item){this._ensureLoaded(item);initCanvas(item,config);return context}
return null},releaseContext:function(context){var canvas=context.canvas;if(!canvas[EXPANDO_KEY]){return}
var initial=canvas[EXPANDO_KEY].initial;['height','width'].forEach(function(prop){var value=initial[prop];if(helpers$1.isNullOrUndef(value)){canvas.removeAttribute(prop)}else{canvas.setAttribute(prop,value)}});helpers$1.each(initial.style||{},function(value,key){canvas.style[key]=value});canvas.width=canvas.width;delete canvas[EXPANDO_KEY]},addEventListener:function(chart,type,listener){var canvas=chart.canvas;if(type==='resize'){addResizeListener(canvas,listener,chart);return}
var expando=listener[EXPANDO_KEY]||(listener[EXPANDO_KEY]={});var proxies=expando.proxies||(expando.proxies={});var proxy=proxies[chart.id+'_'+type]=function(event){listener(fromNativeEvent(event,chart))};addListener(canvas,type,proxy)},removeEventListener:function(chart,type,listener){var canvas=chart.canvas;if(type==='resize'){removeResizeListener(canvas);return}
var expando=listener[EXPANDO_KEY]||{};var proxies=expando.proxies||{};var proxy=proxies[chart.id+'_'+type];if(!proxy){return}
removeListener(canvas,type,proxy)}};helpers$1.addEvent=addListener;helpers$1.removeEvent=removeListener;var implementation=platform_dom$2._enabled?platform_dom$2:platform_basic;var platform=helpers$1.extend({initialize:function(){},acquireContext:function(){},releaseContext:function(){},addEventListener:function(){},removeEventListener:function(){}},implementation);core_defaults._set('global',{plugins:{}});var core_plugins={_plugins:[],_cacheId:0,register:function(plugins){var p=this._plugins;([]).concat(plugins).forEach(function(plugin){if(p.indexOf(plugin)===-1){p.push(plugin)}});this._cacheId++},unregister:function(plugins){var p=this._plugins;([]).concat(plugins).forEach(function(plugin){var idx=p.indexOf(plugin);if(idx!==-1){p.splice(idx,1)}});this._cacheId++},clear:function(){this._plugins=[];this._cacheId++},count:function(){return this._plugins.length},getAll:function(){return this._plugins},notify:function(chart,hook,args){var descriptors=this.descriptors(chart);var ilen=descriptors.length;var i,descriptor,plugin,params,method;for(i=0;i<ilen;++i){descriptor=descriptors[i];plugin=descriptor.plugin;method=plugin[hook];if(typeof method==='function'){params=[chart].concat(args||[]);params.push(descriptor.options);if(method.apply(plugin,params)===!1){return!1}}}
return!0},descriptors:function(chart){var cache=chart.$plugins||(chart.$plugins={});if(cache.id===this._cacheId){return cache.descriptors}
var plugins=[];var descriptors=[];var config=(chart&&chart.config)||{};var options=(config.options&&config.options.plugins)||{};this._plugins.concat(config.plugins||[]).forEach(function(plugin){var idx=plugins.indexOf(plugin);if(idx!==-1){return}
var id=plugin.id;var opts=options[id];if(opts===!1){return}
if(opts===!0){opts=helpers$1.clone(core_defaults.global.plugins[id])}
plugins.push(plugin);descriptors.push({plugin:plugin,options:opts||{}})});cache.descriptors=descriptors;cache.id=this._cacheId;return descriptors},_invalidate:function(chart){delete chart.$plugins}};var core_scaleService={constructors:{},defaults:{},registerScaleType:function(type,scaleConstructor,scaleDefaults){this.constructors[type]=scaleConstructor;this.defaults[type]=helpers$1.clone(scaleDefaults)},getScaleConstructor:function(type){return this.constructors.hasOwnProperty(type)?this.constructors[type]:undefined},getScaleDefaults:function(type){return this.defaults.hasOwnProperty(type)?helpers$1.merge(Object.create(null),[core_defaults.scale,this.defaults[type]]):{}},updateScaleDefaults:function(type,additions){var me=this;if(me.defaults.hasOwnProperty(type)){me.defaults[type]=helpers$1.extend(me.defaults[type],additions)}},addScalesToLayout:function(chart){helpers$1.each(chart.scales,function(scale){scale.fullWidth=scale.options.fullWidth;scale.position=scale.options.position;scale.weight=scale.options.weight;core_layouts.addBox(chart,scale)})}};var valueOrDefault$8=helpers$1.valueOrDefault;var getRtlHelper=helpers$1.rtl.getRtlAdapter;core_defaults._set('global',{tooltips:{enabled:!0,custom:null,mode:'nearest',position:'average',intersect:!0,backgroundColor:'rgba(0,0,0,0.8)',titleFontStyle:'bold',titleSpacing:2,titleMarginBottom:6,titleFontColor:'#fff',titleAlign:'left',bodySpacing:2,bodyFontColor:'#fff',bodyAlign:'left',footerFontStyle:'bold',footerSpacing:2,footerMarginTop:6,footerFontColor:'#fff',footerAlign:'left',yPadding:6,xPadding:6,caretPadding:2,caretSize:5,cornerRadius:6,multiKeyBackground:'#fff',displayColors:!0,borderColor:'rgba(0,0,0,0)',borderWidth:0,callbacks:{beforeTitle:helpers$1.noop,title:function(tooltipItems,data){var title='';var labels=data.labels;var labelCount=labels?labels.length:0;if(tooltipItems.length>0){var item=tooltipItems[0];if(item.label){title=item.label}else if(item.xLabel){title=item.xLabel}else if(labelCount>0&&item.index<labelCount){title=labels[item.index]}}
return title},afterTitle:helpers$1.noop,beforeBody:helpers$1.noop,beforeLabel:helpers$1.noop,label:function(tooltipItem,data){var label=data.datasets[tooltipItem.datasetIndex].label||'';if(label){label+=': '}
if(!helpers$1.isNullOrUndef(tooltipItem.value)){label+=tooltipItem.value}else{label+=tooltipItem.yLabel}
return label},labelColor:function(tooltipItem,chart){var meta=chart.getDatasetMeta(tooltipItem.datasetIndex);var activeElement=meta.data[tooltipItem.index];var view=activeElement._view;return{borderColor:view.borderColor,backgroundColor:view.backgroundColor}},labelTextColor:function(){return this._options.bodyFontColor},afterLabel:helpers$1.noop,afterBody:helpers$1.noop,beforeFooter:helpers$1.noop,footer:helpers$1.noop,afterFooter:helpers$1.noop}}});var positioners={average:function(elements){if(!elements.length){return!1}
var i,len;var x=0;var y=0;var count=0;for(i=0,len=elements.length;i<len;++i){var el=elements[i];if(el&&el.hasValue()){var pos=el.tooltipPosition();x+=pos.x;y+=pos.y;++count}}
return{x:x/count,y:y/count}},nearest:function(elements,eventPosition){var x=eventPosition.x;var y=eventPosition.y;var minDistance=Number.POSITIVE_INFINITY;var i,len,nearestElement;for(i=0,len=elements.length;i<len;++i){var el=elements[i];if(el&&el.hasValue()){var center=el.getCenterPoint();var d=helpers$1.distanceBetweenPoints(eventPosition,center);if(d<minDistance){minDistance=d;nearestElement=el}}}
if(nearestElement){var tp=nearestElement.tooltipPosition();x=tp.x;y=tp.y}
return{x:x,y:y}}};function pushOrConcat(base,toPush){if(toPush){if(helpers$1.isArray(toPush)){Array.prototype.push.apply(base,toPush)}else{base.push(toPush)}}
return base}
function splitNewlines(str){if((typeof str==='string'||str instanceof String)&&str.indexOf('\n')>-1){return str.split('\n')}
return str}
function createTooltipItem(element){var xScale=element._xScale;var yScale=element._yScale||element._scale;var index=element._index;var datasetIndex=element._datasetIndex;var controller=element._chart.getDatasetMeta(datasetIndex).controller;var indexScale=controller._getIndexScale();var valueScale=controller._getValueScale();return{xLabel:xScale?xScale.getLabelForIndex(index,datasetIndex):'',yLabel:yScale?yScale.getLabelForIndex(index,datasetIndex):'',label:indexScale?''+indexScale.getLabelForIndex(index,datasetIndex):'',value:valueScale?''+valueScale.getLabelForIndex(index,datasetIndex):'',index:index,datasetIndex:datasetIndex,x:element._model.x,y:element._model.y}}
function getBaseModel(tooltipOpts){var globalDefaults=core_defaults.global;return{xPadding:tooltipOpts.xPadding,yPadding:tooltipOpts.yPadding,xAlign:tooltipOpts.xAlign,yAlign:tooltipOpts.yAlign,rtl:tooltipOpts.rtl,textDirection:tooltipOpts.textDirection,bodyFontColor:tooltipOpts.bodyFontColor,_bodyFontFamily:valueOrDefault$8(tooltipOpts.bodyFontFamily,globalDefaults.defaultFontFamily),_bodyFontStyle:valueOrDefault$8(tooltipOpts.bodyFontStyle,globalDefaults.defaultFontStyle),_bodyAlign:tooltipOpts.bodyAlign,bodyFontSize:valueOrDefault$8(tooltipOpts.bodyFontSize,globalDefaults.defaultFontSize),bodySpacing:tooltipOpts.bodySpacing,titleFontColor:tooltipOpts.titleFontColor,_titleFontFamily:valueOrDefault$8(tooltipOpts.titleFontFamily,globalDefaults.defaultFontFamily),_titleFontStyle:valueOrDefault$8(tooltipOpts.titleFontStyle,globalDefaults.defaultFontStyle),titleFontSize:valueOrDefault$8(tooltipOpts.titleFontSize,globalDefaults.defaultFontSize),_titleAlign:tooltipOpts.titleAlign,titleSpacing:tooltipOpts.titleSpacing,titleMarginBottom:tooltipOpts.titleMarginBottom,footerFontColor:tooltipOpts.footerFontColor,_footerFontFamily:valueOrDefault$8(tooltipOpts.footerFontFamily,globalDefaults.defaultFontFamily),_footerFontStyle:valueOrDefault$8(tooltipOpts.footerFontStyle,globalDefaults.defaultFontStyle),footerFontSize:valueOrDefault$8(tooltipOpts.footerFontSize,globalDefaults.defaultFontSize),_footerAlign:tooltipOpts.footerAlign,footerSpacing:tooltipOpts.footerSpacing,footerMarginTop:tooltipOpts.footerMarginTop,caretSize:tooltipOpts.caretSize,cornerRadius:tooltipOpts.cornerRadius,backgroundColor:tooltipOpts.backgroundColor,opacity:0,legendColorBackground:tooltipOpts.multiKeyBackground,displayColors:tooltipOpts.displayColors,borderColor:tooltipOpts.borderColor,borderWidth:tooltipOpts.borderWidth}}
function getTooltipSize(tooltip,model){var ctx=tooltip._chart.ctx;var height=model.yPadding*2;var width=0;var body=model.body;var combinedBodyLength=body.reduce(function(count,bodyItem){return count+bodyItem.before.length+bodyItem.lines.length+bodyItem.after.length},0);combinedBodyLength+=model.beforeBody.length+model.afterBody.length;var titleLineCount=model.title.length;var footerLineCount=model.footer.length;var titleFontSize=model.titleFontSize;var bodyFontSize=model.bodyFontSize;var footerFontSize=model.footerFontSize;height+=titleLineCount*titleFontSize;height+=titleLineCount?(titleLineCount-1)*model.titleSpacing:0;height+=titleLineCount?model.titleMarginBottom:0;height+=combinedBodyLength*bodyFontSize;height+=combinedBodyLength?(combinedBodyLength-1)*model.bodySpacing:0;height+=footerLineCount?model.footerMarginTop:0;height+=footerLineCount*(footerFontSize);height+=footerLineCount?(footerLineCount-1)*model.footerSpacing:0;var widthPadding=0;var maxLineWidth=function(line){width=Math.max(width,ctx.measureText(line).width+widthPadding)};ctx.font=helpers$1.fontString(titleFontSize,model._titleFontStyle,model._titleFontFamily);helpers$1.each(model.title,maxLineWidth);ctx.font=helpers$1.fontString(bodyFontSize,model._bodyFontStyle,model._bodyFontFamily);helpers$1.each(model.beforeBody.concat(model.afterBody),maxLineWidth);widthPadding=model.displayColors?(bodyFontSize+2):0;helpers$1.each(body,function(bodyItem){helpers$1.each(bodyItem.before,maxLineWidth);helpers$1.each(bodyItem.lines,maxLineWidth);helpers$1.each(bodyItem.after,maxLineWidth)});widthPadding=0;ctx.font=helpers$1.fontString(footerFontSize,model._footerFontStyle,model._footerFontFamily);helpers$1.each(model.footer,maxLineWidth);width+=2*model.xPadding;return{width:width,height:height}}
function determineAlignment(tooltip,size){var model=tooltip._model;var chart=tooltip._chart;var chartArea=tooltip._chart.chartArea;var xAlign='center';var yAlign='center';if(model.y<size.height){yAlign='top'}else if(model.y>(chart.height-size.height)){yAlign='bottom'}
var lf,rf;var olf,orf;var yf;var midX=(chartArea.left+chartArea.right)/2;var midY=(chartArea.top+chartArea.bottom)/2;if(yAlign==='center'){lf=function(x){return x<=midX};rf=function(x){return x>midX}}else{lf=function(x){return x<=(size.width/2)};rf=function(x){return x>=(chart.width-(size.width/2))}}
olf=function(x){return x+size.width+model.caretSize+model.caretPadding>chart.width};orf=function(x){return x-size.width-model.caretSize-model.caretPadding<0};yf=function(y){return y<=midY?'top':'bottom'};if(lf(model.x)){xAlign='left';if(olf(model.x)){xAlign='center';yAlign=yf(model.y)}}else if(rf(model.x)){xAlign='right';if(orf(model.x)){xAlign='center';yAlign=yf(model.y)}}
var opts=tooltip._options;return{xAlign:opts.xAlign?opts.xAlign:xAlign,yAlign:opts.yAlign?opts.yAlign:yAlign}}
function getBackgroundPoint(vm,size,alignment,chart){var x=vm.x;var y=vm.y;var caretSize=vm.caretSize;var caretPadding=vm.caretPadding;var cornerRadius=vm.cornerRadius;var xAlign=alignment.xAlign;var yAlign=alignment.yAlign;var paddingAndSize=caretSize+caretPadding;var radiusAndPadding=cornerRadius+caretPadding;if(xAlign==='right'){x-=size.width}else if(xAlign==='center'){x-=(size.width/2);if(x+size.width>chart.width){x=chart.width-size.width}
if(x<0){x=0}}
if(yAlign==='top'){y+=paddingAndSize}else if(yAlign==='bottom'){y-=size.height+paddingAndSize}else{y-=(size.height/2)}
if(yAlign==='center'){if(xAlign==='left'){x+=paddingAndSize}else if(xAlign==='right'){x-=paddingAndSize}}else if(xAlign==='left'){x-=radiusAndPadding}else if(xAlign==='right'){x+=radiusAndPadding}
return{x:x,y:y}}
function getAlignedX(vm,align){return align==='center'?vm.x+vm.width/2:align==='right'?vm.x+vm.width-vm.xPadding:vm.x+vm.xPadding}
function getBeforeAfterBodyLines(callback){return pushOrConcat([],splitNewlines(callback))}
var exports$4=core_element.extend({initialize:function(){this._model=getBaseModel(this._options);this._lastActive=[]},getTitle:function(){var me=this;var opts=me._options;var callbacks=opts.callbacks;var beforeTitle=callbacks.beforeTitle.apply(me,arguments);var title=callbacks.title.apply(me,arguments);var afterTitle=callbacks.afterTitle.apply(me,arguments);var lines=[];lines=pushOrConcat(lines,splitNewlines(beforeTitle));lines=pushOrConcat(lines,splitNewlines(title));lines=pushOrConcat(lines,splitNewlines(afterTitle));return lines},getBeforeBody:function(){return getBeforeAfterBodyLines(this._options.callbacks.beforeBody.apply(this,arguments))},getBody:function(tooltipItems,data){var me=this;var callbacks=me._options.callbacks;var bodyItems=[];helpers$1.each(tooltipItems,function(tooltipItem){var bodyItem={before:[],lines:[],after:[]};pushOrConcat(bodyItem.before,splitNewlines(callbacks.beforeLabel.call(me,tooltipItem,data)));pushOrConcat(bodyItem.lines,callbacks.label.call(me,tooltipItem,data));pushOrConcat(bodyItem.after,splitNewlines(callbacks.afterLabel.call(me,tooltipItem,data)));bodyItems.push(bodyItem)});return bodyItems},getAfterBody:function(){return getBeforeAfterBodyLines(this._options.callbacks.afterBody.apply(this,arguments))},getFooter:function(){var me=this;var callbacks=me._options.callbacks;var beforeFooter=callbacks.beforeFooter.apply(me,arguments);var footer=callbacks.footer.apply(me,arguments);var afterFooter=callbacks.afterFooter.apply(me,arguments);var lines=[];lines=pushOrConcat(lines,splitNewlines(beforeFooter));lines=pushOrConcat(lines,splitNewlines(footer));lines=pushOrConcat(lines,splitNewlines(afterFooter));return lines},update:function(changed){var me=this;var opts=me._options;var existingModel=me._model;var model=me._model=getBaseModel(opts);var active=me._active;var data=me._data;var alignment={xAlign:existingModel.xAlign,yAlign:existingModel.yAlign};var backgroundPoint={x:existingModel.x,y:existingModel.y};var tooltipSize={width:existingModel.width,height:existingModel.height};var tooltipPosition={x:existingModel.caretX,y:existingModel.caretY};var i,len;if(active.length){model.opacity=1;var labelColors=[];var labelTextColors=[];tooltipPosition=positioners[opts.position].call(me,active,me._eventPosition);var tooltipItems=[];for(i=0,len=active.length;i<len;++i){tooltipItems.push(createTooltipItem(active[i]))}
if(opts.filter){tooltipItems=tooltipItems.filter(function(a){return opts.filter(a,data)})}
if(opts.itemSort){tooltipItems=tooltipItems.sort(function(a,b){return opts.itemSort(a,b,data)})}
helpers$1.each(tooltipItems,function(tooltipItem){labelColors.push(opts.callbacks.labelColor.call(me,tooltipItem,me._chart));labelTextColors.push(opts.callbacks.labelTextColor.call(me,tooltipItem,me._chart))});model.title=me.getTitle(tooltipItems,data);model.beforeBody=me.getBeforeBody(tooltipItems,data);model.body=me.getBody(tooltipItems,data);model.afterBody=me.getAfterBody(tooltipItems,data);model.footer=me.getFooter(tooltipItems,data);model.x=tooltipPosition.x;model.y=tooltipPosition.y;model.caretPadding=opts.caretPadding;model.labelColors=labelColors;model.labelTextColors=labelTextColors;model.dataPoints=tooltipItems;tooltipSize=getTooltipSize(this,model);alignment=determineAlignment(this,tooltipSize);backgroundPoint=getBackgroundPoint(model,tooltipSize,alignment,me._chart)}else{model.opacity=0}
model.xAlign=alignment.xAlign;model.yAlign=alignment.yAlign;model.x=backgroundPoint.x;model.y=backgroundPoint.y;model.width=tooltipSize.width;model.height=tooltipSize.height;model.caretX=tooltipPosition.x;model.caretY=tooltipPosition.y;me._model=model;if(changed&&opts.custom){opts.custom.call(me,model)}
return me},drawCaret:function(tooltipPoint,size){var ctx=this._chart.ctx;var vm=this._view;var caretPosition=this.getCaretPosition(tooltipPoint,size,vm);ctx.lineTo(caretPosition.x1,caretPosition.y1);ctx.lineTo(caretPosition.x2,caretPosition.y2);ctx.lineTo(caretPosition.x3,caretPosition.y3)},getCaretPosition:function(tooltipPoint,size,vm){var x1,x2,x3,y1,y2,y3;var caretSize=vm.caretSize;var cornerRadius=vm.cornerRadius;var xAlign=vm.xAlign;var yAlign=vm.yAlign;var ptX=tooltipPoint.x;var ptY=tooltipPoint.y;var width=size.width;var height=size.height;if(yAlign==='center'){y2=ptY+(height/2);if(xAlign==='left'){x1=ptX;x2=x1-caretSize;x3=x1;y1=y2+caretSize;y3=y2-caretSize}else{x1=ptX+width;x2=x1+caretSize;x3=x1;y1=y2-caretSize;y3=y2+caretSize}}else{if(xAlign==='left'){x2=ptX+cornerRadius+(caretSize);x1=x2-caretSize;x3=x2+caretSize}else if(xAlign==='right'){x2=ptX+width-cornerRadius-caretSize;x1=x2-caretSize;x3=x2+caretSize}else{x2=vm.caretX;x1=x2-caretSize;x3=x2+caretSize}
if(yAlign==='top'){y1=ptY;y2=y1-caretSize;y3=y1}else{y1=ptY+height;y2=y1+caretSize;y3=y1;var tmp=x3;x3=x1;x1=tmp}}
return{x1:x1,x2:x2,x3:x3,y1:y1,y2:y2,y3:y3}},drawTitle:function(pt,vm,ctx){var title=vm.title;var length=title.length;var titleFontSize,titleSpacing,i;if(length){var rtlHelper=getRtlHelper(vm.rtl,vm.x,vm.width);pt.x=getAlignedX(vm,vm._titleAlign);ctx.textAlign=rtlHelper.textAlign(vm._titleAlign);ctx.textBaseline='middle';titleFontSize=vm.titleFontSize;titleSpacing=vm.titleSpacing;ctx.fillStyle=vm.titleFontColor;ctx.font=helpers$1.fontString(titleFontSize,vm._titleFontStyle,vm._titleFontFamily);for(i=0;i<length;++i){ctx.fillText(title[i],rtlHelper.x(pt.x),pt.y+titleFontSize/2);pt.y+=titleFontSize+titleSpacing;if(i+1===length){pt.y+=vm.titleMarginBottom-titleSpacing}}}},drawBody:function(pt,vm,ctx){var bodyFontSize=vm.bodyFontSize;var bodySpacing=vm.bodySpacing;var bodyAlign=vm._bodyAlign;var body=vm.body;var drawColorBoxes=vm.displayColors;var xLinePadding=0;var colorX=drawColorBoxes?getAlignedX(vm,'left'):0;var rtlHelper=getRtlHelper(vm.rtl,vm.x,vm.width);var fillLineOfText=function(line){ctx.fillText(line,rtlHelper.x(pt.x+xLinePadding),pt.y+bodyFontSize/2);pt.y+=bodyFontSize+bodySpacing};var bodyItem,textColor,labelColors,lines,i,j,ilen,jlen;var bodyAlignForCalculation=rtlHelper.textAlign(bodyAlign);ctx.textAlign=bodyAlign;ctx.textBaseline='middle';ctx.font=helpers$1.fontString(bodyFontSize,vm._bodyFontStyle,vm._bodyFontFamily);pt.x=getAlignedX(vm,bodyAlignForCalculation);ctx.fillStyle=vm.bodyFontColor;helpers$1.each(vm.beforeBody,fillLineOfText);xLinePadding=drawColorBoxes&&bodyAlignForCalculation!=='right'?bodyAlign==='center'?(bodyFontSize/2+1):(bodyFontSize+2):0;for(i=0,ilen=body.length;i<ilen;++i){bodyItem=body[i];textColor=vm.labelTextColors[i];labelColors=vm.labelColors[i];ctx.fillStyle=textColor;helpers$1.each(bodyItem.before,fillLineOfText);lines=bodyItem.lines;for(j=0,jlen=lines.length;j<jlen;++j){if(drawColorBoxes){var rtlColorX=rtlHelper.x(colorX);ctx.fillStyle=vm.legendColorBackground;ctx.fillRect(rtlHelper.leftForLtr(rtlColorX,bodyFontSize),pt.y,bodyFontSize,bodyFontSize);ctx.lineWidth=1;ctx.strokeStyle=labelColors.borderColor;ctx.strokeRect(rtlHelper.leftForLtr(rtlColorX,bodyFontSize),pt.y,bodyFontSize,bodyFontSize);ctx.fillStyle=labelColors.backgroundColor;ctx.fillRect(rtlHelper.leftForLtr(rtlHelper.xPlus(rtlColorX,1),bodyFontSize-2),pt.y+1,bodyFontSize-2,bodyFontSize-2);ctx.fillStyle=textColor}
fillLineOfText(lines[j])}
helpers$1.each(bodyItem.after,fillLineOfText)}
xLinePadding=0;helpers$1.each(vm.afterBody,fillLineOfText);pt.y-=bodySpacing},drawFooter:function(pt,vm,ctx){var footer=vm.footer;var length=footer.length;var footerFontSize,i;if(length){var rtlHelper=getRtlHelper(vm.rtl,vm.x,vm.width);pt.x=getAlignedX(vm,vm._footerAlign);pt.y+=vm.footerMarginTop;ctx.textAlign=rtlHelper.textAlign(vm._footerAlign);ctx.textBaseline='middle';footerFontSize=vm.footerFontSize;ctx.fillStyle=vm.footerFontColor;ctx.font=helpers$1.fontString(footerFontSize,vm._footerFontStyle,vm._footerFontFamily);for(i=0;i<length;++i){ctx.fillText(footer[i],rtlHelper.x(pt.x),pt.y+footerFontSize/2);pt.y+=footerFontSize+vm.footerSpacing}}},drawBackground:function(pt,vm,ctx,tooltipSize){ctx.fillStyle=vm.backgroundColor;ctx.strokeStyle=vm.borderColor;ctx.lineWidth=vm.borderWidth;var xAlign=vm.xAlign;var yAlign=vm.yAlign;var x=pt.x;var y=pt.y;var width=tooltipSize.width;var height=tooltipSize.height;var radius=vm.cornerRadius;ctx.beginPath();ctx.moveTo(x+radius,y);if(yAlign==='top'){this.drawCaret(pt,tooltipSize)}
ctx.lineTo(x+width-radius,y);ctx.quadraticCurveTo(x+width,y,x+width,y+radius);if(yAlign==='center'&&xAlign==='right'){this.drawCaret(pt,tooltipSize)}
ctx.lineTo(x+width,y+height-radius);ctx.quadraticCurveTo(x+width,y+height,x+width-radius,y+height);if(yAlign==='bottom'){this.drawCaret(pt,tooltipSize)}
ctx.lineTo(x+radius,y+height);ctx.quadraticCurveTo(x,y+height,x,y+height-radius);if(yAlign==='center'&&xAlign==='left'){this.drawCaret(pt,tooltipSize)}
ctx.lineTo(x,y+radius);ctx.quadraticCurveTo(x,y,x+radius,y);ctx.closePath();ctx.fill();if(vm.borderWidth>0){ctx.stroke()}},draw:function(){var ctx=this._chart.ctx;var vm=this._view;if(vm.opacity===0){return}
var tooltipSize={width:vm.width,height:vm.height};var pt={x:vm.x,y:vm.y};var opacity=Math.abs(vm.opacity<1e-3)?0:vm.opacity;var hasTooltipContent=vm.title.length||vm.beforeBody.length||vm.body.length||vm.afterBody.length||vm.footer.length;if(this._options.enabled&&hasTooltipContent){ctx.save();ctx.globalAlpha=opacity;this.drawBackground(pt,vm,ctx,tooltipSize);pt.y+=vm.yPadding;helpers$1.rtl.overrideTextDirection(ctx,vm.textDirection);this.drawTitle(pt,vm,ctx);this.drawBody(pt,vm,ctx);this.drawFooter(pt,vm,ctx);helpers$1.rtl.restoreTextDirection(ctx,vm.textDirection);ctx.restore()}},handleEvent:function(e){var me=this;var options=me._options;var changed=!1;me._lastActive=me._lastActive||[];if(e.type==='mouseout'){me._active=[]}else{me._active=me._chart.getElementsAtEventForMode(e,options.mode,options);if(options.reverse){me._active.reverse()}}
changed=!helpers$1.arrayEquals(me._active,me._lastActive);if(changed){me._lastActive=me._active;if(options.enabled||options.custom){me._eventPosition={x:e.x,y:e.y};me.update(!0);me.pivot()}}
return changed}});var positioners_1=positioners;var core_tooltip=exports$4;core_tooltip.positioners=positioners_1;var valueOrDefault$9=helpers$1.valueOrDefault;core_defaults._set('global',{elements:{},events:['mousemove','mouseout','click','touchstart','touchmove'],hover:{onHover:null,mode:'nearest',intersect:!0,animationDuration:400},onClick:null,maintainAspectRatio:!0,responsive:!0,responsiveAnimationDuration:0});function mergeScaleConfig(){return helpers$1.merge(Object.create(null),[].slice.call(arguments),{merger:function(key,target,source,options){if(key==='xAxes'||key==='yAxes'){var slen=source[key].length;var i,type,scale;if(!target[key]){target[key]=[]}
for(i=0;i<slen;++i){scale=source[key][i];type=valueOrDefault$9(scale.type,key==='xAxes'?'category':'linear');if(i>=target[key].length){target[key].push({})}
if(!target[key][i].type||(scale.type&&scale.type!==target[key][i].type)){helpers$1.merge(target[key][i],[core_scaleService.getScaleDefaults(type),scale])}else{helpers$1.merge(target[key][i],scale)}}}else{helpers$1._merger(key,target,source,options)}}})}
function mergeConfig(){return helpers$1.merge(Object.create(null),[].slice.call(arguments),{merger:function(key,target,source,options){var tval=target[key]||Object.create(null);var sval=source[key];if(key==='scales'){target[key]=mergeScaleConfig(tval,sval)}else if(key==='scale'){target[key]=helpers$1.merge(tval,[core_scaleService.getScaleDefaults(sval.type),sval])}else{helpers$1._merger(key,target,source,options)}}})}
function initConfig(config){config=config||Object.create(null);var data=config.data=config.data||{};data.datasets=data.datasets||[];data.labels=data.labels||[];config.options=mergeConfig(core_defaults.global,core_defaults[config.type],config.options||{});return config}
function updateConfig(chart){var newOptions=chart.options;helpers$1.each(chart.scales,function(scale){core_layouts.removeBox(chart,scale)});newOptions=mergeConfig(core_defaults.global,core_defaults[chart.config.type],newOptions);chart.options=chart.config.options=newOptions;chart.ensureScalesHaveIDs();chart.buildOrUpdateScales();chart.tooltip._options=newOptions.tooltips;chart.tooltip.initialize()}
function nextAvailableScaleId(axesOpts,prefix,index){var id;var hasId=function(obj){return obj.id===id};do{id=prefix+index++}while(helpers$1.findIndex(axesOpts,hasId)>=0);return id}
function positionIsHorizontal(position){return position==='top'||position==='bottom'}
function compare2Level(l1,l2){return function(a,b){return a[l1]===b[l1]?a[l2]-b[l2]:a[l1]-b[l1]}}
var Chart=function(item,config){this.construct(item,config);return this};helpers$1.extend(Chart.prototype,{construct:function(item,config){var me=this;config=initConfig(config);var context=platform.acquireContext(item,config);var canvas=context&&context.canvas;var height=canvas&&canvas.height;var width=canvas&&canvas.width;me.id=helpers$1.uid();me.ctx=context;me.canvas=canvas;me.config=config;me.width=width;me.height=height;me.aspectRatio=height?width/height:null;me.options=config.options;me._bufferedRender=!1;me._layers=[];me.chart=me;me.controller=me;Chart.instances[me.id]=me;Object.defineProperty(me,'data',{get:function(){return me.config.data},set:function(value){me.config.data=value}});if(!context||!canvas){console.error("Failed to create chart: can't acquire context from the given item");return}
me.initialize();me.update()},initialize:function(){var me=this;core_plugins.notify(me,'beforeInit');helpers$1.retinaScale(me,me.options.devicePixelRatio);me.bindEvents();if(me.options.responsive){me.resize(!0)}
me.initToolTip();core_plugins.notify(me,'afterInit');return me},clear:function(){helpers$1.canvas.clear(this);return this},stop:function(){core_animations.cancelAnimation(this);return this},resize:function(silent){var me=this;var options=me.options;var canvas=me.canvas;var aspectRatio=(options.maintainAspectRatio&&me.aspectRatio)||null;var newWidth=Math.max(0,Math.floor(helpers$1.getMaximumWidth(canvas)));var newHeight=Math.max(0,Math.floor(aspectRatio?newWidth/aspectRatio:helpers$1.getMaximumHeight(canvas)));if(me.width===newWidth&&me.height===newHeight){return}
canvas.width=me.width=newWidth;canvas.height=me.height=newHeight;canvas.style.width=newWidth+'px';canvas.style.height=newHeight+'px';helpers$1.retinaScale(me,options.devicePixelRatio);if(!silent){var newSize={width:newWidth,height:newHeight};core_plugins.notify(me,'resize',[newSize]);if(options.onResize){options.onResize(me,newSize)}
me.stop();me.update({duration:options.responsiveAnimationDuration})}},ensureScalesHaveIDs:function(){var options=this.options;var scalesOptions=options.scales||{};var scaleOptions=options.scale;helpers$1.each(scalesOptions.xAxes,function(xAxisOptions,index){if(!xAxisOptions.id){xAxisOptions.id=nextAvailableScaleId(scalesOptions.xAxes,'x-axis-',index)}});helpers$1.each(scalesOptions.yAxes,function(yAxisOptions,index){if(!yAxisOptions.id){yAxisOptions.id=nextAvailableScaleId(scalesOptions.yAxes,'y-axis-',index)}});if(scaleOptions){scaleOptions.id=scaleOptions.id||'scale'}},buildOrUpdateScales:function(){var me=this;var options=me.options;var scales=me.scales||{};var items=[];var updated=Object.keys(scales).reduce(function(obj,id){obj[id]=!1;return obj},{});if(options.scales){items=items.concat((options.scales.xAxes||[]).map(function(xAxisOptions){return{options:xAxisOptions,dtype:'category',dposition:'bottom'}}),(options.scales.yAxes||[]).map(function(yAxisOptions){return{options:yAxisOptions,dtype:'linear',dposition:'left'}}))}
if(options.scale){items.push({options:options.scale,dtype:'radialLinear',isDefault:!0,dposition:'chartArea'})}
helpers$1.each(items,function(item){var scaleOptions=item.options;var id=scaleOptions.id;var scaleType=valueOrDefault$9(scaleOptions.type,item.dtype);if(positionIsHorizontal(scaleOptions.position)!==positionIsHorizontal(item.dposition)){scaleOptions.position=item.dposition}
updated[id]=!0;var scale=null;if(id in scales&&scales[id].type===scaleType){scale=scales[id];scale.options=scaleOptions;scale.ctx=me.ctx;scale.chart=me}else{var scaleClass=core_scaleService.getScaleConstructor(scaleType);if(!scaleClass){return}
scale=new scaleClass({id:id,type:scaleType,options:scaleOptions,ctx:me.ctx,chart:me});scales[scale.id]=scale}
scale.mergeTicksOptions();if(item.isDefault){me.scale=scale}});helpers$1.each(updated,function(hasUpdated,id){if(!hasUpdated){delete scales[id]}});me.scales=scales;core_scaleService.addScalesToLayout(this)},buildOrUpdateControllers:function(){var me=this;var newControllers=[];var datasets=me.data.datasets;var i,ilen;for(i=0,ilen=datasets.length;i<ilen;i++){var dataset=datasets[i];var meta=me.getDatasetMeta(i);var type=dataset.type||me.config.type;if(meta.type&&meta.type!==type){me.destroyDatasetMeta(i);meta=me.getDatasetMeta(i)}
meta.type=type;meta.order=dataset.order||0;meta.index=i;if(meta.controller){meta.controller.updateIndex(i);meta.controller.linkScales()}else{var ControllerClass=controllers[meta.type];if(ControllerClass===undefined){throw new Error('"'+meta.type+'" is not a chart type.')}
meta.controller=new ControllerClass(me,i);newControllers.push(meta.controller)}}
return newControllers},resetElements:function(){var me=this;helpers$1.each(me.data.datasets,function(dataset,datasetIndex){me.getDatasetMeta(datasetIndex).controller.reset()},me)},reset:function(){this.resetElements();this.tooltip.initialize()},update:function(config){var me=this;var i,ilen;if(!config||typeof config!=='object'){config={duration:config,lazy:arguments[1]}}
updateConfig(me);core_plugins._invalidate(me);if(core_plugins.notify(me,'beforeUpdate')===!1){return}
me.tooltip._data=me.data;var newControllers=me.buildOrUpdateControllers();for(i=0,ilen=me.data.datasets.length;i<ilen;i++){me.getDatasetMeta(i).controller.buildOrUpdateElements()}
me.updateLayout();if(me.options.animation&&me.options.animation.duration){helpers$1.each(newControllers,function(controller){controller.reset()})}
me.updateDatasets();me.tooltip.initialize();me.lastActive=[];core_plugins.notify(me,'afterUpdate');me._layers.sort(compare2Level('z','_idx'));if(me._bufferedRender){me._bufferedRequest={duration:config.duration,easing:config.easing,lazy:config.lazy}}else{me.render(config)}},updateLayout:function(){var me=this;if(core_plugins.notify(me,'beforeLayout')===!1){return}
core_layouts.update(this,this.width,this.height);me._layers=[];helpers$1.each(me.boxes,function(box){if(box._configure){box._configure()}
me._layers.push.apply(me._layers,box._layers())},me);me._layers.forEach(function(item,index){item._idx=index});core_plugins.notify(me,'afterScaleUpdate');core_plugins.notify(me,'afterLayout')},updateDatasets:function(){var me=this;if(core_plugins.notify(me,'beforeDatasetsUpdate')===!1){return}
for(var i=0,ilen=me.data.datasets.length;i<ilen;++i){me.updateDataset(i)}
core_plugins.notify(me,'afterDatasetsUpdate')},updateDataset:function(index){var me=this;var meta=me.getDatasetMeta(index);var args={meta:meta,index:index};if(core_plugins.notify(me,'beforeDatasetUpdate',[args])===!1){return}
meta.controller._update();core_plugins.notify(me,'afterDatasetUpdate',[args])},render:function(config){var me=this;if(!config||typeof config!=='object'){config={duration:config,lazy:arguments[1]}}
var animationOptions=me.options.animation;var duration=valueOrDefault$9(config.duration,animationOptions&&animationOptions.duration);var lazy=config.lazy;if(core_plugins.notify(me,'beforeRender')===!1){return}
var onComplete=function(animation){core_plugins.notify(me,'afterRender');helpers$1.callback(animationOptions&&animationOptions.onComplete,[animation],me)};if(animationOptions&&duration){var animation=new core_animation({numSteps:duration/16.66,easing:config.easing||animationOptions.easing,render:function(chart,animationObject){var easingFunction=helpers$1.easing.effects[animationObject.easing];var currentStep=animationObject.currentStep;var stepDecimal=currentStep/animationObject.numSteps;chart.draw(easingFunction(stepDecimal),stepDecimal,currentStep)},onAnimationProgress:animationOptions.onProgress,onAnimationComplete:onComplete});core_animations.addAnimation(me,animation,duration,lazy)}else{me.draw();onComplete(new core_animation({numSteps:0,chart:me}))}
return me},draw:function(easingValue){var me=this;var i,layers;me.clear();if(helpers$1.isNullOrUndef(easingValue)){easingValue=1}
me.transition(easingValue);if(me.width<=0||me.height<=0){return}
if(core_plugins.notify(me,'beforeDraw',[easingValue])===!1){return}
layers=me._layers;for(i=0;i<layers.length&&layers[i].z<=0;++i){layers[i].draw(me.chartArea)}
me.drawDatasets(easingValue);for(;i<layers.length;++i){layers[i].draw(me.chartArea)}
me._drawTooltip(easingValue);core_plugins.notify(me,'afterDraw',[easingValue])},transition:function(easingValue){var me=this;for(var i=0,ilen=(me.data.datasets||[]).length;i<ilen;++i){if(me.isDatasetVisible(i)){me.getDatasetMeta(i).controller.transition(easingValue)}}
me.tooltip.transition(easingValue)},_getSortedDatasetMetas:function(filterVisible){var me=this;var datasets=me.data.datasets||[];var result=[];var i,ilen;for(i=0,ilen=datasets.length;i<ilen;++i){if(!filterVisible||me.isDatasetVisible(i)){result.push(me.getDatasetMeta(i))}}
result.sort(compare2Level('order','index'));return result},_getSortedVisibleDatasetMetas:function(){return this._getSortedDatasetMetas(!0)},drawDatasets:function(easingValue){var me=this;var metasets,i;if(core_plugins.notify(me,'beforeDatasetsDraw',[easingValue])===!1){return}
metasets=me._getSortedVisibleDatasetMetas();for(i=metasets.length-1;i>=0;--i){me.drawDataset(metasets[i],easingValue)}
core_plugins.notify(me,'afterDatasetsDraw',[easingValue])},drawDataset:function(meta,easingValue){var me=this;var args={meta:meta,index:meta.index,easingValue:easingValue};if(core_plugins.notify(me,'beforeDatasetDraw',[args])===!1){return}
meta.controller.draw(easingValue);core_plugins.notify(me,'afterDatasetDraw',[args])},_drawTooltip:function(easingValue){var me=this;var tooltip=me.tooltip;var args={tooltip:tooltip,easingValue:easingValue};if(core_plugins.notify(me,'beforeTooltipDraw',[args])===!1){return}
tooltip.draw();core_plugins.notify(me,'afterTooltipDraw',[args])},getElementAtEvent:function(e){return core_interaction.modes.single(this,e)},getElementsAtEvent:function(e){return core_interaction.modes.label(this,e,{intersect:!0})},getElementsAtXAxis:function(e){return core_interaction.modes['x-axis'](this,e,{intersect:!0})},getElementsAtEventForMode:function(e,mode,options){var method=core_interaction.modes[mode];if(typeof method==='function'){return method(this,e,options)}
return[]},getDatasetAtEvent:function(e){return core_interaction.modes.dataset(this,e,{intersect:!0})},getDatasetMeta:function(datasetIndex){var me=this;var dataset=me.data.datasets[datasetIndex];if(!dataset._meta){dataset._meta={}}
var meta=dataset._meta[me.id];if(!meta){meta=dataset._meta[me.id]={type:null,data:[],dataset:null,controller:null,hidden:null,xAxisID:null,yAxisID:null,order:dataset.order||0,index:datasetIndex}}
return meta},getVisibleDatasetCount:function(){var count=0;for(var i=0,ilen=this.data.datasets.length;i<ilen;++i){if(this.isDatasetVisible(i)){count++}}
return count},isDatasetVisible:function(datasetIndex){var meta=this.getDatasetMeta(datasetIndex);return typeof meta.hidden==='boolean'?!meta.hidden:!this.data.datasets[datasetIndex].hidden},generateLegend:function(){return this.options.legendCallback(this)},destroyDatasetMeta:function(datasetIndex){var id=this.id;var dataset=this.data.datasets[datasetIndex];var meta=dataset._meta&&dataset._meta[id];if(meta){meta.controller.destroy();delete dataset._meta[id]}},destroy:function(){var me=this;var canvas=me.canvas;var i,ilen;me.stop();for(i=0,ilen=me.data.datasets.length;i<ilen;++i){me.destroyDatasetMeta(i)}
if(canvas){me.unbindEvents();helpers$1.canvas.clear(me);platform.releaseContext(me.ctx);me.canvas=null;me.ctx=null}
core_plugins.notify(me,'destroy');delete Chart.instances[me.id]},toBase64Image:function(){return this.canvas.toDataURL.apply(this.canvas,arguments)},initToolTip:function(){var me=this;me.tooltip=new core_tooltip({_chart:me,_chartInstance:me,_data:me.data,_options:me.options.tooltips},me)},bindEvents:function(){var me=this;var listeners=me._listeners={};var listener=function(){me.eventHandler.apply(me,arguments)};helpers$1.each(me.options.events,function(type){platform.addEventListener(me,type,listener);listeners[type]=listener});if(me.options.responsive){listener=function(){me.resize()};platform.addEventListener(me,'resize',listener);listeners.resize=listener}},unbindEvents:function(){var me=this;var listeners=me._listeners;if(!listeners){return}
delete me._listeners;helpers$1.each(listeners,function(listener,type){platform.removeEventListener(me,type,listener)})},updateHoverStyle:function(elements,mode,enabled){var prefix=enabled?'set':'remove';var element,i,ilen;for(i=0,ilen=elements.length;i<ilen;++i){element=elements[i];if(element){this.getDatasetMeta(element._datasetIndex).controller[prefix+'HoverStyle'](element)}}
if(mode==='dataset'){this.getDatasetMeta(elements[0]._datasetIndex).controller['_'+prefix+'DatasetHoverStyle']()}},eventHandler:function(e){var me=this;var tooltip=me.tooltip;if(core_plugins.notify(me,'beforeEvent',[e])===!1){return}
me._bufferedRender=!0;me._bufferedRequest=null;var changed=me.handleEvent(e);if(tooltip){changed=tooltip._start?tooltip.handleEvent(e):changed|tooltip.handleEvent(e)}
core_plugins.notify(me,'afterEvent',[e]);var bufferedRequest=me._bufferedRequest;if(bufferedRequest){me.render(bufferedRequest)}else if(changed&&!me.animating){me.stop();me.render({duration:me.options.hover.animationDuration,lazy:!0})}
me._bufferedRender=!1;me._bufferedRequest=null;return me},handleEvent:function(e){var me=this;var options=me.options||{};var hoverOptions=options.hover;var changed=!1;me.lastActive=me.lastActive||[];if(e.type==='mouseout'){me.active=[]}else{me.active=me.getElementsAtEventForMode(e,hoverOptions.mode,hoverOptions)}
helpers$1.callback(options.onHover||options.hover.onHover,[e.native,me.active],me);if(e.type==='mouseup'||e.type==='click'){if(options.onClick){options.onClick.call(me,e.native,me.active)}}
if(me.lastActive.length){me.updateHoverStyle(me.lastActive,hoverOptions.mode,!1)}
if(me.active.length&&hoverOptions.mode){me.updateHoverStyle(me.active,hoverOptions.mode,!0)}
changed=!helpers$1.arrayEquals(me.active,me.lastActive);me.lastActive=me.active;return changed}});Chart.instances={};var core_controller=Chart;Chart.Controller=Chart;Chart.types={};helpers$1.configMerge=mergeConfig;helpers$1.scaleMerge=mergeScaleConfig;var core_helpers=function(){helpers$1.where=function(collection,filterCallback){if(helpers$1.isArray(collection)&&Array.prototype.filter){return collection.filter(filterCallback)}
var filtered=[];helpers$1.each(collection,function(item){if(filterCallback(item)){filtered.push(item)}});return filtered};helpers$1.findIndex=Array.prototype.findIndex?function(array,callback,scope){return array.findIndex(callback,scope)}:function(array,callback,scope){scope=scope===undefined?array:scope;for(var i=0,ilen=array.length;i<ilen;++i){if(callback.call(scope,array[i],i,array)){return i}}
return-1};helpers$1.findNextWhere=function(arrayToSearch,filterCallback,startIndex){if(helpers$1.isNullOrUndef(startIndex)){startIndex=-1}
for(var i=startIndex+1;i<arrayToSearch.length;i++){var currentItem=arrayToSearch[i];if(filterCallback(currentItem)){return currentItem}}};helpers$1.findPreviousWhere=function(arrayToSearch,filterCallback,startIndex){if(helpers$1.isNullOrUndef(startIndex)){startIndex=arrayToSearch.length}
for(var i=startIndex-1;i>=0;i--){var currentItem=arrayToSearch[i];if(filterCallback(currentItem)){return currentItem}}};helpers$1.isNumber=function(n){return!isNaN(parseFloat(n))&&isFinite(n)};helpers$1.almostEquals=function(x,y,epsilon){return Math.abs(x-y)<epsilon};helpers$1.almostWhole=function(x,epsilon){var rounded=Math.round(x);return((rounded-epsilon)<=x)&&((rounded+epsilon)>=x)};helpers$1.max=function(array){return array.reduce(function(max,value){if(!isNaN(value)){return Math.max(max,value)}
return max},Number.NEGATIVE_INFINITY)};helpers$1.min=function(array){return array.reduce(function(min,value){if(!isNaN(value)){return Math.min(min,value)}
return min},Number.POSITIVE_INFINITY)};helpers$1.sign=Math.sign?function(x){return Math.sign(x)}:function(x){x=+x;if(x===0||isNaN(x)){return x}
return x>0?1:-1};helpers$1.toRadians=function(degrees){return degrees*(Math.PI/180)};helpers$1.toDegrees=function(radians){return radians*(180/Math.PI)};helpers$1._decimalPlaces=function(x){if(!helpers$1.isFinite(x)){return}
var e=1;var p=0;while(Math.round(x*e)/e!==x){e*=10;p++}
return p};helpers$1.getAngleFromPoint=function(centrePoint,anglePoint){var distanceFromXCenter=anglePoint.x-centrePoint.x;var distanceFromYCenter=anglePoint.y-centrePoint.y;var radialDistanceFromCenter=Math.sqrt(distanceFromXCenter*distanceFromXCenter+distanceFromYCenter*distanceFromYCenter);var angle=Math.atan2(distanceFromYCenter,distanceFromXCenter);if(angle<(-0.5*Math.PI)){angle+=2.0*Math.PI}
return{angle:angle,distance:radialDistanceFromCenter}};helpers$1.distanceBetweenPoints=function(pt1,pt2){return Math.sqrt(Math.pow(pt2.x-pt1.x,2)+Math.pow(pt2.y-pt1.y,2))};helpers$1.aliasPixel=function(pixelWidth){return(pixelWidth%2===0)?0:0.5};helpers$1._alignPixel=function(chart,pixel,width){var devicePixelRatio=chart.currentDevicePixelRatio;var halfWidth=width/2;return Math.round((pixel-halfWidth)*devicePixelRatio)/devicePixelRatio+halfWidth};helpers$1.splineCurve=function(firstPoint,middlePoint,afterPoint,t){var previous=firstPoint.skip?middlePoint:firstPoint;var current=middlePoint;var next=afterPoint.skip?middlePoint:afterPoint;var d01=Math.sqrt(Math.pow(current.x-previous.x,2)+Math.pow(current.y-previous.y,2));var d12=Math.sqrt(Math.pow(next.x-current.x,2)+Math.pow(next.y-current.y,2));var s01=d01/(d01+d12);var s12=d12/(d01+d12);s01=isNaN(s01)?0:s01;s12=isNaN(s12)?0:s12;var fa=t*s01;var fb=t*s12;return{previous:{x:current.x-fa*(next.x-previous.x),y:current.y-fa*(next.y-previous.y)},next:{x:current.x+fb*(next.x-previous.x),y:current.y+fb*(next.y-previous.y)}}};helpers$1.EPSILON=Number.EPSILON||1e-14;helpers$1.splineCurveMonotone=function(points){var pointsWithTangents=(points||[]).map(function(point){return{model:point._model,deltaK:0,mK:0}});var pointsLen=pointsWithTangents.length;var i,pointBefore,pointCurrent,pointAfter;for(i=0;i<pointsLen;++i){pointCurrent=pointsWithTangents[i];if(pointCurrent.model.skip){continue}
pointBefore=i>0?pointsWithTangents[i-1]:null;pointAfter=i<pointsLen-1?pointsWithTangents[i+1]:null;if(pointAfter&&!pointAfter.model.skip){var slopeDeltaX=(pointAfter.model.x-pointCurrent.model.x);pointCurrent.deltaK=slopeDeltaX!==0?(pointAfter.model.y-pointCurrent.model.y)/slopeDeltaX:0}
if(!pointBefore||pointBefore.model.skip){pointCurrent.mK=pointCurrent.deltaK}else if(!pointAfter||pointAfter.model.skip){pointCurrent.mK=pointBefore.deltaK}else if(this.sign(pointBefore.deltaK)!==this.sign(pointCurrent.deltaK)){pointCurrent.mK=0}else{pointCurrent.mK=(pointBefore.deltaK+pointCurrent.deltaK)/2}}
var alphaK,betaK,tauK,squaredMagnitude;for(i=0;i<pointsLen-1;++i){pointCurrent=pointsWithTangents[i];pointAfter=pointsWithTangents[i+1];if(pointCurrent.model.skip||pointAfter.model.skip){continue}
if(helpers$1.almostEquals(pointCurrent.deltaK,0,this.EPSILON)){pointCurrent.mK=pointAfter.mK=0;continue}
alphaK=pointCurrent.mK/pointCurrent.deltaK;betaK=pointAfter.mK/pointCurrent.deltaK;squaredMagnitude=Math.pow(alphaK,2)+Math.pow(betaK,2);if(squaredMagnitude<=9){continue}
tauK=3/Math.sqrt(squaredMagnitude);pointCurrent.mK=alphaK*tauK*pointCurrent.deltaK;pointAfter.mK=betaK*tauK*pointCurrent.deltaK}
var deltaX;for(i=0;i<pointsLen;++i){pointCurrent=pointsWithTangents[i];if(pointCurrent.model.skip){continue}
pointBefore=i>0?pointsWithTangents[i-1]:null;pointAfter=i<pointsLen-1?pointsWithTangents[i+1]:null;if(pointBefore&&!pointBefore.model.skip){deltaX=(pointCurrent.model.x-pointBefore.model.x)/3;pointCurrent.model.controlPointPreviousX=pointCurrent.model.x-deltaX;pointCurrent.model.controlPointPreviousY=pointCurrent.model.y-deltaX*pointCurrent.mK}
if(pointAfter&&!pointAfter.model.skip){deltaX=(pointAfter.model.x-pointCurrent.model.x)/3;pointCurrent.model.controlPointNextX=pointCurrent.model.x+deltaX;pointCurrent.model.controlPointNextY=pointCurrent.model.y+deltaX*pointCurrent.mK}}};helpers$1.nextItem=function(collection,index,loop){if(loop){return index>=collection.length-1?collection[0]:collection[index+1]}
return index>=collection.length-1?collection[collection.length-1]:collection[index+1]};helpers$1.previousItem=function(collection,index,loop){if(loop){return index<=0?collection[collection.length-1]:collection[index-1]}
return index<=0?collection[0]:collection[index-1]};helpers$1.niceNum=function(range,round){var exponent=Math.floor(helpers$1.log10(range));var fraction=range/Math.pow(10,exponent);var niceFraction;if(round){if(fraction<1.5){niceFraction=1}else if(fraction<3){niceFraction=2}else if(fraction<7){niceFraction=5}else{niceFraction=10}}else if(fraction<=1.0){niceFraction=1}else if(fraction<=2){niceFraction=2}else if(fraction<=5){niceFraction=5}else{niceFraction=10}
return niceFraction*Math.pow(10,exponent)};helpers$1.requestAnimFrame=(function(){if(typeof window==='undefined'){return function(callback){callback()}}
return window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(callback){return window.setTimeout(callback,1000/60)}}());helpers$1.getRelativePosition=function(evt,chart){var mouseX,mouseY;var e=evt.originalEvent||evt;var canvas=evt.target||evt.srcElement;var boundingRect=canvas.getBoundingClientRect();var touches=e.touches;if(touches&&touches.length>0){mouseX=touches[0].clientX;mouseY=touches[0].clientY}else{mouseX=e.clientX;mouseY=e.clientY}
var paddingLeft=parseFloat(helpers$1.getStyle(canvas,'padding-left'));var paddingTop=parseFloat(helpers$1.getStyle(canvas,'padding-top'));var paddingRight=parseFloat(helpers$1.getStyle(canvas,'padding-right'));var paddingBottom=parseFloat(helpers$1.getStyle(canvas,'padding-bottom'));var width=boundingRect.right-boundingRect.left-paddingLeft-paddingRight;var height=boundingRect.bottom-boundingRect.top-paddingTop-paddingBottom;mouseX=Math.round((mouseX-boundingRect.left-paddingLeft)/(width)*canvas.width/chart.currentDevicePixelRatio);mouseY=Math.round((mouseY-boundingRect.top-paddingTop)/(height)*canvas.height/chart.currentDevicePixelRatio);return{x:mouseX,y:mouseY}};function parseMaxStyle(styleValue,node,parentProperty){var valueInPixels;if(typeof styleValue==='string'){valueInPixels=parseInt(styleValue,10);if(styleValue.indexOf('%')!==-1){valueInPixels=valueInPixels/100*node.parentNode[parentProperty]}}else{valueInPixels=styleValue}
return valueInPixels}
function isConstrainedValue(value){return value!==undefined&&value!==null&&value!=='none'}
function getConstraintDimension(domNode,maxStyle,percentageProperty){var view=document.defaultView;var parentNode=helpers$1._getParentNode(domNode);var constrainedNode=view.getComputedStyle(domNode)[maxStyle];var constrainedContainer=view.getComputedStyle(parentNode)[maxStyle];var hasCNode=isConstrainedValue(constrainedNode);var hasCContainer=isConstrainedValue(constrainedContainer);var infinity=Number.POSITIVE_INFINITY;if(hasCNode||hasCContainer){return Math.min(hasCNode?parseMaxStyle(constrainedNode,domNode,percentageProperty):infinity,hasCContainer?parseMaxStyle(constrainedContainer,parentNode,percentageProperty):infinity)}
return'none'}
helpers$1.getConstraintWidth=function(domNode){return getConstraintDimension(domNode,'max-width','clientWidth')};helpers$1.getConstraintHeight=function(domNode){return getConstraintDimension(domNode,'max-height','clientHeight')};helpers$1._calculatePadding=function(container,padding,parentDimension){padding=helpers$1.getStyle(container,padding);return padding.indexOf('%')>-1?parentDimension*parseInt(padding,10)/100:parseInt(padding,10)};helpers$1._getParentNode=function(domNode){var parent=domNode.parentNode;if(parent&&parent.toString()==='[object ShadowRoot]'){parent=parent.host}
return parent};helpers$1.getMaximumWidth=function(domNode){var container=helpers$1._getParentNode(domNode);if(!container){return domNode.clientWidth}
var clientWidth=container.clientWidth;var paddingLeft=helpers$1._calculatePadding(container,'padding-left',clientWidth);var paddingRight=helpers$1._calculatePadding(container,'padding-right',clientWidth);var w=clientWidth-paddingLeft-paddingRight;var cw=helpers$1.getConstraintWidth(domNode);return isNaN(cw)?w:Math.min(w,cw)};helpers$1.getMaximumHeight=function(domNode){var container=helpers$1._getParentNode(domNode);if(!container){return domNode.clientHeight}
var clientHeight=container.clientHeight;var paddingTop=helpers$1._calculatePadding(container,'padding-top',clientHeight);var paddingBottom=helpers$1._calculatePadding(container,'padding-bottom',clientHeight);var h=clientHeight-paddingTop-paddingBottom;var ch=helpers$1.getConstraintHeight(domNode);return isNaN(ch)?h:Math.min(h,ch)};helpers$1.getStyle=function(el,property){return el.currentStyle?el.currentStyle[property]:document.defaultView.getComputedStyle(el,null).getPropertyValue(property)};helpers$1.retinaScale=function(chart,forceRatio){var pixelRatio=chart.currentDevicePixelRatio=forceRatio||(typeof window!=='undefined'&&window.devicePixelRatio)||1;if(pixelRatio===1){return}
var canvas=chart.canvas;var height=chart.height;var width=chart.width;canvas.height=height*pixelRatio;canvas.width=width*pixelRatio;chart.ctx.scale(pixelRatio,pixelRatio);if(!canvas.style.height&&!canvas.style.width){canvas.style.height=height+'px';canvas.style.width=width+'px'}};helpers$1.fontString=function(pixelSize,fontStyle,fontFamily){return fontStyle+' '+pixelSize+'px '+fontFamily};helpers$1.longestText=function(ctx,font,arrayOfThings,cache){cache=cache||{};var data=cache.data=cache.data||{};var gc=cache.garbageCollect=cache.garbageCollect||[];if(cache.font!==font){data=cache.data={};gc=cache.garbageCollect=[];cache.font=font}
ctx.font=font;var longest=0;var ilen=arrayOfThings.length;var i,j,jlen,thing,nestedThing;for(i=0;i<ilen;i++){thing=arrayOfThings[i];if(thing!==undefined&&thing!==null&&helpers$1.isArray(thing)!==!0){longest=helpers$1.measureText(ctx,data,gc,longest,thing)}else if(helpers$1.isArray(thing)){for(j=0,jlen=thing.length;j<jlen;j++){nestedThing=thing[j];if(nestedThing!==undefined&&nestedThing!==null&&!helpers$1.isArray(nestedThing)){longest=helpers$1.measureText(ctx,data,gc,longest,nestedThing)}}}}
var gcLen=gc.length/2;if(gcLen>arrayOfThings.length){for(i=0;i<gcLen;i++){delete data[gc[i]]}
gc.splice(0,gcLen)}
return longest};helpers$1.measureText=function(ctx,data,gc,longest,string){var textWidth=data[string];if(!textWidth){textWidth=data[string]=ctx.measureText(string).width;gc.push(string)}
if(textWidth>longest){longest=textWidth}
return longest};helpers$1.numberOfLabelLines=function(arrayOfThings){var numberOfLines=1;helpers$1.each(arrayOfThings,function(thing){if(helpers$1.isArray(thing)){if(thing.length>numberOfLines){numberOfLines=thing.length}}});return numberOfLines};helpers$1.color=!chartjsColor?function(value){console.error('Color.js not found!');return value}:function(value){if(value instanceof CanvasGradient){value=core_defaults.global.defaultColor}
return chartjsColor(value)};helpers$1.getHoverColor=function(colorValue){return(colorValue instanceof CanvasPattern||colorValue instanceof CanvasGradient)?colorValue:helpers$1.color(colorValue).saturate(0.5).darken(0.1).rgbString()}};function abstract(){throw new Error('This method is not implemented: either no adapter can '+'be found or an incomplete integration was provided.')}
function DateAdapter(options){this.options=options||{}}
helpers$1.extend(DateAdapter.prototype,{formats:abstract,parse:abstract,format:abstract,add:abstract,diff:abstract,startOf:abstract,endOf:abstract,_create:function(value){return value}});DateAdapter.override=function(members){helpers$1.extend(DateAdapter.prototype,members)};var _date=DateAdapter;var core_adapters={_date:_date};var core_ticks={formatters:{values:function(value){return helpers$1.isArray(value)?value:''+value},linear:function(tickValue,index,ticks){var delta=ticks.length>3?ticks[2]-ticks[1]:ticks[1]-ticks[0];if(Math.abs(delta)>1){if(tickValue!==Math.floor(tickValue)){delta=tickValue-Math.floor(tickValue)}}
var logDelta=helpers$1.log10(Math.abs(delta));var tickString='';if(tickValue!==0){var maxTick=Math.max(Math.abs(ticks[0]),Math.abs(ticks[ticks.length-1]));if(maxTick<1e-4){var logTick=helpers$1.log10(Math.abs(tickValue));var numExponential=Math.floor(logTick)-Math.floor(logDelta);numExponential=Math.max(Math.min(numExponential,20),0);tickString=tickValue.toExponential(numExponential)}else{var numDecimal=-1*Math.floor(logDelta);numDecimal=Math.max(Math.min(numDecimal,20),0);tickString=tickValue.toFixed(numDecimal)}}else{tickString='0'}
return tickString},logarithmic:function(tickValue,index,ticks){var remain=tickValue/(Math.pow(10,Math.floor(helpers$1.log10(tickValue))));if(tickValue===0){return'0'}else if(remain===1||remain===2||remain===5||index===0||index===ticks.length-1){return tickValue.toExponential()}
return''}}};var isArray=helpers$1.isArray;var isNullOrUndef=helpers$1.isNullOrUndef;var valueOrDefault$a=helpers$1.valueOrDefault;var valueAtIndexOrDefault=helpers$1.valueAtIndexOrDefault;core_defaults._set('scale',{display:!0,position:'left',offset:!1,gridLines:{display:!0,color:'rgba(0,0,0,0.1)',lineWidth:1,drawBorder:!0,drawOnChartArea:!0,drawTicks:!0,tickMarkLength:10,zeroLineWidth:1,zeroLineColor:'rgba(0,0,0,0.25)',zeroLineBorderDash:[],zeroLineBorderDashOffset:0.0,offsetGridLines:!1,borderDash:[],borderDashOffset:0.0},scaleLabel:{display:!1,labelString:'',padding:{top:4,bottom:4}},ticks:{beginAtZero:!1,minRotation:0,maxRotation:50,mirror:!1,padding:0,reverse:!1,display:!0,autoSkip:!0,autoSkipPadding:0,labelOffset:0,callback:core_ticks.formatters.values,minor:{},major:{}}});function sample(arr,numItems){var result=[];var increment=arr.length/numItems;var i=0;var len=arr.length;for(;i<len;i+=increment){result.push(arr[Math.floor(i)])}
return result}
function getPixelForGridLine(scale,index,offsetGridLines){var length=scale.getTicks().length;var validIndex=Math.min(index,length-1);var lineValue=scale.getPixelForTick(validIndex);var start=scale._startPixel;var end=scale._endPixel;var epsilon=1e-6;var offset;if(offsetGridLines){if(length===1){offset=Math.max(lineValue-start,end-lineValue)}else if(index===0){offset=(scale.getPixelForTick(1)-lineValue)/2}else{offset=(lineValue-scale.getPixelForTick(validIndex-1))/2}
lineValue+=validIndex<index?offset:-offset;if(lineValue<start-epsilon||lineValue>end+epsilon){return}}
return lineValue}
function garbageCollect(caches,length){helpers$1.each(caches,function(cache){var gc=cache.gc;var gcLen=gc.length/2;var i;if(gcLen>length){for(i=0;i<gcLen;++i){delete cache.data[gc[i]]}
gc.splice(0,gcLen)}})}
function computeLabelSizes(ctx,tickFonts,ticks,caches){var length=ticks.length;var widths=[];var heights=[];var offsets=[];var widestLabelSize=0;var highestLabelSize=0;var i,j,jlen,label,tickFont,fontString,cache,lineHeight,width,height,nestedLabel,widest,highest;for(i=0;i<length;++i){label=ticks[i].label;tickFont=ticks[i].major?tickFonts.major:tickFonts.minor;ctx.font=fontString=tickFont.string;cache=caches[fontString]=caches[fontString]||{data:{},gc:[]};lineHeight=tickFont.lineHeight;width=height=0;if(!isNullOrUndef(label)&&!isArray(label)){width=helpers$1.measureText(ctx,cache.data,cache.gc,width,label);height=lineHeight}else if(isArray(label)){for(j=0,jlen=label.length;j<jlen;++j){nestedLabel=label[j];if(!isNullOrUndef(nestedLabel)&&!isArray(nestedLabel)){width=helpers$1.measureText(ctx,cache.data,cache.gc,width,nestedLabel);height+=lineHeight}}}
widths.push(width);heights.push(height);offsets.push(lineHeight/2);widestLabelSize=Math.max(width,widestLabelSize);highestLabelSize=Math.max(height,highestLabelSize)}
garbageCollect(caches,length);widest=widths.indexOf(widestLabelSize);highest=heights.indexOf(highestLabelSize);function valueAt(idx){return{width:widths[idx]||0,height:heights[idx]||0,offset:offsets[idx]||0}}
return{first:valueAt(0),last:valueAt(length-1),widest:valueAt(widest),highest:valueAt(highest)}}
function getTickMarkLength(options){return options.drawTicks?options.tickMarkLength:0}
function getScaleLabelHeight(options){var font,padding;if(!options.display){return 0}
font=helpers$1.options._parseFont(options);padding=helpers$1.options.toPadding(options.padding);return font.lineHeight+padding.height}
function parseFontOptions(options,nestedOpts){return helpers$1.extend(helpers$1.options._parseFont({fontFamily:valueOrDefault$a(nestedOpts.fontFamily,options.fontFamily),fontSize:valueOrDefault$a(nestedOpts.fontSize,options.fontSize),fontStyle:valueOrDefault$a(nestedOpts.fontStyle,options.fontStyle),lineHeight:valueOrDefault$a(nestedOpts.lineHeight,options.lineHeight)}),{color:helpers$1.options.resolve([nestedOpts.fontColor,options.fontColor,core_defaults.global.defaultFontColor])})}
function parseTickFontOptions(options){var minor=parseFontOptions(options,options.minor);var major=options.major.enabled?parseFontOptions(options,options.major):minor;return{minor:minor,major:major}}
function nonSkipped(ticksToFilter){var filtered=[];var item,index,len;for(index=0,len=ticksToFilter.length;index<len;++index){item=ticksToFilter[index];if(typeof item._index!=='undefined'){filtered.push(item)}}
return filtered}
function getEvenSpacing(arr){var len=arr.length;var i,diff;if(len<2){return!1}
for(diff=arr[0],i=1;i<len;++i){if(arr[i]-arr[i-1]!==diff){return!1}}
return diff}
function calculateSpacing(majorIndices,ticks,axisLength,ticksLimit){var evenMajorSpacing=getEvenSpacing(majorIndices);var spacing=(ticks.length-1)/ticksLimit;var factors,factor,i,ilen;if(!evenMajorSpacing){return Math.max(spacing,1)}
factors=helpers$1.math._factorize(evenMajorSpacing);for(i=0,ilen=factors.length-1;i<ilen;i++){factor=factors[i];if(factor>spacing){return factor}}
return Math.max(spacing,1)}
function getMajorIndices(ticks){var result=[];var i,ilen;for(i=0,ilen=ticks.length;i<ilen;i++){if(ticks[i].major){result.push(i)}}
return result}
function skipMajors(ticks,majorIndices,spacing){var count=0;var next=majorIndices[0];var i,tick;spacing=Math.ceil(spacing);for(i=0;i<ticks.length;i++){tick=ticks[i];if(i===next){tick._index=i;count++;next=majorIndices[count*spacing]}else{delete tick.label}}}
function skip(ticks,spacing,majorStart,majorEnd){var start=valueOrDefault$a(majorStart,0);var end=Math.min(valueOrDefault$a(majorEnd,ticks.length),ticks.length);var count=0;var length,i,tick,next;spacing=Math.ceil(spacing);if(majorEnd){length=majorEnd-majorStart;spacing=length/Math.floor(length/spacing)}
next=start;while(next<0){count++;next=Math.round(start+count*spacing)}
for(i=Math.max(start,0);i<end;i++){tick=ticks[i];if(i===next){tick._index=i;count++;next=Math.round(start+count*spacing)}else{delete tick.label}}}
var Scale=core_element.extend({zeroLineIndex:0,getPadding:function(){var me=this;return{left:me.paddingLeft||0,top:me.paddingTop||0,right:me.paddingRight||0,bottom:me.paddingBottom||0}},getTicks:function(){return this._ticks},_getLabels:function(){var data=this.chart.data;return this.options.labels||(this.isHorizontal()?data.xLabels:data.yLabels)||data.labels||[]},mergeTicksOptions:function(){},beforeUpdate:function(){helpers$1.callback(this.options.beforeUpdate,[this])},update:function(maxWidth,maxHeight,margins){var me=this;var tickOpts=me.options.ticks;var sampleSize=tickOpts.sampleSize;var i,ilen,labels,ticks,samplingEnabled;me.beforeUpdate();me.maxWidth=maxWidth;me.maxHeight=maxHeight;me.margins=helpers$1.extend({left:0,right:0,top:0,bottom:0},margins);me._ticks=null;me.ticks=null;me._labelSizes=null;me._maxLabelLines=0;me.longestLabelWidth=0;me.longestTextCache=me.longestTextCache||{};me._gridLineItems=null;me._labelItems=null;me.beforeSetDimensions();me.setDimensions();me.afterSetDimensions();me.beforeDataLimits();me.determineDataLimits();me.afterDataLimits();me.beforeBuildTicks();ticks=me.buildTicks()||[];ticks=me.afterBuildTicks(ticks)||ticks;if((!ticks||!ticks.length)&&me.ticks){ticks=[];for(i=0,ilen=me.ticks.length;i<ilen;++i){ticks.push({value:me.ticks[i],major:!1})}}
me._ticks=ticks;samplingEnabled=sampleSize<ticks.length;labels=me._convertTicksToLabels(samplingEnabled?sample(ticks,sampleSize):ticks);me._configure();me.beforeCalculateTickRotation();me.calculateTickRotation();me.afterCalculateTickRotation();me.beforeFit();me.fit();me.afterFit();me._ticksToDraw=tickOpts.display&&(tickOpts.autoSkip||tickOpts.source==='auto')?me._autoSkip(ticks):ticks;if(samplingEnabled){labels=me._convertTicksToLabels(me._ticksToDraw)}
me.ticks=labels;me.afterUpdate();return me.minSize},_configure:function(){var me=this;var reversePixels=me.options.ticks.reverse;var startPixel,endPixel;if(me.isHorizontal()){startPixel=me.left;endPixel=me.right}else{startPixel=me.top;endPixel=me.bottom;reversePixels=!reversePixels}
me._startPixel=startPixel;me._endPixel=endPixel;me._reversePixels=reversePixels;me._length=endPixel-startPixel},afterUpdate:function(){helpers$1.callback(this.options.afterUpdate,[this])},beforeSetDimensions:function(){helpers$1.callback(this.options.beforeSetDimensions,[this])},setDimensions:function(){var me=this;if(me.isHorizontal()){me.width=me.maxWidth;me.left=0;me.right=me.width}else{me.height=me.maxHeight;me.top=0;me.bottom=me.height}
me.paddingLeft=0;me.paddingTop=0;me.paddingRight=0;me.paddingBottom=0},afterSetDimensions:function(){helpers$1.callback(this.options.afterSetDimensions,[this])},beforeDataLimits:function(){helpers$1.callback(this.options.beforeDataLimits,[this])},determineDataLimits:helpers$1.noop,afterDataLimits:function(){helpers$1.callback(this.options.afterDataLimits,[this])},beforeBuildTicks:function(){helpers$1.callback(this.options.beforeBuildTicks,[this])},buildTicks:helpers$1.noop,afterBuildTicks:function(ticks){var me=this;if(isArray(ticks)&&ticks.length){return helpers$1.callback(me.options.afterBuildTicks,[me,ticks])}
me.ticks=helpers$1.callback(me.options.afterBuildTicks,[me,me.ticks])||me.ticks;return ticks},beforeTickToLabelConversion:function(){helpers$1.callback(this.options.beforeTickToLabelConversion,[this])},convertTicksToLabels:function(){var me=this;var tickOpts=me.options.ticks;me.ticks=me.ticks.map(tickOpts.userCallback||tickOpts.callback,this)},afterTickToLabelConversion:function(){helpers$1.callback(this.options.afterTickToLabelConversion,[this])},beforeCalculateTickRotation:function(){helpers$1.callback(this.options.beforeCalculateTickRotation,[this])},calculateTickRotation:function(){var me=this;var options=me.options;var tickOpts=options.ticks;var numTicks=me.getTicks().length;var minRotation=tickOpts.minRotation||0;var maxRotation=tickOpts.maxRotation;var labelRotation=minRotation;var labelSizes,maxLabelWidth,maxLabelHeight,maxWidth,tickWidth,maxHeight,maxLabelDiagonal;if(!me._isVisible()||!tickOpts.display||minRotation>=maxRotation||numTicks<=1||!me.isHorizontal()){me.labelRotation=minRotation;return}
labelSizes=me._getLabelSizes();maxLabelWidth=labelSizes.widest.width;maxLabelHeight=labelSizes.highest.height-labelSizes.highest.offset;maxWidth=Math.min(me.maxWidth,me.chart.width-maxLabelWidth);tickWidth=options.offset?me.maxWidth/numTicks:maxWidth/(numTicks-1);if(maxLabelWidth+6>tickWidth){tickWidth=maxWidth/(numTicks-(options.offset?0.5:1));maxHeight=me.maxHeight-getTickMarkLength(options.gridLines)-tickOpts.padding-getScaleLabelHeight(options.scaleLabel);maxLabelDiagonal=Math.sqrt(maxLabelWidth*maxLabelWidth+maxLabelHeight*maxLabelHeight);labelRotation=helpers$1.toDegrees(Math.min(Math.asin(Math.min((labelSizes.highest.height+6)/tickWidth,1)),Math.asin(Math.min(maxHeight/maxLabelDiagonal,1))-Math.asin(maxLabelHeight/maxLabelDiagonal)));labelRotation=Math.max(minRotation,Math.min(maxRotation,labelRotation))}
me.labelRotation=labelRotation},afterCalculateTickRotation:function(){helpers$1.callback(this.options.afterCalculateTickRotation,[this])},beforeFit:function(){helpers$1.callback(this.options.beforeFit,[this])},fit:function(){var me=this;var minSize=me.minSize={width:0,height:0};var chart=me.chart;var opts=me.options;var tickOpts=opts.ticks;var scaleLabelOpts=opts.scaleLabel;var gridLineOpts=opts.gridLines;var display=me._isVisible();var isBottom=opts.position==='bottom';var isHorizontal=me.isHorizontal();if(isHorizontal){minSize.width=me.maxWidth}else if(display){minSize.width=getTickMarkLength(gridLineOpts)+getScaleLabelHeight(scaleLabelOpts)}
if(!isHorizontal){minSize.height=me.maxHeight}else if(display){minSize.height=getTickMarkLength(gridLineOpts)+getScaleLabelHeight(scaleLabelOpts)}
if(tickOpts.display&&display){var tickFonts=parseTickFontOptions(tickOpts);var labelSizes=me._getLabelSizes();var firstLabelSize=labelSizes.first;var lastLabelSize=labelSizes.last;var widestLabelSize=labelSizes.widest;var highestLabelSize=labelSizes.highest;var lineSpace=tickFonts.minor.lineHeight*0.4;var tickPadding=tickOpts.padding;if(isHorizontal){var isRotated=me.labelRotation!==0;var angleRadians=helpers$1.toRadians(me.labelRotation);var cosRotation=Math.cos(angleRadians);var sinRotation=Math.sin(angleRadians);var labelHeight=sinRotation*widestLabelSize.width+cosRotation*(highestLabelSize.height-(isRotated?highestLabelSize.offset:0))+(isRotated?0:lineSpace);minSize.height=Math.min(me.maxHeight,minSize.height+labelHeight+tickPadding);var offsetLeft=me.getPixelForTick(0)-me.left;var offsetRight=me.right-me.getPixelForTick(me.getTicks().length-1);var paddingLeft,paddingRight;if(isRotated){paddingLeft=isBottom?cosRotation*firstLabelSize.width+sinRotation*firstLabelSize.offset:sinRotation*(firstLabelSize.height-firstLabelSize.offset);paddingRight=isBottom?sinRotation*(lastLabelSize.height-lastLabelSize.offset):cosRotation*lastLabelSize.width+sinRotation*lastLabelSize.offset}else{paddingLeft=firstLabelSize.width/2;paddingRight=lastLabelSize.width/2}
me.paddingLeft=Math.max((paddingLeft-offsetLeft)*me.width/(me.width-offsetLeft),0)+3;me.paddingRight=Math.max((paddingRight-offsetRight)*me.width/(me.width-offsetRight),0)+3}else{var labelWidth=tickOpts.mirror?0:widestLabelSize.width+tickPadding+lineSpace;minSize.width=Math.min(me.maxWidth,minSize.width+labelWidth);me.paddingTop=firstLabelSize.height/2;me.paddingBottom=lastLabelSize.height/2}}
me.handleMargins();if(isHorizontal){me.width=me._length=chart.width-me.margins.left-me.margins.right;me.height=minSize.height}else{me.width=minSize.width;me.height=me._length=chart.height-me.margins.top-me.margins.bottom}},handleMargins:function(){var me=this;if(me.margins){me.margins.left=Math.max(me.paddingLeft,me.margins.left);me.margins.top=Math.max(me.paddingTop,me.margins.top);me.margins.right=Math.max(me.paddingRight,me.margins.right);me.margins.bottom=Math.max(me.paddingBottom,me.margins.bottom)}},afterFit:function(){helpers$1.callback(this.options.afterFit,[this])},isHorizontal:function(){var pos=this.options.position;return pos==='top'||pos==='bottom'},isFullWidth:function(){return this.options.fullWidth},getRightValue:function(rawValue){if(isNullOrUndef(rawValue)){return NaN}
if((typeof rawValue==='number'||rawValue instanceof Number)&&!isFinite(rawValue)){return NaN}
if(rawValue){if(this.isHorizontal()){if(rawValue.x!==undefined){return this.getRightValue(rawValue.x)}}else if(rawValue.y!==undefined){return this.getRightValue(rawValue.y)}}
return rawValue},_convertTicksToLabels:function(ticks){var me=this;var labels,i,ilen;me.ticks=ticks.map(function(tick){return tick.value});me.beforeTickToLabelConversion();labels=me.convertTicksToLabels(ticks)||me.ticks;me.afterTickToLabelConversion();for(i=0,ilen=ticks.length;i<ilen;++i){ticks[i].label=labels[i]}
return labels},_getLabelSizes:function(){var me=this;var labelSizes=me._labelSizes;if(!labelSizes){me._labelSizes=labelSizes=computeLabelSizes(me.ctx,parseTickFontOptions(me.options.ticks),me.getTicks(),me.longestTextCache);me.longestLabelWidth=labelSizes.widest.width}
return labelSizes},_parseValue:function(value){var start,end,min,max;if(isArray(value)){start=+this.getRightValue(value[0]);end=+this.getRightValue(value[1]);min=Math.min(start,end);max=Math.max(start,end)}else{value=+this.getRightValue(value);start=undefined;end=value;min=value;max=value}
return{min:min,max:max,start:start,end:end}},_getScaleLabel:function(rawValue){var v=this._parseValue(rawValue);if(v.start!==undefined){return'['+v.start+', '+v.end+']'}
return+this.getRightValue(rawValue)},getLabelForIndex:helpers$1.noop,getPixelForValue:helpers$1.noop,getValueForPixel:helpers$1.noop,getPixelForTick:function(index){var me=this;var offset=me.options.offset;var numTicks=me._ticks.length;var tickWidth=1/Math.max(numTicks-(offset?0:1),1);return index<0||index>numTicks-1?null:me.getPixelForDecimal(index*tickWidth+(offset?tickWidth/2:0))},getPixelForDecimal:function(decimal){var me=this;if(me._reversePixels){decimal=1-decimal}
return me._startPixel+decimal*me._length},getDecimalForPixel:function(pixel){var decimal=(pixel-this._startPixel)/this._length;return this._reversePixels?1-decimal:decimal},getBasePixel:function(){return this.getPixelForValue(this.getBaseValue())},getBaseValue:function(){var me=this;var min=me.min;var max=me.max;return me.beginAtZero?0:min<0&&max<0?max:min>0&&max>0?min:0},_autoSkip:function(ticks){var me=this;var tickOpts=me.options.ticks;var axisLength=me._length;var ticksLimit=tickOpts.maxTicksLimit||axisLength/me._tickSize()+1;var majorIndices=tickOpts.major.enabled?getMajorIndices(ticks):[];var numMajorIndices=majorIndices.length;var first=majorIndices[0];var last=majorIndices[numMajorIndices-1];var i,ilen,spacing,avgMajorSpacing;if(numMajorIndices>ticksLimit){skipMajors(ticks,majorIndices,numMajorIndices/ticksLimit);return nonSkipped(ticks)}
spacing=calculateSpacing(majorIndices,ticks,axisLength,ticksLimit);if(numMajorIndices>0){for(i=0,ilen=numMajorIndices-1;i<ilen;i++){skip(ticks,spacing,majorIndices[i],majorIndices[i+1])}
avgMajorSpacing=numMajorIndices>1?(last-first)/(numMajorIndices-1):null;skip(ticks,spacing,helpers$1.isNullOrUndef(avgMajorSpacing)?0:first-avgMajorSpacing,first);skip(ticks,spacing,last,helpers$1.isNullOrUndef(avgMajorSpacing)?ticks.length:last+avgMajorSpacing);return nonSkipped(ticks)}
skip(ticks,spacing);return nonSkipped(ticks)},_tickSize:function(){var me=this;var optionTicks=me.options.ticks;var rot=helpers$1.toRadians(me.labelRotation);var cos=Math.abs(Math.cos(rot));var sin=Math.abs(Math.sin(rot));var labelSizes=me._getLabelSizes();var padding=optionTicks.autoSkipPadding||0;var w=labelSizes?labelSizes.widest.width+padding:0;var h=labelSizes?labelSizes.highest.height+padding:0;return me.isHorizontal()?h*cos>w*sin?w/cos:h/sin:h*sin<w*cos?h/cos:w/sin},_isVisible:function(){var me=this;var chart=me.chart;var display=me.options.display;var i,ilen,meta;if(display!=='auto'){return!!display}
for(i=0,ilen=chart.data.datasets.length;i<ilen;++i){if(chart.isDatasetVisible(i)){meta=chart.getDatasetMeta(i);if(meta.xAxisID===me.id||meta.yAxisID===me.id){return!0}}}
return!1},_computeGridLineItems:function(chartArea){var me=this;var chart=me.chart;var options=me.options;var gridLines=options.gridLines;var position=options.position;var offsetGridLines=gridLines.offsetGridLines;var isHorizontal=me.isHorizontal();var ticks=me._ticksToDraw;var ticksLength=ticks.length+(offsetGridLines?1:0);var tl=getTickMarkLength(gridLines);var items=[];var axisWidth=gridLines.drawBorder?valueAtIndexOrDefault(gridLines.lineWidth,0,0):0;var axisHalfWidth=axisWidth/2;var alignPixel=helpers$1._alignPixel;var alignBorderValue=function(pixel){return alignPixel(chart,pixel,axisWidth)};var borderValue,i,tick,lineValue,alignedLineValue;var tx1,ty1,tx2,ty2,x1,y1,x2,y2,lineWidth,lineColor,borderDash,borderDashOffset;if(position==='top'){borderValue=alignBorderValue(me.bottom);ty1=me.bottom-tl;ty2=borderValue-axisHalfWidth;y1=alignBorderValue(chartArea.top)+axisHalfWidth;y2=chartArea.bottom}else if(position==='bottom'){borderValue=alignBorderValue(me.top);y1=chartArea.top;y2=alignBorderValue(chartArea.bottom)-axisHalfWidth;ty1=borderValue+axisHalfWidth;ty2=me.top+tl}else if(position==='left'){borderValue=alignBorderValue(me.right);tx1=me.right-tl;tx2=borderValue-axisHalfWidth;x1=alignBorderValue(chartArea.left)+axisHalfWidth;x2=chartArea.right}else{borderValue=alignBorderValue(me.left);x1=chartArea.left;x2=alignBorderValue(chartArea.right)-axisHalfWidth;tx1=borderValue+axisHalfWidth;tx2=me.left+tl}
for(i=0;i<ticksLength;++i){tick=ticks[i]||{};if(isNullOrUndef(tick.label)&&i<ticks.length){continue}
if(i===me.zeroLineIndex&&options.offset===offsetGridLines){lineWidth=gridLines.zeroLineWidth;lineColor=gridLines.zeroLineColor;borderDash=gridLines.zeroLineBorderDash||[];borderDashOffset=gridLines.zeroLineBorderDashOffset||0.0}else{lineWidth=valueAtIndexOrDefault(gridLines.lineWidth,i,1);lineColor=valueAtIndexOrDefault(gridLines.color,i,'rgba(0,0,0,0.1)');borderDash=gridLines.borderDash||[];borderDashOffset=gridLines.borderDashOffset||0.0}
lineValue=getPixelForGridLine(me,tick._index||i,offsetGridLines);if(lineValue===undefined){continue}
alignedLineValue=alignPixel(chart,lineValue,lineWidth);if(isHorizontal){tx1=tx2=x1=x2=alignedLineValue}else{ty1=ty2=y1=y2=alignedLineValue}
items.push({tx1:tx1,ty1:ty1,tx2:tx2,ty2:ty2,x1:x1,y1:y1,x2:x2,y2:y2,width:lineWidth,color:lineColor,borderDash:borderDash,borderDashOffset:borderDashOffset,})}
items.ticksLength=ticksLength;items.borderValue=borderValue;return items},_computeLabelItems:function(){var me=this;var options=me.options;var optionTicks=options.ticks;var position=options.position;var isMirrored=optionTicks.mirror;var isHorizontal=me.isHorizontal();var ticks=me._ticksToDraw;var fonts=parseTickFontOptions(optionTicks);var tickPadding=optionTicks.padding;var tl=getTickMarkLength(options.gridLines);var rotation=-helpers$1.toRadians(me.labelRotation);var items=[];var i,ilen,tick,label,x,y,textAlign,pixel,font,lineHeight,lineCount,textOffset;if(position==='top'){y=me.bottom-tl-tickPadding;textAlign=!rotation?'center':'left'}else if(position==='bottom'){y=me.top+tl+tickPadding;textAlign=!rotation?'center':'right'}else if(position==='left'){x=me.right-(isMirrored?0:tl)-tickPadding;textAlign=isMirrored?'left':'right'}else{x=me.left+(isMirrored?0:tl)+tickPadding;textAlign=isMirrored?'right':'left'}
for(i=0,ilen=ticks.length;i<ilen;++i){tick=ticks[i];label=tick.label;if(isNullOrUndef(label)){continue}
pixel=me.getPixelForTick(tick._index||i)+optionTicks.labelOffset;font=tick.major?fonts.major:fonts.minor;lineHeight=font.lineHeight;lineCount=isArray(label)?label.length:1;if(isHorizontal){x=pixel;textOffset=position==='top'?((!rotation?0.5:1)-lineCount)*lineHeight:(!rotation?0.5:0)*lineHeight}else{y=pixel;textOffset=(1-lineCount)*lineHeight/2}
items.push({x:x,y:y,rotation:rotation,label:label,font:font,textOffset:textOffset,textAlign:textAlign})}
return items},_drawGrid:function(chartArea){var me=this;var gridLines=me.options.gridLines;if(!gridLines.display){return}
var ctx=me.ctx;var chart=me.chart;var alignPixel=helpers$1._alignPixel;var axisWidth=gridLines.drawBorder?valueAtIndexOrDefault(gridLines.lineWidth,0,0):0;var items=me._gridLineItems||(me._gridLineItems=me._computeGridLineItems(chartArea));var width,color,i,ilen,item;for(i=0,ilen=items.length;i<ilen;++i){item=items[i];width=item.width;color=item.color;if(width&&color){ctx.save();ctx.lineWidth=width;ctx.strokeStyle=color;if(ctx.setLineDash){ctx.setLineDash(item.borderDash);ctx.lineDashOffset=item.borderDashOffset}
ctx.beginPath();if(gridLines.drawTicks){ctx.moveTo(item.tx1,item.ty1);ctx.lineTo(item.tx2,item.ty2)}
if(gridLines.drawOnChartArea){ctx.moveTo(item.x1,item.y1);ctx.lineTo(item.x2,item.y2)}
ctx.stroke();ctx.restore()}}
if(axisWidth){var firstLineWidth=axisWidth;var lastLineWidth=valueAtIndexOrDefault(gridLines.lineWidth,items.ticksLength-1,1);var borderValue=items.borderValue;var x1,x2,y1,y2;if(me.isHorizontal()){x1=alignPixel(chart,me.left,firstLineWidth)-firstLineWidth/2;x2=alignPixel(chart,me.right,lastLineWidth)+lastLineWidth/2;y1=y2=borderValue}else{y1=alignPixel(chart,me.top,firstLineWidth)-firstLineWidth/2;y2=alignPixel(chart,me.bottom,lastLineWidth)+lastLineWidth/2;x1=x2=borderValue}
ctx.lineWidth=axisWidth;ctx.strokeStyle=valueAtIndexOrDefault(gridLines.color,0);ctx.beginPath();ctx.moveTo(x1,y1);ctx.lineTo(x2,y2);ctx.stroke()}},_drawLabels:function(){var me=this;var optionTicks=me.options.ticks;if(!optionTicks.display){return}
var ctx=me.ctx;var items=me._labelItems||(me._labelItems=me._computeLabelItems());var i,j,ilen,jlen,item,tickFont,label,y;for(i=0,ilen=items.length;i<ilen;++i){item=items[i];tickFont=item.font;ctx.save();ctx.translate(item.x,item.y);ctx.rotate(item.rotation);ctx.font=tickFont.string;ctx.fillStyle=tickFont.color;ctx.textBaseline='middle';ctx.textAlign=item.textAlign;label=item.label;y=item.textOffset;if(isArray(label)){for(j=0,jlen=label.length;j<jlen;++j){ctx.fillText(''+label[j],0,y);y+=tickFont.lineHeight}}else{ctx.fillText(label,0,y)}
ctx.restore()}},_drawTitle:function(){var me=this;var ctx=me.ctx;var options=me.options;var scaleLabel=options.scaleLabel;if(!scaleLabel.display){return}
var scaleLabelFontColor=valueOrDefault$a(scaleLabel.fontColor,core_defaults.global.defaultFontColor);var scaleLabelFont=helpers$1.options._parseFont(scaleLabel);var scaleLabelPadding=helpers$1.options.toPadding(scaleLabel.padding);var halfLineHeight=scaleLabelFont.lineHeight/2;var position=options.position;var rotation=0;var scaleLabelX,scaleLabelY;if(me.isHorizontal()){scaleLabelX=me.left+me.width/2;scaleLabelY=position==='bottom'?me.bottom-halfLineHeight-scaleLabelPadding.bottom:me.top+halfLineHeight+scaleLabelPadding.top}else{var isLeft=position==='left';scaleLabelX=isLeft?me.left+halfLineHeight+scaleLabelPadding.top:me.right-halfLineHeight-scaleLabelPadding.top;scaleLabelY=me.top+me.height/2;rotation=isLeft?-0.5*Math.PI:0.5*Math.PI}
ctx.save();ctx.translate(scaleLabelX,scaleLabelY);ctx.rotate(rotation);ctx.textAlign='center';ctx.textBaseline='middle';ctx.fillStyle=scaleLabelFontColor;ctx.font=scaleLabelFont.string;ctx.fillText(scaleLabel.labelString,0,0);ctx.restore()},draw:function(chartArea){var me=this;if(!me._isVisible()){return}
me._drawGrid(chartArea);me._drawTitle();me._drawLabels()},_layers:function(){var me=this;var opts=me.options;var tz=opts.ticks&&opts.ticks.z||0;var gz=opts.gridLines&&opts.gridLines.z||0;if(!me._isVisible()||tz===gz||me.draw!==me._draw){return[{z:tz,draw:function(){me.draw.apply(me,arguments)}}]}
return[{z:gz,draw:function(){me._drawGrid.apply(me,arguments);me._drawTitle.apply(me,arguments)}},{z:tz,draw:function(){me._drawLabels.apply(me,arguments)}}]},_getMatchingVisibleMetas:function(type){var me=this;var isHorizontal=me.isHorizontal();return me.chart._getSortedVisibleDatasetMetas().filter(function(meta){return(!type||meta.type===type)&&(isHorizontal?meta.xAxisID===me.id:meta.yAxisID===me.id)})}});Scale.prototype._draw=Scale.prototype.draw;var core_scale=Scale;var isNullOrUndef$1=helpers$1.isNullOrUndef;var defaultConfig={position:'bottom'};var scale_category=core_scale.extend({determineDataLimits:function(){var me=this;var labels=me._getLabels();var ticksOpts=me.options.ticks;var min=ticksOpts.min;var max=ticksOpts.max;var minIndex=0;var maxIndex=labels.length-1;var findIndex;if(min!==undefined){findIndex=labels.indexOf(min);if(findIndex>=0){minIndex=findIndex}}
if(max!==undefined){findIndex=labels.indexOf(max);if(findIndex>=0){maxIndex=findIndex}}
me.minIndex=minIndex;me.maxIndex=maxIndex;me.min=labels[minIndex];me.max=labels[maxIndex]},buildTicks:function(){var me=this;var labels=me._getLabels();var minIndex=me.minIndex;var maxIndex=me.maxIndex;me.ticks=(minIndex===0&&maxIndex===labels.length-1)?labels:labels.slice(minIndex,maxIndex+1)},getLabelForIndex:function(index,datasetIndex){var me=this;var chart=me.chart;if(chart.getDatasetMeta(datasetIndex).controller._getValueScaleId()===me.id){return me.getRightValue(chart.data.datasets[datasetIndex].data[index])}
return me._getLabels()[index]},_configure:function(){var me=this;var offset=me.options.offset;var ticks=me.ticks;core_scale.prototype._configure.call(me);if(!me.isHorizontal()){me._reversePixels=!me._reversePixels}
if(!ticks){return}
me._startValue=me.minIndex-(offset?0.5:0);me._valueRange=Math.max(ticks.length-(offset?0:1),1)},getPixelForValue:function(value,index,datasetIndex){var me=this;var valueCategory,labels,idx;if(!isNullOrUndef$1(index)&&!isNullOrUndef$1(datasetIndex)){value=me.chart.data.datasets[datasetIndex].data[index]}
if(!isNullOrUndef$1(value)){valueCategory=me.isHorizontal()?value.x:value.y}
if(valueCategory!==undefined||(value!==undefined&&isNaN(index))){labels=me._getLabels();value=helpers$1.valueOrDefault(valueCategory,value);idx=labels.indexOf(value);index=idx!==-1?idx:index;if(isNaN(index)){index=value}}
return me.getPixelForDecimal((index-me._startValue)/me._valueRange)},getPixelForTick:function(index){var ticks=this.ticks;return index<0||index>ticks.length-1?null:this.getPixelForValue(ticks[index],index+this.minIndex)},getValueForPixel:function(pixel){var me=this;var value=Math.round(me._startValue+me.getDecimalForPixel(pixel)*me._valueRange);return Math.min(Math.max(value,0),me.ticks.length-1)},getBasePixel:function(){return this.bottom}});var _defaults=defaultConfig;scale_category._defaults=_defaults;var noop=helpers$1.noop;var isNullOrUndef$2=helpers$1.isNullOrUndef;function generateTicks(generationOptions,dataRange){var ticks=[];var MIN_SPACING=1e-14;var stepSize=generationOptions.stepSize;var unit=stepSize||1;var maxNumSpaces=generationOptions.maxTicks-1;var min=generationOptions.min;var max=generationOptions.max;var precision=generationOptions.precision;var rmin=dataRange.min;var rmax=dataRange.max;var spacing=helpers$1.niceNum((rmax-rmin)/maxNumSpaces/unit)*unit;var factor,niceMin,niceMax,numSpaces;if(spacing<MIN_SPACING&&isNullOrUndef$2(min)&&isNullOrUndef$2(max)){return[rmin,rmax]}
numSpaces=Math.ceil(rmax/spacing)-Math.floor(rmin/spacing);if(numSpaces>maxNumSpaces){spacing=helpers$1.niceNum(numSpaces*spacing/maxNumSpaces/unit)*unit}
if(stepSize||isNullOrUndef$2(precision)){factor=Math.pow(10,helpers$1._decimalPlaces(spacing))}else{factor=Math.pow(10,precision);spacing=Math.ceil(spacing*factor)/factor}
niceMin=Math.floor(rmin/spacing)*spacing;niceMax=Math.ceil(rmax/spacing)*spacing;if(stepSize){if(!isNullOrUndef$2(min)&&helpers$1.almostWhole(min/spacing,spacing/1000)){niceMin=min}
if(!isNullOrUndef$2(max)&&helpers$1.almostWhole(max/spacing,spacing/1000)){niceMax=max}}
numSpaces=(niceMax-niceMin)/spacing;if(helpers$1.almostEquals(numSpaces,Math.round(numSpaces),spacing/1000)){numSpaces=Math.round(numSpaces)}else{numSpaces=Math.ceil(numSpaces)}
niceMin=Math.round(niceMin*factor)/factor;niceMax=Math.round(niceMax*factor)/factor;ticks.push(isNullOrUndef$2(min)?niceMin:min);for(var j=1;j<numSpaces;++j){ticks.push(Math.round((niceMin+j*spacing)*factor)/factor)}
ticks.push(isNullOrUndef$2(max)?niceMax:max);return ticks}
var scale_linearbase=core_scale.extend({getRightValue:function(value){if(typeof value==='string'){return+value}
return core_scale.prototype.getRightValue.call(this,value)},handleTickRangeOptions:function(){var me=this;var opts=me.options;var tickOpts=opts.ticks;if(tickOpts.beginAtZero){var minSign=helpers$1.sign(me.min);var maxSign=helpers$1.sign(me.max);if(minSign<0&&maxSign<0){me.max=0}else if(minSign>0&&maxSign>0){me.min=0}}
var setMin=tickOpts.min!==undefined||tickOpts.suggestedMin!==undefined;var setMax=tickOpts.max!==undefined||tickOpts.suggestedMax!==undefined;if(tickOpts.min!==undefined){me.min=tickOpts.min}else if(tickOpts.suggestedMin!==undefined){if(me.min===null){me.min=tickOpts.suggestedMin}else{me.min=Math.min(me.min,tickOpts.suggestedMin)}}
if(tickOpts.max!==undefined){me.max=tickOpts.max}else if(tickOpts.suggestedMax!==undefined){if(me.max===null){me.max=tickOpts.suggestedMax}else{me.max=Math.max(me.max,tickOpts.suggestedMax)}}
if(setMin!==setMax){if(me.min>=me.max){if(setMin){me.max=me.min+1}else{me.min=me.max-1}}}
if(me.min===me.max){me.max++;if(!tickOpts.beginAtZero){me.min--}}},getTickLimit:function(){var me=this;var tickOpts=me.options.ticks;var stepSize=tickOpts.stepSize;var maxTicksLimit=tickOpts.maxTicksLimit;var maxTicks;if(stepSize){maxTicks=Math.ceil(me.max/stepSize)-Math.floor(me.min/stepSize)+1}else{maxTicks=me._computeTickLimit();maxTicksLimit=maxTicksLimit||11}
if(maxTicksLimit){maxTicks=Math.min(maxTicksLimit,maxTicks)}
return maxTicks},_computeTickLimit:function(){return Number.POSITIVE_INFINITY},handleDirectionalChanges:noop,buildTicks:function(){var me=this;var opts=me.options;var tickOpts=opts.ticks;var maxTicks=me.getTickLimit();maxTicks=Math.max(2,maxTicks);var numericGeneratorOptions={maxTicks:maxTicks,min:tickOpts.min,max:tickOpts.max,precision:tickOpts.precision,stepSize:helpers$1.valueOrDefault(tickOpts.fixedStepSize,tickOpts.stepSize)};var ticks=me.ticks=generateTicks(numericGeneratorOptions,me);me.handleDirectionalChanges();me.max=helpers$1.max(ticks);me.min=helpers$1.min(ticks);if(tickOpts.reverse){ticks.reverse();me.start=me.max;me.end=me.min}else{me.start=me.min;me.end=me.max}},convertTicksToLabels:function(){var me=this;me.ticksAsNumbers=me.ticks.slice();me.zeroLineIndex=me.ticks.indexOf(0);core_scale.prototype.convertTicksToLabels.call(me)},_configure:function(){var me=this;var ticks=me.getTicks();var start=me.min;var end=me.max;var offset;core_scale.prototype._configure.call(me);if(me.options.offset&&ticks.length){offset=(end-start)/Math.max(ticks.length-1,1)/2;start-=offset;end+=offset}
me._startValue=start;me._endValue=end;me._valueRange=end-start}});var defaultConfig$1={position:'left',ticks:{callback:core_ticks.formatters.linear}};var DEFAULT_MIN=0;var DEFAULT_MAX=1;function getOrCreateStack(stacks,stacked,meta){var key=[meta.type,stacked===undefined&&meta.stack===undefined?meta.index:'',meta.stack].join('.');if(stacks[key]===undefined){stacks[key]={pos:[],neg:[]}}
return stacks[key]}
function stackData(scale,stacks,meta,data){var opts=scale.options;var stacked=opts.stacked;var stack=getOrCreateStack(stacks,stacked,meta);var pos=stack.pos;var neg=stack.neg;var ilen=data.length;var i,value;for(i=0;i<ilen;++i){value=scale._parseValue(data[i]);if(isNaN(value.min)||isNaN(value.max)||meta.data[i].hidden){continue}
pos[i]=pos[i]||0;neg[i]=neg[i]||0;if(opts.relativePoints){pos[i]=100}else if(value.min<0||value.max<0){neg[i]+=value.min}else{pos[i]+=value.max}}}
function updateMinMax(scale,meta,data){var ilen=data.length;var i,value;for(i=0;i<ilen;++i){value=scale._parseValue(data[i]);if(isNaN(value.min)||isNaN(value.max)||meta.data[i].hidden){continue}
scale.min=Math.min(scale.min,value.min);scale.max=Math.max(scale.max,value.max)}}
var scale_linear=scale_linearbase.extend({determineDataLimits:function(){var me=this;var opts=me.options;var chart=me.chart;var datasets=chart.data.datasets;var metasets=me._getMatchingVisibleMetas();var hasStacks=opts.stacked;var stacks={};var ilen=metasets.length;var i,meta,data,values;me.min=Number.POSITIVE_INFINITY;me.max=Number.NEGATIVE_INFINITY;if(hasStacks===undefined){for(i=0;!hasStacks&&i<ilen;++i){meta=metasets[i];hasStacks=meta.stack!==undefined}}
for(i=0;i<ilen;++i){meta=metasets[i];data=datasets[meta.index].data;if(hasStacks){stackData(me,stacks,meta,data)}else{updateMinMax(me,meta,data)}}
helpers$1.each(stacks,function(stackValues){values=stackValues.pos.concat(stackValues.neg);me.min=Math.min(me.min,helpers$1.min(values));me.max=Math.max(me.max,helpers$1.max(values))});me.min=helpers$1.isFinite(me.min)&&!isNaN(me.min)?me.min:DEFAULT_MIN;me.max=helpers$1.isFinite(me.max)&&!isNaN(me.max)?me.max:DEFAULT_MAX;me.handleTickRangeOptions()},_computeTickLimit:function(){var me=this;var tickFont;if(me.isHorizontal()){return Math.ceil(me.width/40)}
tickFont=helpers$1.options._parseFont(me.options.ticks);return Math.ceil(me.height/tickFont.lineHeight)},handleDirectionalChanges:function(){if(!this.isHorizontal()){this.ticks.reverse()}},getLabelForIndex:function(index,datasetIndex){return this._getScaleLabel(this.chart.data.datasets[datasetIndex].data[index])},getPixelForValue:function(value){var me=this;return me.getPixelForDecimal((+me.getRightValue(value)-me._startValue)/me._valueRange)},getValueForPixel:function(pixel){return this._startValue+this.getDecimalForPixel(pixel)*this._valueRange},getPixelForTick:function(index){var ticks=this.ticksAsNumbers;if(index<0||index>ticks.length-1){return null}
return this.getPixelForValue(ticks[index])}});var _defaults$1=defaultConfig$1;scale_linear._defaults=_defaults$1;var valueOrDefault$b=helpers$1.valueOrDefault;var log10=helpers$1.math.log10;function generateTicks$1(generationOptions,dataRange){var ticks=[];var tickVal=valueOrDefault$b(generationOptions.min,Math.pow(10,Math.floor(log10(dataRange.min))));var endExp=Math.floor(log10(dataRange.max));var endSignificand=Math.ceil(dataRange.max/Math.pow(10,endExp));var exp,significand;if(tickVal===0){exp=Math.floor(log10(dataRange.minNotZero));significand=Math.floor(dataRange.minNotZero/Math.pow(10,exp));ticks.push(tickVal);tickVal=significand*Math.pow(10,exp)}else{exp=Math.floor(log10(tickVal));significand=Math.floor(tickVal/Math.pow(10,exp))}
var precision=exp<0?Math.pow(10,Math.abs(exp)):1;do{ticks.push(tickVal);++significand;if(significand===10){significand=1;++exp;precision=exp>=0?1:precision}
tickVal=Math.round(significand*Math.pow(10,exp)*precision)/precision}while(exp<endExp||(exp===endExp&&significand<endSignificand));var lastTick=valueOrDefault$b(generationOptions.max,tickVal);ticks.push(lastTick);return ticks}
var defaultConfig$2={position:'left',ticks:{callback:core_ticks.formatters.logarithmic}};function nonNegativeOrDefault(value,defaultValue){return helpers$1.isFinite(value)&&value>=0?value:defaultValue}
var scale_logarithmic=core_scale.extend({determineDataLimits:function(){var me=this;var opts=me.options;var chart=me.chart;var datasets=chart.data.datasets;var isHorizontal=me.isHorizontal();function IDMatches(meta){return isHorizontal?meta.xAxisID===me.id:meta.yAxisID===me.id}
var datasetIndex,meta,value,data,i,ilen;me.min=Number.POSITIVE_INFINITY;me.max=Number.NEGATIVE_INFINITY;me.minNotZero=Number.POSITIVE_INFINITY;var hasStacks=opts.stacked;if(hasStacks===undefined){for(datasetIndex=0;datasetIndex<datasets.length;datasetIndex++){meta=chart.getDatasetMeta(datasetIndex);if(chart.isDatasetVisible(datasetIndex)&&IDMatches(meta)&&meta.stack!==undefined){hasStacks=!0;break}}}
if(opts.stacked||hasStacks){var valuesPerStack={};for(datasetIndex=0;datasetIndex<datasets.length;datasetIndex++){meta=chart.getDatasetMeta(datasetIndex);var key=[meta.type,((opts.stacked===undefined&&meta.stack===undefined)?datasetIndex:''),meta.stack].join('.');if(chart.isDatasetVisible(datasetIndex)&&IDMatches(meta)){if(valuesPerStack[key]===undefined){valuesPerStack[key]=[]}
data=datasets[datasetIndex].data;for(i=0,ilen=data.length;i<ilen;i++){var values=valuesPerStack[key];value=me._parseValue(data[i]);if(isNaN(value.min)||isNaN(value.max)||meta.data[i].hidden||value.min<0||value.max<0){continue}
values[i]=values[i]||0;values[i]+=value.max}}}
helpers$1.each(valuesPerStack,function(valuesForType){if(valuesForType.length>0){var minVal=helpers$1.min(valuesForType);var maxVal=helpers$1.max(valuesForType);me.min=Math.min(me.min,minVal);me.max=Math.max(me.max,maxVal)}})}else{for(datasetIndex=0;datasetIndex<datasets.length;datasetIndex++){meta=chart.getDatasetMeta(datasetIndex);if(chart.isDatasetVisible(datasetIndex)&&IDMatches(meta)){data=datasets[datasetIndex].data;for(i=0,ilen=data.length;i<ilen;i++){value=me._parseValue(data[i]);if(isNaN(value.min)||isNaN(value.max)||meta.data[i].hidden||value.min<0||value.max<0){continue}
me.min=Math.min(value.min,me.min);me.max=Math.max(value.max,me.max);if(value.min!==0){me.minNotZero=Math.min(value.min,me.minNotZero)}}}}}
me.min=helpers$1.isFinite(me.min)?me.min:null;me.max=helpers$1.isFinite(me.max)?me.max:null;me.minNotZero=helpers$1.isFinite(me.minNotZero)?me.minNotZero:null;this.handleTickRangeOptions()},handleTickRangeOptions:function(){var me=this;var tickOpts=me.options.ticks;var DEFAULT_MIN=1;var DEFAULT_MAX=10;me.min=nonNegativeOrDefault(tickOpts.min,me.min);me.max=nonNegativeOrDefault(tickOpts.max,me.max);if(me.min===me.max){if(me.min!==0&&me.min!==null){me.min=Math.pow(10,Math.floor(log10(me.min))-1);me.max=Math.pow(10,Math.floor(log10(me.max))+1)}else{me.min=DEFAULT_MIN;me.max=DEFAULT_MAX}}
if(me.min===null){me.min=Math.pow(10,Math.floor(log10(me.max))-1)}
if(me.max===null){me.max=me.min!==0?Math.pow(10,Math.floor(log10(me.min))+1):DEFAULT_MAX}
if(me.minNotZero===null){if(me.min>0){me.minNotZero=me.min}else if(me.max<1){me.minNotZero=Math.pow(10,Math.floor(log10(me.max)))}else{me.minNotZero=DEFAULT_MIN}}},buildTicks:function(){var me=this;var tickOpts=me.options.ticks;var reverse=!me.isHorizontal();var generationOptions={min:nonNegativeOrDefault(tickOpts.min),max:nonNegativeOrDefault(tickOpts.max)};var ticks=me.ticks=generateTicks$1(generationOptions,me);me.max=helpers$1.max(ticks);me.min=helpers$1.min(ticks);if(tickOpts.reverse){reverse=!reverse;me.start=me.max;me.end=me.min}else{me.start=me.min;me.end=me.max}
if(reverse){ticks.reverse()}},convertTicksToLabels:function(){this.tickValues=this.ticks.slice();core_scale.prototype.convertTicksToLabels.call(this)},getLabelForIndex:function(index,datasetIndex){return this._getScaleLabel(this.chart.data.datasets[datasetIndex].data[index])},getPixelForTick:function(index){var ticks=this.tickValues;if(index<0||index>ticks.length-1){return null}
return this.getPixelForValue(ticks[index])},_getFirstTickValue:function(value){var exp=Math.floor(log10(value));var significand=Math.floor(value/Math.pow(10,exp));return significand*Math.pow(10,exp)},_configure:function(){var me=this;var start=me.min;var offset=0;core_scale.prototype._configure.call(me);if(start===0){start=me._getFirstTickValue(me.minNotZero);offset=valueOrDefault$b(me.options.ticks.fontSize,core_defaults.global.defaultFontSize)/me._length}
me._startValue=log10(start);me._valueOffset=offset;me._valueRange=(log10(me.max)-log10(start))/(1-offset)},getPixelForValue:function(value){var me=this;var decimal=0;value=+me.getRightValue(value);if(value>me.min&&value>0){decimal=(log10(value)-me._startValue)/me._valueRange+me._valueOffset}
return me.getPixelForDecimal(decimal)},getValueForPixel:function(pixel){var me=this;var decimal=me.getDecimalForPixel(pixel);return decimal===0&&me.min===0?0:Math.pow(10,me._startValue+(decimal-me._valueOffset)*me._valueRange)}});var _defaults$2=defaultConfig$2;scale_logarithmic._defaults=_defaults$2;var valueOrDefault$c=helpers$1.valueOrDefault;var valueAtIndexOrDefault$1=helpers$1.valueAtIndexOrDefault;var resolve$4=helpers$1.options.resolve;var defaultConfig$3={display:!0,animate:!0,position:'chartArea',angleLines:{display:!0,color:'rgba(0,0,0,0.1)',lineWidth:1,borderDash:[],borderDashOffset:0.0},gridLines:{circular:!1},ticks:{showLabelBackdrop:!0,backdropColor:'rgba(255,255,255,0.75)',backdropPaddingY:2,backdropPaddingX:2,callback:core_ticks.formatters.linear},pointLabels:{display:!0,fontSize:10,callback:function(label){return label}}};function getTickBackdropHeight(opts){var tickOpts=opts.ticks;if(tickOpts.display&&opts.display){return valueOrDefault$c(tickOpts.fontSize,core_defaults.global.defaultFontSize)+tickOpts.backdropPaddingY*2}
return 0}
function measureLabelSize(ctx,lineHeight,label){if(helpers$1.isArray(label)){return{w:helpers$1.longestText(ctx,ctx.font,label),h:label.length*lineHeight}}
return{w:ctx.measureText(label).width,h:lineHeight}}
function determineLimits(angle,pos,size,min,max){if(angle===min||angle===max){return{start:pos-(size/2),end:pos+(size/2)}}else if(angle<min||angle>max){return{start:pos-size,end:pos}}
return{start:pos,end:pos+size}}
function fitWithPointLabels(scale){var plFont=helpers$1.options._parseFont(scale.options.pointLabels);var furthestLimits={l:0,r:scale.width,t:0,b:scale.height-scale.paddingTop};var furthestAngles={};var i,textSize,pointPosition;scale.ctx.font=plFont.string;scale._pointLabelSizes=[];var valueCount=scale.chart.data.labels.length;for(i=0;i<valueCount;i++){pointPosition=scale.getPointPosition(i,scale.drawingArea+5);textSize=measureLabelSize(scale.ctx,plFont.lineHeight,scale.pointLabels[i]);scale._pointLabelSizes[i]=textSize;var angleRadians=scale.getIndexAngle(i);var angle=helpers$1.toDegrees(angleRadians)%360;var hLimits=determineLimits(angle,pointPosition.x,textSize.w,0,180);var vLimits=determineLimits(angle,pointPosition.y,textSize.h,90,270);if(hLimits.start<furthestLimits.l){furthestLimits.l=hLimits.start;furthestAngles.l=angleRadians}
if(hLimits.end>furthestLimits.r){furthestLimits.r=hLimits.end;furthestAngles.r=angleRadians}
if(vLimits.start<furthestLimits.t){furthestLimits.t=vLimits.start;furthestAngles.t=angleRadians}
if(vLimits.end>furthestLimits.b){furthestLimits.b=vLimits.end;furthestAngles.b=angleRadians}}
scale.setReductions(scale.drawingArea,furthestLimits,furthestAngles)}
function getTextAlignForAngle(angle){if(angle===0||angle===180){return'center'}else if(angle<180){return'left'}
return'right'}
function fillText(ctx,text,position,lineHeight){var y=position.y+lineHeight/2;var i,ilen;if(helpers$1.isArray(text)){for(i=0,ilen=text.length;i<ilen;++i){ctx.fillText(text[i],position.x,y);y+=lineHeight}}else{ctx.fillText(text,position.x,y)}}
function adjustPointPositionForLabelHeight(angle,textSize,position){if(angle===90||angle===270){position.y-=(textSize.h/2)}else if(angle>270||angle<90){position.y-=textSize.h}}
function drawPointLabels(scale){var ctx=scale.ctx;var opts=scale.options;var pointLabelOpts=opts.pointLabels;var tickBackdropHeight=getTickBackdropHeight(opts);var outerDistance=scale.getDistanceFromCenterForValue(opts.ticks.reverse?scale.min:scale.max);var plFont=helpers$1.options._parseFont(pointLabelOpts);ctx.save();ctx.font=plFont.string;ctx.textBaseline='middle';for(var i=scale.chart.data.labels.length-1;i>=0;i--){var extra=(i===0?tickBackdropHeight/2:0);var pointLabelPosition=scale.getPointPosition(i,outerDistance+extra+5);var pointLabelFontColor=valueAtIndexOrDefault$1(pointLabelOpts.fontColor,i,core_defaults.global.defaultFontColor);ctx.fillStyle=pointLabelFontColor;var angleRadians=scale.getIndexAngle(i);var angle=helpers$1.toDegrees(angleRadians);ctx.textAlign=getTextAlignForAngle(angle);adjustPointPositionForLabelHeight(angle,scale._pointLabelSizes[i],pointLabelPosition);fillText(ctx,scale.pointLabels[i],pointLabelPosition,plFont.lineHeight)}
ctx.restore()}
function drawRadiusLine(scale,gridLineOpts,radius,index){var ctx=scale.ctx;var circular=gridLineOpts.circular;var valueCount=scale.chart.data.labels.length;var lineColor=valueAtIndexOrDefault$1(gridLineOpts.color,index-1);var lineWidth=valueAtIndexOrDefault$1(gridLineOpts.lineWidth,index-1);var pointPosition;if((!circular&&!valueCount)||!lineColor||!lineWidth){return}
ctx.save();ctx.strokeStyle=lineColor;ctx.lineWidth=lineWidth;if(ctx.setLineDash){ctx.setLineDash(gridLineOpts.borderDash||[]);ctx.lineDashOffset=gridLineOpts.borderDashOffset||0.0}
ctx.beginPath();if(circular){ctx.arc(scale.xCenter,scale.yCenter,radius,0,Math.PI*2)}else{pointPosition=scale.getPointPosition(0,radius);ctx.moveTo(pointPosition.x,pointPosition.y);for(var i=1;i<valueCount;i++){pointPosition=scale.getPointPosition(i,radius);ctx.lineTo(pointPosition.x,pointPosition.y)}}
ctx.closePath();ctx.stroke();ctx.restore()}
function numberOrZero(param){return helpers$1.isNumber(param)?param:0}
var scale_radialLinear=scale_linearbase.extend({setDimensions:function(){var me=this;me.width=me.maxWidth;me.height=me.maxHeight;me.paddingTop=getTickBackdropHeight(me.options)/2;me.xCenter=Math.floor(me.width/2);me.yCenter=Math.floor((me.height-me.paddingTop)/2);me.drawingArea=Math.min(me.height-me.paddingTop,me.width)/2},determineDataLimits:function(){var me=this;var chart=me.chart;var min=Number.POSITIVE_INFINITY;var max=Number.NEGATIVE_INFINITY;helpers$1.each(chart.data.datasets,function(dataset,datasetIndex){if(chart.isDatasetVisible(datasetIndex)){var meta=chart.getDatasetMeta(datasetIndex);helpers$1.each(dataset.data,function(rawValue,index){var value=+me.getRightValue(rawValue);if(isNaN(value)||meta.data[index].hidden){return}
min=Math.min(value,min);max=Math.max(value,max)})}});me.min=(min===Number.POSITIVE_INFINITY?0:min);me.max=(max===Number.NEGATIVE_INFINITY?0:max);me.handleTickRangeOptions()},_computeTickLimit:function(){return Math.ceil(this.drawingArea/getTickBackdropHeight(this.options))},convertTicksToLabels:function(){var me=this;scale_linearbase.prototype.convertTicksToLabels.call(me);me.pointLabels=me.chart.data.labels.map(function(){var label=helpers$1.callback(me.options.pointLabels.callback,arguments,me);return label||label===0?label:''})},getLabelForIndex:function(index,datasetIndex){return+this.getRightValue(this.chart.data.datasets[datasetIndex].data[index])},fit:function(){var me=this;var opts=me.options;if(opts.display&&opts.pointLabels.display){fitWithPointLabels(me)}else{me.setCenterPoint(0,0,0,0)}},setReductions:function(largestPossibleRadius,furthestLimits,furthestAngles){var me=this;var radiusReductionLeft=furthestLimits.l/Math.sin(furthestAngles.l);var radiusReductionRight=Math.max(furthestLimits.r-me.width,0)/Math.sin(furthestAngles.r);var radiusReductionTop=-furthestLimits.t/Math.cos(furthestAngles.t);var radiusReductionBottom=-Math.max(furthestLimits.b-(me.height-me.paddingTop),0)/Math.cos(furthestAngles.b);radiusReductionLeft=numberOrZero(radiusReductionLeft);radiusReductionRight=numberOrZero(radiusReductionRight);radiusReductionTop=numberOrZero(radiusReductionTop);radiusReductionBottom=numberOrZero(radiusReductionBottom);me.drawingArea=Math.min(Math.floor(largestPossibleRadius-(radiusReductionLeft+radiusReductionRight)/2),Math.floor(largestPossibleRadius-(radiusReductionTop+radiusReductionBottom)/2));me.setCenterPoint(radiusReductionLeft,radiusReductionRight,radiusReductionTop,radiusReductionBottom)},setCenterPoint:function(leftMovement,rightMovement,topMovement,bottomMovement){var me=this;var maxRight=me.width-rightMovement-me.drawingArea;var maxLeft=leftMovement+me.drawingArea;var maxTop=topMovement+me.drawingArea;var maxBottom=(me.height-me.paddingTop)-bottomMovement-me.drawingArea;me.xCenter=Math.floor(((maxLeft+maxRight)/2)+me.left);me.yCenter=Math.floor(((maxTop+maxBottom)/2)+me.top+me.paddingTop)},getIndexAngle:function(index){var chart=this.chart;var angleMultiplier=360/chart.data.labels.length;var options=chart.options||{};var startAngle=options.startAngle||0;var angle=(index*angleMultiplier+startAngle)%360;return(angle<0?angle+360:angle)*Math.PI*2/360},getDistanceFromCenterForValue:function(value){var me=this;if(helpers$1.isNullOrUndef(value)){return NaN}
var scalingFactor=me.drawingArea/(me.max-me.min);if(me.options.ticks.reverse){return(me.max-value)*scalingFactor}
return(value-me.min)*scalingFactor},getPointPosition:function(index,distanceFromCenter){var me=this;var thisAngle=me.getIndexAngle(index)-(Math.PI/2);return{x:Math.cos(thisAngle)*distanceFromCenter+me.xCenter,y:Math.sin(thisAngle)*distanceFromCenter+me.yCenter}},getPointPositionForValue:function(index,value){return this.getPointPosition(index,this.getDistanceFromCenterForValue(value))},getBasePosition:function(index){var me=this;var min=me.min;var max=me.max;return me.getPointPositionForValue(index||0,me.beginAtZero?0:min<0&&max<0?max:min>0&&max>0?min:0)},_drawGrid:function(){var me=this;var ctx=me.ctx;var opts=me.options;var gridLineOpts=opts.gridLines;var angleLineOpts=opts.angleLines;var lineWidth=valueOrDefault$c(angleLineOpts.lineWidth,gridLineOpts.lineWidth);var lineColor=valueOrDefault$c(angleLineOpts.color,gridLineOpts.color);var i,offset,position;if(opts.pointLabels.display){drawPointLabels(me)}
if(gridLineOpts.display){helpers$1.each(me.ticks,function(label,index){if(index!==0){offset=me.getDistanceFromCenterForValue(me.ticksAsNumbers[index]);drawRadiusLine(me,gridLineOpts,offset,index)}})}
if(angleLineOpts.display&&lineWidth&&lineColor){ctx.save();ctx.lineWidth=lineWidth;ctx.strokeStyle=lineColor;if(ctx.setLineDash){ctx.setLineDash(resolve$4([angleLineOpts.borderDash,gridLineOpts.borderDash,[]]));ctx.lineDashOffset=resolve$4([angleLineOpts.borderDashOffset,gridLineOpts.borderDashOffset,0.0])}
for(i=me.chart.data.labels.length-1;i>=0;i--){offset=me.getDistanceFromCenterForValue(opts.ticks.reverse?me.min:me.max);position=me.getPointPosition(i,offset);ctx.beginPath();ctx.moveTo(me.xCenter,me.yCenter);ctx.lineTo(position.x,position.y);ctx.stroke()}
ctx.restore()}},_drawLabels:function(){var me=this;var ctx=me.ctx;var opts=me.options;var tickOpts=opts.ticks;if(!tickOpts.display){return}
var startAngle=me.getIndexAngle(0);var tickFont=helpers$1.options._parseFont(tickOpts);var tickFontColor=valueOrDefault$c(tickOpts.fontColor,core_defaults.global.defaultFontColor);var offset,width;ctx.save();ctx.font=tickFont.string;ctx.translate(me.xCenter,me.yCenter);ctx.rotate(startAngle);ctx.textAlign='center';ctx.textBaseline='middle';helpers$1.each(me.ticks,function(label,index){if(index===0&&!tickOpts.reverse){return}
offset=me.getDistanceFromCenterForValue(me.ticksAsNumbers[index]);if(tickOpts.showLabelBackdrop){width=ctx.measureText(label).width;ctx.fillStyle=tickOpts.backdropColor;ctx.fillRect(-width/2-tickOpts.backdropPaddingX,-offset-tickFont.size/2-tickOpts.backdropPaddingY,width+tickOpts.backdropPaddingX*2,tickFont.size+tickOpts.backdropPaddingY*2)}
ctx.fillStyle=tickFontColor;ctx.fillText(label,0,-offset)});ctx.restore()},_drawTitle:helpers$1.noop});var _defaults$3=defaultConfig$3;scale_radialLinear._defaults=_defaults$3;var deprecated$1=helpers$1._deprecated;var resolve$5=helpers$1.options.resolve;var valueOrDefault$d=helpers$1.valueOrDefault;var MIN_INTEGER=Number.MIN_SAFE_INTEGER||-9007199254740991;var MAX_INTEGER=Number.MAX_SAFE_INTEGER||9007199254740991;var INTERVALS={millisecond:{common:!0,size:1,steps:1000},second:{common:!0,size:1000,steps:60},minute:{common:!0,size:60000,steps:60},hour:{common:!0,size:3600000,steps:24},day:{common:!0,size:86400000,steps:30},week:{common:!1,size:604800000,steps:4},month:{common:!0,size:2.628e9,steps:12},quarter:{common:!1,size:7.884e9,steps:4},year:{common:!0,size:3.154e10}};var UNITS=Object.keys(INTERVALS);function sorter(a,b){return a-b}
function arrayUnique(items){var hash={};var out=[];var i,ilen,item;for(i=0,ilen=items.length;i<ilen;++i){item=items[i];if(!hash[item]){hash[item]=!0;out.push(item)}}
return out}
function getMin(options){return helpers$1.valueOrDefault(options.time.min,options.ticks.min)}
function getMax(options){return helpers$1.valueOrDefault(options.time.max,options.ticks.max)}
function buildLookupTable(timestamps,min,max,distribution){if(distribution==='linear'||!timestamps.length){return[{time:min,pos:0},{time:max,pos:1}]}
var table=[];var items=[min];var i,ilen,prev,curr,next;for(i=0,ilen=timestamps.length;i<ilen;++i){curr=timestamps[i];if(curr>min&&curr<max){items.push(curr)}}
items.push(max);for(i=0,ilen=items.length;i<ilen;++i){next=items[i+1];prev=items[i-1];curr=items[i];if(prev===undefined||next===undefined||Math.round((next+prev)/2)!==curr){table.push({time:curr,pos:i/(ilen-1)})}}
return table}
function lookup(table,key,value){var lo=0;var hi=table.length-1;var mid,i0,i1;while(lo>=0&&lo<=hi){mid=(lo+hi)>>1;i0=table[mid-1]||null;i1=table[mid];if(!i0){return{lo:null,hi:i1}}else if(i1[key]<value){lo=mid+1}else if(i0[key]>value){hi=mid-1}else{return{lo:i0,hi:i1}}}
return{lo:i1,hi:null}}
function interpolate$1(table,skey,sval,tkey){var range=lookup(table,skey,sval);var prev=!range.lo?table[0]:!range.hi?table[table.length-2]:range.lo;var next=!range.lo?table[1]:!range.hi?table[table.length-1]:range.hi;var span=next[skey]-prev[skey];var ratio=span?(sval-prev[skey])/span:0;var offset=(next[tkey]-prev[tkey])*ratio;return prev[tkey]+offset}
function toTimestamp(scale,input){var adapter=scale._adapter;var options=scale.options.time;var parser=options.parser;var format=parser||options.format;var value=input;if(typeof parser==='function'){value=parser(value)}
if(!helpers$1.isFinite(value)){value=typeof format==='string'?adapter.parse(value,format):adapter.parse(value)}
if(value!==null){return+value}
if(!parser&&typeof format==='function'){value=format(input);if(!helpers$1.isFinite(value)){value=adapter.parse(value)}}
return value}
function parse(scale,input){if(helpers$1.isNullOrUndef(input)){return null}
var options=scale.options.time;var value=toTimestamp(scale,scale.getRightValue(input));if(value===null){return value}
if(options.round){value=+scale._adapter.startOf(value,options.round)}
return value}
function determineUnitForAutoTicks(minUnit,min,max,capacity){var ilen=UNITS.length;var i,interval,factor;for(i=UNITS.indexOf(minUnit);i<ilen-1;++i){interval=INTERVALS[UNITS[i]];factor=interval.steps?interval.steps:MAX_INTEGER;if(interval.common&&Math.ceil((max-min)/(factor*interval.size))<=capacity){return UNITS[i]}}
return UNITS[ilen-1]}
function determineUnitForFormatting(scale,numTicks,minUnit,min,max){var i,unit;for(i=UNITS.length-1;i>=UNITS.indexOf(minUnit);i--){unit=UNITS[i];if(INTERVALS[unit].common&&scale._adapter.diff(max,min,unit)>=numTicks-1){return unit}}
return UNITS[minUnit?UNITS.indexOf(minUnit):0]}
function determineMajorUnit(unit){for(var i=UNITS.indexOf(unit)+1,ilen=UNITS.length;i<ilen;++i){if(INTERVALS[UNITS[i]].common){return UNITS[i]}}}
function generate(scale,min,max,capacity){var adapter=scale._adapter;var options=scale.options;var timeOpts=options.time;var minor=timeOpts.unit||determineUnitForAutoTicks(timeOpts.minUnit,min,max,capacity);var stepSize=resolve$5([timeOpts.stepSize,timeOpts.unitStepSize,1]);var weekday=minor==='week'?timeOpts.isoWeekday:!1;var first=min;var ticks=[];var time;if(weekday){first=+adapter.startOf(first,'isoWeek',weekday)}
first=+adapter.startOf(first,weekday?'day':minor);if(adapter.diff(max,min,minor)>100000*stepSize){throw min+' and '+max+' are too far apart with stepSize of '+stepSize+' '+minor}
for(time=first;time<max;time=+adapter.add(time,stepSize,minor)){ticks.push(time)}
if(time===max||options.bounds==='ticks'){ticks.push(time)}
return ticks}
function computeOffsets(table,ticks,min,max,options){var start=0;var end=0;var first,last;if(options.offset&&ticks.length){first=interpolate$1(table,'time',ticks[0],'pos');if(ticks.length===1){start=1-first}else{start=(interpolate$1(table,'time',ticks[1],'pos')-first)/2}
last=interpolate$1(table,'time',ticks[ticks.length-1],'pos');if(ticks.length===1){end=last}else{end=(last-interpolate$1(table,'time',ticks[ticks.length-2],'pos'))/2}}
return{start:start,end:end,factor:1/(start+1+end)}}
function setMajorTicks(scale,ticks,map,majorUnit){var adapter=scale._adapter;var first=+adapter.startOf(ticks[0].value,majorUnit);var last=ticks[ticks.length-1].value;var major,index;for(major=first;major<=last;major=+adapter.add(major,1,majorUnit)){index=map[major];if(index>=0){ticks[index].major=!0}}
return ticks}
function ticksFromTimestamps(scale,values,majorUnit){var ticks=[];var map={};var ilen=values.length;var i,value;for(i=0;i<ilen;++i){value=values[i];map[value]=i;ticks.push({value:value,major:!1})}
return(ilen===0||!majorUnit)?ticks:setMajorTicks(scale,ticks,map,majorUnit)}
var defaultConfig$4={position:'bottom',distribution:'linear',bounds:'data',adapters:{},time:{parser:!1,unit:!1,round:!1,displayFormat:!1,isoWeekday:!1,minUnit:'millisecond',displayFormats:{}},ticks:{autoSkip:!1,source:'auto',major:{enabled:!1}}};var scale_time=core_scale.extend({initialize:function(){this.mergeTicksOptions();core_scale.prototype.initialize.call(this)},update:function(){var me=this;var options=me.options;var time=options.time||(options.time={});var adapter=me._adapter=new core_adapters._date(options.adapters.date);deprecated$1('time scale',time.format,'time.format','time.parser');deprecated$1('time scale',time.min,'time.min','ticks.min');deprecated$1('time scale',time.max,'time.max','ticks.max');helpers$1.mergeIf(time.displayFormats,adapter.formats());return core_scale.prototype.update.apply(me,arguments)},getRightValue:function(rawValue){if(rawValue&&rawValue.t!==undefined){rawValue=rawValue.t}
return core_scale.prototype.getRightValue.call(this,rawValue)},determineDataLimits:function(){var me=this;var chart=me.chart;var adapter=me._adapter;var options=me.options;var unit=options.time.unit||'day';var min=MAX_INTEGER;var max=MIN_INTEGER;var timestamps=[];var datasets=[];var labels=[];var i,j,ilen,jlen,data,timestamp,labelsAdded;var dataLabels=me._getLabels();for(i=0,ilen=dataLabels.length;i<ilen;++i){labels.push(parse(me,dataLabels[i]))}
for(i=0,ilen=(chart.data.datasets||[]).length;i<ilen;++i){if(chart.isDatasetVisible(i)){data=chart.data.datasets[i].data;if(helpers$1.isObject(data[0])){datasets[i]=[];for(j=0,jlen=data.length;j<jlen;++j){timestamp=parse(me,data[j]);timestamps.push(timestamp);datasets[i][j]=timestamp}}else{datasets[i]=labels.slice(0);if(!labelsAdded){timestamps=timestamps.concat(labels);labelsAdded=!0}}}else{datasets[i]=[]}}
if(labels.length){min=Math.min(min,labels[0]);max=Math.max(max,labels[labels.length-1])}
if(timestamps.length){timestamps=ilen>1?arrayUnique(timestamps).sort(sorter):timestamps.sort(sorter);min=Math.min(min,timestamps[0]);max=Math.max(max,timestamps[timestamps.length-1])}
min=parse(me,getMin(options))||min;max=parse(me,getMax(options))||max;min=min===MAX_INTEGER?+adapter.startOf(Date.now(),unit):min;max=max===MIN_INTEGER?+adapter.endOf(Date.now(),unit)+1:max;me.min=Math.min(min,max);me.max=Math.max(min+1,max);me._table=[];me._timestamps={data:timestamps,datasets:datasets,labels:labels}},buildTicks:function(){var me=this;var min=me.min;var max=me.max;var options=me.options;var tickOpts=options.ticks;var timeOpts=options.time;var timestamps=me._timestamps;var ticks=[];var capacity=me.getLabelCapacity(min);var source=tickOpts.source;var distribution=options.distribution;var i,ilen,timestamp;if(source==='data'||(source==='auto'&&distribution==='series')){timestamps=timestamps.data}else if(source==='labels'){timestamps=timestamps.labels}else{timestamps=generate(me,min,max,capacity)}
if(options.bounds==='ticks'&&timestamps.length){min=timestamps[0];max=timestamps[timestamps.length-1]}
min=parse(me,getMin(options))||min;max=parse(me,getMax(options))||max;for(i=0,ilen=timestamps.length;i<ilen;++i){timestamp=timestamps[i];if(timestamp>=min&&timestamp<=max){ticks.push(timestamp)}}
me.min=min;me.max=max;me._unit=timeOpts.unit||(tickOpts.autoSkip?determineUnitForAutoTicks(timeOpts.minUnit,me.min,me.max,capacity):determineUnitForFormatting(me,ticks.length,timeOpts.minUnit,me.min,me.max));me._majorUnit=!tickOpts.major.enabled||me._unit==='year'?undefined:determineMajorUnit(me._unit);me._table=buildLookupTable(me._timestamps.data,min,max,distribution);me._offsets=computeOffsets(me._table,ticks,min,max,options);if(tickOpts.reverse){ticks.reverse()}
return ticksFromTimestamps(me,ticks,me._majorUnit)},getLabelForIndex:function(index,datasetIndex){var me=this;var adapter=me._adapter;var data=me.chart.data;var timeOpts=me.options.time;var label=data.labels&&index<data.labels.length?data.labels[index]:'';var value=data.datasets[datasetIndex].data[index];if(helpers$1.isObject(value)){label=me.getRightValue(value)}
if(timeOpts.tooltipFormat){return adapter.format(toTimestamp(me,label),timeOpts.tooltipFormat)}
if(typeof label==='string'){return label}
return adapter.format(toTimestamp(me,label),timeOpts.displayFormats.datetime)},tickFormatFunction:function(time,index,ticks,format){var me=this;var adapter=me._adapter;var options=me.options;var formats=options.time.displayFormats;var minorFormat=formats[me._unit];var majorUnit=me._majorUnit;var majorFormat=formats[majorUnit];var tick=ticks[index];var tickOpts=options.ticks;var major=majorUnit&&majorFormat&&tick&&tick.major;var label=adapter.format(time,format?format:major?majorFormat:minorFormat);var nestedTickOpts=major?tickOpts.major:tickOpts.minor;var formatter=resolve$5([nestedTickOpts.callback,nestedTickOpts.userCallback,tickOpts.callback,tickOpts.userCallback]);return formatter?formatter(label,index,ticks):label},convertTicksToLabels:function(ticks){var labels=[];var i,ilen;for(i=0,ilen=ticks.length;i<ilen;++i){labels.push(this.tickFormatFunction(ticks[i].value,i,ticks))}
return labels},getPixelForOffset:function(time){var me=this;var offsets=me._offsets;var pos=interpolate$1(me._table,'time',time,'pos');return me.getPixelForDecimal((offsets.start+pos)*offsets.factor)},getPixelForValue:function(value,index,datasetIndex){var me=this;var time=null;if(index!==undefined&&datasetIndex!==undefined){time=me._timestamps.datasets[datasetIndex][index]}
if(time===null){time=parse(me,value)}
if(time!==null){return me.getPixelForOffset(time)}},getPixelForTick:function(index){var ticks=this.getTicks();return index>=0&&index<ticks.length?this.getPixelForOffset(ticks[index].value):null},getValueForPixel:function(pixel){var me=this;var offsets=me._offsets;var pos=me.getDecimalForPixel(pixel)/offsets.factor-offsets.end;var time=interpolate$1(me._table,'pos',pos,'time');return me._adapter._create(time)},_getLabelSize:function(label){var me=this;var ticksOpts=me.options.ticks;var tickLabelWidth=me.ctx.measureText(label).width;var angle=helpers$1.toRadians(me.isHorizontal()?ticksOpts.maxRotation:ticksOpts.minRotation);var cosRotation=Math.cos(angle);var sinRotation=Math.sin(angle);var tickFontSize=valueOrDefault$d(ticksOpts.fontSize,core_defaults.global.defaultFontSize);return{w:(tickLabelWidth*cosRotation)+(tickFontSize*sinRotation),h:(tickLabelWidth*sinRotation)+(tickFontSize*cosRotation)}},getLabelWidth:function(label){return this._getLabelSize(label).w},getLabelCapacity:function(exampleTime){var me=this;var timeOpts=me.options.time;var displayFormats=timeOpts.displayFormats;var format=displayFormats[timeOpts.unit]||displayFormats.millisecond;var exampleLabel=me.tickFormatFunction(exampleTime,0,ticksFromTimestamps(me,[exampleTime],me._majorUnit),format);var size=me._getLabelSize(exampleLabel);var capacity=Math.floor(me.isHorizontal()?me.width/size.w:me.height/size.h);if(me.options.offset){capacity--}
return capacity>0?capacity:1}});var _defaults$4=defaultConfig$4;scale_time._defaults=_defaults$4;var scales={category:scale_category,linear:scale_linear,logarithmic:scale_logarithmic,radialLinear:scale_radialLinear,time:scale_time};var FORMATS={datetime:'MMM D, YYYY, h:mm:ss a',millisecond:'h:mm:ss.SSS a',second:'h:mm:ss a',minute:'h:mm a',hour:'hA',day:'MMM D',week:'ll',month:'MMM YYYY',quarter:'[Q]Q - YYYY',year:'YYYY'};core_adapters._date.override(typeof moment==='function'?{_id:'moment',formats:function(){return FORMATS},parse:function(value,format){if(typeof value==='string'&&typeof format==='string'){value=moment(value,format)}else if(!(value instanceof moment)){value=moment(value)}
return value.isValid()?value.valueOf():null},format:function(time,format){return moment(time).format(format)},add:function(time,amount,unit){return moment(time).add(amount,unit).valueOf()},diff:function(max,min,unit){return moment(max).diff(moment(min),unit)},startOf:function(time,unit,weekday){time=moment(time);if(unit==='isoWeek'){return time.isoWeekday(weekday).valueOf()}
return time.startOf(unit).valueOf()},endOf:function(time,unit){return moment(time).endOf(unit).valueOf()},_create:function(time){return moment(time)},}:{});core_defaults._set('global',{plugins:{filler:{propagate:!0}}});var mappers={dataset:function(source){var index=source.fill;var chart=source.chart;var meta=chart.getDatasetMeta(index);var visible=meta&&chart.isDatasetVisible(index);var points=(visible&&meta.dataset._children)||[];var length=points.length||0;return!length?null:function(point,i){return(i<length&&points[i]._view)||null}},boundary:function(source){var boundary=source.boundary;var x=boundary?boundary.x:null;var y=boundary?boundary.y:null;if(helpers$1.isArray(boundary)){return function(point,i){return boundary[i]}}
return function(point){return{x:x===null?point.x:x,y:y===null?point.y:y,}}}};function decodeFill(el,index,count){var model=el._model||{};var fill=model.fill;var target;if(fill===undefined){fill=!!model.backgroundColor}
if(fill===!1||fill===null){return!1}
if(fill===!0){return'origin'}
target=parseFloat(fill,10);if(isFinite(target)&&Math.floor(target)===target){if(fill[0]==='-'||fill[0]==='+'){target=index+target}
if(target===index||target<0||target>=count){return!1}
return target}
switch(fill){case 'bottom':return'start';case 'top':return'end';case 'zero':return'origin';case 'origin':case 'start':case 'end':return fill;default:return!1}}
function computeLinearBoundary(source){var model=source.el._model||{};var scale=source.el._scale||{};var fill=source.fill;var target=null;var horizontal;if(isFinite(fill)){return null}
if(fill==='start'){target=model.scaleBottom===undefined?scale.bottom:model.scaleBottom}else if(fill==='end'){target=model.scaleTop===undefined?scale.top:model.scaleTop}else if(model.scaleZero!==undefined){target=model.scaleZero}else if(scale.getBasePixel){target=scale.getBasePixel()}
if(target!==undefined&&target!==null){if(target.x!==undefined&&target.y!==undefined){return target}
if(helpers$1.isFinite(target)){horizontal=scale.isHorizontal();return{x:horizontal?target:null,y:horizontal?null:target}}}
return null}
function computeCircularBoundary(source){var scale=source.el._scale;var options=scale.options;var length=scale.chart.data.labels.length;var fill=source.fill;var target=[];var start,end,center,i,point;if(!length){return null}
start=options.ticks.reverse?scale.max:scale.min;end=options.ticks.reverse?scale.min:scale.max;center=scale.getPointPositionForValue(0,start);for(i=0;i<length;++i){point=fill==='start'||fill==='end'?scale.getPointPositionForValue(i,fill==='start'?start:end):scale.getBasePosition(i);if(options.gridLines.circular){point.cx=center.x;point.cy=center.y;point.angle=scale.getIndexAngle(i)-Math.PI/2}
target.push(point)}
return target}
function computeBoundary(source){var scale=source.el._scale||{};if(scale.getPointPositionForValue){return computeCircularBoundary(source)}
return computeLinearBoundary(source)}
function resolveTarget(sources,index,propagate){var source=sources[index];var fill=source.fill;var visited=[index];var target;if(!propagate){return fill}
while(fill!==!1&&visited.indexOf(fill)===-1){if(!isFinite(fill)){return fill}
target=sources[fill];if(!target){return!1}
if(target.visible){return fill}
visited.push(fill);fill=target.fill}
return!1}
function createMapper(source){var fill=source.fill;var type='dataset';if(fill===!1){return null}
if(!isFinite(fill)){type='boundary'}
return mappers[type](source)}
function isDrawable(point){return point&&!point.skip}
function drawArea(ctx,curve0,curve1,len0,len1){var i,cx,cy,r;if(!len0||!len1){return}
ctx.moveTo(curve0[0].x,curve0[0].y);for(i=1;i<len0;++i){helpers$1.canvas.lineTo(ctx,curve0[i-1],curve0[i])}
if(curve1[0].angle!==undefined){cx=curve1[0].cx;cy=curve1[0].cy;r=Math.sqrt(Math.pow(curve1[0].x-cx,2)+Math.pow(curve1[0].y-cy,2));for(i=len1-1;i>0;--i){ctx.arc(cx,cy,r,curve1[i].angle,curve1[i-1].angle,!0)}
return}
ctx.lineTo(curve1[len1-1].x,curve1[len1-1].y);for(i=len1-1;i>0;--i){helpers$1.canvas.lineTo(ctx,curve1[i],curve1[i-1],!0)}}
function doFill(ctx,points,mapper,view,color,loop){var count=points.length;var span=view.spanGaps;var curve0=[];var curve1=[];var len0=0;var len1=0;var i,ilen,index,p0,p1,d0,d1,loopOffset;ctx.beginPath();for(i=0,ilen=count;i<ilen;++i){index=i%count;p0=points[index]._view;p1=mapper(p0,index,view);d0=isDrawable(p0);d1=isDrawable(p1);if(loop&&loopOffset===undefined&&d0){loopOffset=i+1;ilen=count+loopOffset}
if(d0&&d1){len0=curve0.push(p0);len1=curve1.push(p1)}else if(len0&&len1){if(!span){drawArea(ctx,curve0,curve1,len0,len1);len0=len1=0;curve0=[];curve1=[]}else{if(d0){curve0.push(p0)}
if(d1){curve1.push(p1)}}}}
drawArea(ctx,curve0,curve1,len0,len1);ctx.closePath();ctx.fillStyle=color;ctx.fill()}
var plugin_filler={id:'filler',afterDatasetsUpdate:function(chart,options){var count=(chart.data.datasets||[]).length;var propagate=options.propagate;var sources=[];var meta,i,el,source;for(i=0;i<count;++i){meta=chart.getDatasetMeta(i);el=meta.dataset;source=null;if(el&&el._model&&el instanceof elements.Line){source={visible:chart.isDatasetVisible(i),fill:decodeFill(el,i,count),chart:chart,el:el}}
meta.$filler=source;sources.push(source)}
for(i=0;i<count;++i){source=sources[i];if(!source){continue}
source.fill=resolveTarget(sources,i,propagate);source.boundary=computeBoundary(source);source.mapper=createMapper(source)}},beforeDatasetsDraw:function(chart){var metasets=chart._getSortedVisibleDatasetMetas();var ctx=chart.ctx;var meta,i,el,view,points,mapper,color;for(i=metasets.length-1;i>=0;--i){meta=metasets[i].$filler;if(!meta||!meta.visible){continue}
el=meta.el;view=el._view;points=el._children||[];mapper=meta.mapper;color=view.backgroundColor||core_defaults.global.defaultColor;if(mapper&&color&&points.length){helpers$1.canvas.clipArea(ctx,chart.chartArea);doFill(ctx,points,mapper,view,color,el._loop);helpers$1.canvas.unclipArea(ctx)}}}};var getRtlHelper$1=helpers$1.rtl.getRtlAdapter;var noop$1=helpers$1.noop;var valueOrDefault$e=helpers$1.valueOrDefault;core_defaults._set('global',{legend:{display:!0,position:'top',align:'center',fullWidth:!0,reverse:!1,weight:1000,onClick:function(e,legendItem){var index=legendItem.datasetIndex;var ci=this.chart;var meta=ci.getDatasetMeta(index);meta.hidden=meta.hidden===null?!ci.data.datasets[index].hidden:null;ci.update()},onHover:null,onLeave:null,labels:{boxWidth:40,padding:10,generateLabels:function(chart){var datasets=chart.data.datasets;var options=chart.options.legend||{};var usePointStyle=options.labels&&options.labels.usePointStyle;return chart._getSortedDatasetMetas().map(function(meta){var style=meta.controller.getStyle(usePointStyle?0:undefined);return{text:datasets[meta.index].label,fillStyle:style.backgroundColor,hidden:!chart.isDatasetVisible(meta.index),lineCap:style.borderCapStyle,lineDash:style.borderDash,lineDashOffset:style.borderDashOffset,lineJoin:style.borderJoinStyle,lineWidth:style.borderWidth,strokeStyle:style.borderColor,pointStyle:style.pointStyle,rotation:style.rotation,datasetIndex:meta.index}},this)}}},legendCallback:function(chart){var list=document.createElement('ul');var datasets=chart.data.datasets;var i,ilen,listItem,listItemSpan;list.setAttribute('class',chart.id+'-legend');for(i=0,ilen=datasets.length;i<ilen;i++){listItem=list.appendChild(document.createElement('li'));listItemSpan=listItem.appendChild(document.createElement('span'));listItemSpan.style.backgroundColor=datasets[i].backgroundColor;if(datasets[i].label){listItem.appendChild(document.createTextNode(datasets[i].label))}}
return list.outerHTML}});function getBoxWidth(labelOpts,fontSize){return labelOpts.usePointStyle&&labelOpts.boxWidth>fontSize?fontSize:labelOpts.boxWidth}
var Legend=core_element.extend({initialize:function(config){var me=this;helpers$1.extend(me,config);me.legendHitBoxes=[];me._hoveredItem=null;me.doughnutMode=!1},beforeUpdate:noop$1,update:function(maxWidth,maxHeight,margins){var me=this;me.beforeUpdate();me.maxWidth=maxWidth;me.maxHeight=maxHeight;me.margins=margins;me.beforeSetDimensions();me.setDimensions();me.afterSetDimensions();me.beforeBuildLabels();me.buildLabels();me.afterBuildLabels();me.beforeFit();me.fit();me.afterFit();me.afterUpdate();return me.minSize},afterUpdate:noop$1,beforeSetDimensions:noop$1,setDimensions:function(){var me=this;if(me.isHorizontal()){me.width=me.maxWidth;me.left=0;me.right=me.width}else{me.height=me.maxHeight;me.top=0;me.bottom=me.height}
me.paddingLeft=0;me.paddingTop=0;me.paddingRight=0;me.paddingBottom=0;me.minSize={width:0,height:0}},afterSetDimensions:noop$1,beforeBuildLabels:noop$1,buildLabels:function(){var me=this;var labelOpts=me.options.labels||{};var legendItems=helpers$1.callback(labelOpts.generateLabels,[me.chart],me)||[];if(labelOpts.filter){legendItems=legendItems.filter(function(item){return labelOpts.filter(item,me.chart.data)})}
if(me.options.reverse){legendItems.reverse()}
me.legendItems=legendItems},afterBuildLabels:noop$1,beforeFit:noop$1,fit:function(){var me=this;var opts=me.options;var labelOpts=opts.labels;var display=opts.display;var ctx=me.ctx;var labelFont=helpers$1.options._parseFont(labelOpts);var fontSize=labelFont.size;var hitboxes=me.legendHitBoxes=[];var minSize=me.minSize;var isHorizontal=me.isHorizontal();if(isHorizontal){minSize.width=me.maxWidth;minSize.height=display?10:0}else{minSize.width=display?10:0;minSize.height=me.maxHeight}
if(!display){me.width=minSize.width=me.height=minSize.height=0;return}
ctx.font=labelFont.string;if(isHorizontal){var lineWidths=me.lineWidths=[0];var totalHeight=0;ctx.textAlign='left';ctx.textBaseline='middle';helpers$1.each(me.legendItems,function(legendItem,i){var boxWidth=getBoxWidth(labelOpts,fontSize);var width=boxWidth+(fontSize/2)+ctx.measureText(legendItem.text).width;if(i===0||lineWidths[lineWidths.length-1]+width+2*labelOpts.padding>minSize.width){totalHeight+=fontSize+labelOpts.padding;lineWidths[lineWidths.length-(i>0?0:1)]=0}
hitboxes[i]={left:0,top:0,width:width,height:fontSize};lineWidths[lineWidths.length-1]+=width+labelOpts.padding});minSize.height+=totalHeight}else{var vPadding=labelOpts.padding;var columnWidths=me.columnWidths=[];var columnHeights=me.columnHeights=[];var totalWidth=labelOpts.padding;var currentColWidth=0;var currentColHeight=0;helpers$1.each(me.legendItems,function(legendItem,i){var boxWidth=getBoxWidth(labelOpts,fontSize);var itemWidth=boxWidth+(fontSize/2)+ctx.measureText(legendItem.text).width;if(i>0&&currentColHeight+fontSize+2*vPadding>minSize.height){totalWidth+=currentColWidth+labelOpts.padding;columnWidths.push(currentColWidth);columnHeights.push(currentColHeight);currentColWidth=0;currentColHeight=0}
currentColWidth=Math.max(currentColWidth,itemWidth);currentColHeight+=fontSize+vPadding;hitboxes[i]={left:0,top:0,width:itemWidth,height:fontSize}});totalWidth+=currentColWidth;columnWidths.push(currentColWidth);columnHeights.push(currentColHeight);minSize.width+=totalWidth}
me.width=minSize.width;me.height=minSize.height},afterFit:noop$1,isHorizontal:function(){return this.options.position==='top'||this.options.position==='bottom'},draw:function(){var me=this;var opts=me.options;var labelOpts=opts.labels;var globalDefaults=core_defaults.global;var defaultColor=globalDefaults.defaultColor;var lineDefault=globalDefaults.elements.line;var legendHeight=me.height;var columnHeights=me.columnHeights;var legendWidth=me.width;var lineWidths=me.lineWidths;if(!opts.display){return}
var rtlHelper=getRtlHelper$1(opts.rtl,me.left,me.minSize.width);var ctx=me.ctx;var fontColor=valueOrDefault$e(labelOpts.fontColor,globalDefaults.defaultFontColor);var labelFont=helpers$1.options._parseFont(labelOpts);var fontSize=labelFont.size;var cursor;ctx.textAlign=rtlHelper.textAlign('left');ctx.textBaseline='middle';ctx.lineWidth=0.5;ctx.strokeStyle=fontColor;ctx.fillStyle=fontColor;ctx.font=labelFont.string;var boxWidth=getBoxWidth(labelOpts,fontSize);var hitboxes=me.legendHitBoxes;var drawLegendBox=function(x,y,legendItem){if(isNaN(boxWidth)||boxWidth<=0){return}
ctx.save();var lineWidth=valueOrDefault$e(legendItem.lineWidth,lineDefault.borderWidth);ctx.fillStyle=valueOrDefault$e(legendItem.fillStyle,defaultColor);ctx.lineCap=valueOrDefault$e(legendItem.lineCap,lineDefault.borderCapStyle);ctx.lineDashOffset=valueOrDefault$e(legendItem.lineDashOffset,lineDefault.borderDashOffset);ctx.lineJoin=valueOrDefault$e(legendItem.lineJoin,lineDefault.borderJoinStyle);ctx.lineWidth=lineWidth;ctx.strokeStyle=valueOrDefault$e(legendItem.strokeStyle,defaultColor);if(ctx.setLineDash){ctx.setLineDash(valueOrDefault$e(legendItem.lineDash,lineDefault.borderDash))}
if(labelOpts&&labelOpts.usePointStyle){var radius=boxWidth*Math.SQRT2/2;var centerX=rtlHelper.xPlus(x,boxWidth/2);var centerY=y+fontSize/2;helpers$1.canvas.drawPoint(ctx,legendItem.pointStyle,radius,centerX,centerY,legendItem.rotation)}else{ctx.fillRect(rtlHelper.leftForLtr(x,boxWidth),y,boxWidth,fontSize);if(lineWidth!==0){ctx.strokeRect(rtlHelper.leftForLtr(x,boxWidth),y,boxWidth,fontSize)}}
ctx.restore()};var fillText=function(x,y,legendItem,textWidth){var halfFontSize=fontSize/2;var xLeft=rtlHelper.xPlus(x,boxWidth+halfFontSize);var yMiddle=y+halfFontSize;ctx.fillText(legendItem.text,xLeft,yMiddle);if(legendItem.hidden){ctx.beginPath();ctx.lineWidth=2;ctx.moveTo(xLeft,yMiddle);ctx.lineTo(rtlHelper.xPlus(xLeft,textWidth),yMiddle);ctx.stroke()}};var alignmentOffset=function(dimension,blockSize){switch(opts.align){case 'start':return labelOpts.padding;case 'end':return dimension-blockSize;default:return(dimension-blockSize+labelOpts.padding)/2}};var isHorizontal=me.isHorizontal();if(isHorizontal){cursor={x:me.left+alignmentOffset(legendWidth,lineWidths[0]),y:me.top+labelOpts.padding,line:0}}else{cursor={x:me.left+labelOpts.padding,y:me.top+alignmentOffset(legendHeight,columnHeights[0]),line:0}}
helpers$1.rtl.overrideTextDirection(me.ctx,opts.textDirection);var itemHeight=fontSize+labelOpts.padding;helpers$1.each(me.legendItems,function(legendItem,i){var textWidth=ctx.measureText(legendItem.text).width;var width=boxWidth+(fontSize/2)+textWidth;var x=cursor.x;var y=cursor.y;rtlHelper.setWidth(me.minSize.width);if(isHorizontal){if(i>0&&x+width+labelOpts.padding>me.left+me.minSize.width){y=cursor.y+=itemHeight;cursor.line++;x=cursor.x=me.left+alignmentOffset(legendWidth,lineWidths[cursor.line])}}else if(i>0&&y+itemHeight>me.top+me.minSize.height){x=cursor.x=x+me.columnWidths[cursor.line]+labelOpts.padding;cursor.line++;y=cursor.y=me.top+alignmentOffset(legendHeight,columnHeights[cursor.line])}
var realX=rtlHelper.x(x);drawLegendBox(realX,y,legendItem);hitboxes[i].left=rtlHelper.leftForLtr(realX,hitboxes[i].width);hitboxes[i].top=y;fillText(realX,y,legendItem,textWidth);if(isHorizontal){cursor.x+=width+labelOpts.padding}else{cursor.y+=itemHeight}});helpers$1.rtl.restoreTextDirection(me.ctx,opts.textDirection)},_getLegendItemAt:function(x,y){var me=this;var i,hitBox,lh;if(x>=me.left&&x<=me.right&&y>=me.top&&y<=me.bottom){lh=me.legendHitBoxes;for(i=0;i<lh.length;++i){hitBox=lh[i];if(x>=hitBox.left&&x<=hitBox.left+hitBox.width&&y>=hitBox.top&&y<=hitBox.top+hitBox.height){return me.legendItems[i]}}}
return null},handleEvent:function(e){var me=this;var opts=me.options;var type=e.type==='mouseup'?'click':e.type;var hoveredItem;if(type==='mousemove'){if(!opts.onHover&&!opts.onLeave){return}}else if(type==='click'){if(!opts.onClick){return}}else{return}
hoveredItem=me._getLegendItemAt(e.x,e.y);if(type==='click'){if(hoveredItem&&opts.onClick){opts.onClick.call(me,e.native,hoveredItem)}}else{if(opts.onLeave&&hoveredItem!==me._hoveredItem){if(me._hoveredItem){opts.onLeave.call(me,e.native,me._hoveredItem)}
me._hoveredItem=hoveredItem}
if(opts.onHover&&hoveredItem){opts.onHover.call(me,e.native,hoveredItem)}}}});function createNewLegendAndAttach(chart,legendOpts){var legend=new Legend({ctx:chart.ctx,options:legendOpts,chart:chart});core_layouts.configure(chart,legend,legendOpts);core_layouts.addBox(chart,legend);chart.legend=legend}
var plugin_legend={id:'legend',_element:Legend,beforeInit:function(chart){var legendOpts=chart.options.legend;if(legendOpts){createNewLegendAndAttach(chart,legendOpts)}},beforeUpdate:function(chart){var legendOpts=chart.options.legend;var legend=chart.legend;if(legendOpts){helpers$1.mergeIf(legendOpts,core_defaults.global.legend);if(legend){core_layouts.configure(chart,legend,legendOpts);legend.options=legendOpts}else{createNewLegendAndAttach(chart,legendOpts)}}else if(legend){core_layouts.removeBox(chart,legend);delete chart.legend}},afterEvent:function(chart,e){var legend=chart.legend;if(legend){legend.handleEvent(e)}}};var noop$2=helpers$1.noop;core_defaults._set('global',{title:{display:!1,fontStyle:'bold',fullWidth:!0,padding:10,position:'top',text:'',weight:2000}});var Title=core_element.extend({initialize:function(config){var me=this;helpers$1.extend(me,config);me.legendHitBoxes=[]},beforeUpdate:noop$2,update:function(maxWidth,maxHeight,margins){var me=this;me.beforeUpdate();me.maxWidth=maxWidth;me.maxHeight=maxHeight;me.margins=margins;me.beforeSetDimensions();me.setDimensions();me.afterSetDimensions();me.beforeBuildLabels();me.buildLabels();me.afterBuildLabels();me.beforeFit();me.fit();me.afterFit();me.afterUpdate();return me.minSize},afterUpdate:noop$2,beforeSetDimensions:noop$2,setDimensions:function(){var me=this;if(me.isHorizontal()){me.width=me.maxWidth;me.left=0;me.right=me.width}else{me.height=me.maxHeight;me.top=0;me.bottom=me.height}
me.paddingLeft=0;me.paddingTop=0;me.paddingRight=0;me.paddingBottom=0;me.minSize={width:0,height:0}},afterSetDimensions:noop$2,beforeBuildLabels:noop$2,buildLabels:noop$2,afterBuildLabels:noop$2,beforeFit:noop$2,fit:function(){var me=this;var opts=me.options;var minSize=me.minSize={};var isHorizontal=me.isHorizontal();var lineCount,textSize;if(!opts.display){me.width=minSize.width=me.height=minSize.height=0;return}
lineCount=helpers$1.isArray(opts.text)?opts.text.length:1;textSize=lineCount*helpers$1.options._parseFont(opts).lineHeight+opts.padding*2;me.width=minSize.width=isHorizontal?me.maxWidth:textSize;me.height=minSize.height=isHorizontal?textSize:me.maxHeight},afterFit:noop$2,isHorizontal:function(){var pos=this.options.position;return pos==='top'||pos==='bottom'},draw:function(){var me=this;var ctx=me.ctx;var opts=me.options;if(!opts.display){return}
var fontOpts=helpers$1.options._parseFont(opts);var lineHeight=fontOpts.lineHeight;var offset=lineHeight/2+opts.padding;var rotation=0;var top=me.top;var left=me.left;var bottom=me.bottom;var right=me.right;var maxWidth,titleX,titleY;ctx.fillStyle=helpers$1.valueOrDefault(opts.fontColor,core_defaults.global.defaultFontColor);ctx.font=fontOpts.string;if(me.isHorizontal()){titleX=left+((right-left)/2);titleY=top+offset;maxWidth=right-left}else{titleX=opts.position==='left'?left+offset:right-offset;titleY=top+((bottom-top)/2);maxWidth=bottom-top;rotation=Math.PI*(opts.position==='left'?-0.5:0.5)}
ctx.save();ctx.translate(titleX,titleY);ctx.rotate(rotation);ctx.textAlign='center';ctx.textBaseline='middle';var text=opts.text;if(helpers$1.isArray(text)){var y=0;for(var i=0;i<text.length;++i){ctx.fillText(text[i],0,y,maxWidth);y+=lineHeight}}else{ctx.fillText(text,0,0,maxWidth)}
ctx.restore()}});function createNewTitleBlockAndAttach(chart,titleOpts){var title=new Title({ctx:chart.ctx,options:titleOpts,chart:chart});core_layouts.configure(chart,title,titleOpts);core_layouts.addBox(chart,title);chart.titleBlock=title}
var plugin_title={id:'title',_element:Title,beforeInit:function(chart){var titleOpts=chart.options.title;if(titleOpts){createNewTitleBlockAndAttach(chart,titleOpts)}},beforeUpdate:function(chart){var titleOpts=chart.options.title;var titleBlock=chart.titleBlock;if(titleOpts){helpers$1.mergeIf(titleOpts,core_defaults.global.title);if(titleBlock){core_layouts.configure(chart,titleBlock,titleOpts);titleBlock.options=titleOpts}else{createNewTitleBlockAndAttach(chart,titleOpts)}}else if(titleBlock){core_layouts.removeBox(chart,titleBlock);delete chart.titleBlock}}};var plugins={};var filler=plugin_filler;var legend=plugin_legend;var title=plugin_title;plugins.filler=filler;plugins.legend=legend;plugins.title=title;core_controller.helpers=helpers$1;core_helpers();core_controller._adapters=core_adapters;core_controller.Animation=core_animation;core_controller.animationService=core_animations;core_controller.controllers=controllers;core_controller.DatasetController=core_datasetController;core_controller.defaults=core_defaults;core_controller.Element=core_element;core_controller.elements=elements;core_controller.Interaction=core_interaction;core_controller.layouts=core_layouts;core_controller.platform=platform;core_controller.plugins=core_plugins;core_controller.Scale=core_scale;core_controller.scaleService=core_scaleService;core_controller.Ticks=core_ticks;core_controller.Tooltip=core_tooltip;core_controller.helpers.each(scales,function(scale,type){core_controller.scaleService.registerScaleType(type,scale,scale._defaults)});for(var k in plugins){if(plugins.hasOwnProperty(k)){core_controller.plugins.register(plugins[k])}}
core_controller.platform.initialize();var src=core_controller;if(typeof window!=='undefined'){window.Chart=core_controller}
core_controller.Chart=core_controller;core_controller.Legend=plugins.legend._element;core_controller.Title=plugins.title._element;core_controller.pluginService=core_controller.plugins;core_controller.PluginBase=core_controller.Element.extend({});core_controller.canvasHelpers=core_controller.helpers.canvas;core_controller.layoutService=core_controller.layouts;core_controller.LinearScaleBase=scale_linearbase;core_controller.helpers.each(['Bar','Bubble','Doughnut','Line','PolarArea','Radar','Scatter'],function(klass){core_controller[klass]=function(ctx,cfg){return new core_controller(ctx,core_controller.helpers.merge(cfg||{},{type:klass.charAt(0).toLowerCase()+klass.slice(1)}))}});return src})))